/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.List;
import java.util.Objects;

final class ExternalizedNextPrevElementVariableProcessor<Solution_> {
    private final ShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    private final int modifier;

    public static <Solution_> ExternalizedNextPrevElementVariableProcessor<Solution_> ofPrevious(PreviousElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        return new ExternalizedNextPrevElementVariableProcessor<Solution_>(shadowVariableDescriptor, -1);
    }

    public static <Solution_> ExternalizedNextPrevElementVariableProcessor<Solution_> ofNext(NextElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        return new ExternalizedNextPrevElementVariableProcessor<Solution_>(shadowVariableDescriptor, 1);
    }

    private ExternalizedNextPrevElementVariableProcessor(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor, int modifier) {
        this.shadowVariableDescriptor = Objects.requireNonNull(shadowVariableDescriptor);
        this.modifier = modifier;
    }

    public void setElement(InnerScoreDirector<Solution_, ?> scoreDirector, List<Object> listVariable, Object element, int index) {
        int target = index + this.modifier;
        if (target < 0 || target >= listVariable.size()) {
            this.setValue(scoreDirector, element, null);
        } else {
            this.setValue(scoreDirector, element, listVariable.get(target));
        }
    }

    private void setValue(InnerScoreDirector<Solution_, ?> scoreDirector, Object element, Object value) {
        if (this.getElement(element) != value) {
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
            this.shadowVariableDescriptor.setValue(element, value);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
        }
    }

    public Object getElement(Object element) {
        return this.shadowVariableDescriptor.getValue(element);
    }

    public void unsetElement(InnerScoreDirector<Solution_, ?> scoreDirector, Object element) {
        this.setValue(scoreDirector, element, null);
    }
}

