/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.domain.variable.AbstractVariableListener;
import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.VariableListenerWithSources;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.preview.api.domain.variable.declarative.ShadowSources;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DeclarativeShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    MemberAccessor calculator;
    RootVariableSource<?, ?>[] sources;
    String[] sourcePaths;

    public DeclarativeShadowVariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(ordinal, entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        Method method;
        if (!descriptorPolicy.isPreviewFeatureEnabled(PreviewFeature.DECLARATIVE_SHADOW_VARIABLES)) {
            throw new IllegalStateException("The member (%s) on the entity class (%s) is a declarative shadow variable, but the declarative shadow variable preview feature is disabled.\nMaybe enable declarative shadow variables in your %s?\n".formatted(this.variableMemberAccessor.getName(), this.entityDescriptor.getEntityClass().getName(), SolverConfig.class.getSimpleName()));
        }
        ShadowVariable annotation = this.variableMemberAccessor.getAnnotation(ShadowVariable.class);
        String methodName = annotation.supplierName();
        if (methodName.isEmpty()) {
            throw new IllegalStateException("DeclarativeShadowVariableDescriptor was created when method is empty.");
        }
        try {
            method = this.variableMemberAccessor.getDeclaringClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find method named %s on the class %s. Maybe you misspelled it?".formatted(methodName, this.variableMemberAccessor.getDeclaringClass().getSimpleName()), e);
        }
        ShadowSources shadowVariableUpdater = method.getAnnotation(ShadowSources.class);
        if (shadowVariableUpdater == null) {
            throw new IllegalArgumentException("Method \"%s\" referenced from @%s member %s is not annotated with @%s.\nMaybe annotate the method %s with @%s?\n".formatted(methodName, ShadowVariable.class.getSimpleName(), this.variableMemberAccessor, ShadowSources.class.getSimpleName(), methodName, ShadowSources.class.getSimpleName()));
        }
        this.calculator = this.entityDescriptor.getSolutionDescriptor().getMemberAccessorFactory().buildAndCacheMemberAccessor(method, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, ShadowSources.class, descriptorPolicy.getDomainAccessType());
        this.sourcePaths = shadowVariableUpdater.value();
        if (this.sourcePaths.length == 0) {
            throw new IllegalArgumentException("Method \"%s\" referenced from @%s member %s has no sources.\nA shadow variable must have at least one source (since otherwise it a constant).\nMaybe add one source?\n".formatted(methodName, ShadowVariable.class.getSimpleName(), this.variableMemberAccessor));
        }
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Class<? extends AbstractVariableListener>> getVariableListenerClasses() {
        return Collections.emptyList();
    }

    @Override
    public Demand<?> getProvidedDemand() {
        return null;
    }

    @Override
    public Iterable<VariableListenerWithSources<Solution_>> buildVariableListeners(SupplyManager supplyManager) {
        return Collections.emptyList();
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.sources = new RootVariableSource[this.sourcePaths.length];
        for (int i = 0; i < this.sources.length; ++i) {
            this.sources[i] = RootVariableSource.from(this.entityDescriptor.getSolutionDescriptor().getMetaModel(), this.entityDescriptor.getEntityClass(), this.variableMemberAccessor.getName(), this.sourcePaths[i], this.entityDescriptor.getSolutionDescriptor().getMemberAccessorFactory(), descriptorPolicy);
        }
    }

    public MemberAccessor getMemberAccessor() {
        return this.variableMemberAccessor;
    }

    public MemberAccessor getCalculator() {
        return this.calculator;
    }

    public RootVariableSource<?, ?>[] getSources() {
        return this.sources;
    }
}

