/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSession;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultShadowVariableSessionFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final IntFunction<TopologicalOrderGraph> graphCreator;

    public DefaultShadowVariableSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, InnerScoreDirector<Solution_, ?> scoreDirector, IntFunction<TopologicalOrderGraph> graphCreator) {
        this.solutionDescriptor = solutionDescriptor;
        this.scoreDirector = scoreDirector;
        this.graphCreator = graphCreator;
    }

    public static <Solution_> void visitGraph(SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraph<Solution_> variableReferenceGraph, Object[] entities, IntFunction<TopologicalOrderGraph> graphCreator) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors = solutionDescriptor.getDeclarativeShadowVariableDescriptors();
        HashMap variableIdToUpdater = new HashMap();
        HashMap declarativeShadowVariableToAliasMap = new HashMap();
        DefaultShadowVariableSessionFactory.createGraphNodes(variableReferenceGraph, entities, declarativeShadowVariableDescriptors, variableIdToUpdater, declarativeShadowVariableToAliasMap);
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable : declarativeShadowVariableDescriptors) {
            VariableMetaModel fromVariableId = declarativeShadowVariable.getVariableMetaModel();
            DefaultShadowVariableSessionFactory.createSourceChangeProcessors(variableReferenceGraph, declarativeShadowVariable, fromVariableId);
            DefaultShadowVariableSessionFactory.createAliasToVariableChangeProcessors(variableReferenceGraph, declarativeShadowVariableToAliasMap, fromVariableId);
        }
        DefaultShadowVariableSessionFactory.createFixedVariableRelationEdges(variableReferenceGraph, entities, declarativeShadowVariableDescriptors);
        variableReferenceGraph.createGraph(graphCreator);
    }

    private static <Solution_> void createGraphNodes(VariableReferenceGraph<Solution_> graph, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, Map<VariableMetaModel<?, ?, ?>, VariableUpdaterInfo> variableIdToUpdater, Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap) {
        for (Object entity : entities) {
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel variableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                VariableUpdaterInfo updater = variableIdToUpdater.computeIfAbsent(variableId, ignored -> new VariableUpdaterInfo(declarativeShadowVariableDescriptor, declarativeShadowVariableDescriptor.getEntityDescriptor().getShadowVariableLoopedDescriptor(), declarativeShadowVariableDescriptor.getMemberAccessor(), declarativeShadowVariableDescriptor.getCalculator()::executeGetter));
                graph.addVariableReferenceEntity(variableId, entity, updater);
                for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (source.downstreamDeclarativeVariableMetamodel() == null) continue;
                        declarativeShadowVariableToAliasMap.computeIfAbsent(source.downstreamDeclarativeVariableMetamodel(), ignored -> new LinkedHashSet()).add(source);
                    }
                }
            }
        }
    }

    private static <Solution_> void createSourceChangeProcessors(VariableReferenceGraph<Solution_> variableReferenceGraph, DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (RootVariableSource<?, ?> source : declarativeShadowVariable.getSources()) {
            for (VariableSourceReference sourcePart : source.variableSourceReferences()) {
                VariableMetaModel<?, ?, ?> toVariableId = sourcePart.variableMetaModel();
                if (sourcePart.isDeclarative()) continue;
                variableReferenceGraph.addAfterProcessor(toVariableId, (graph, entity) -> graph.markChanged(graph.lookup(fromVariableId, entity)));
            }
        }
    }

    private static <Solution_> void createAliasToVariableChangeProcessors(VariableReferenceGraph<Solution_> variableReferenceGraph, Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (VariableSourceReference alias : declarativeShadowVariableToAliasMap.getOrDefault(fromVariableId, Collections.emptySet())) {
            VariableMetaModel<?, ?, ?> toVariableId = alias.targetVariableMetamodel();
            VariableMetaModel<?, ?, ?> sourceVariableId = alias.variableMetaModel();
            if (alias.isDeclarative() || !alias.affectGraphEdges()) continue;
            variableReferenceGraph.addBeforeProcessor(sourceVariableId, (graph, toEntity) -> alias.targetEntityFunctionStartingFromVariableEntity().accept(toEntity, fromEntity -> graph.removeEdge(graph.lookup(fromVariableId, fromEntity), graph.lookup(toVariableId, toEntity))));
            variableReferenceGraph.addAfterProcessor(sourceVariableId, (graph, toEntity) -> alias.targetEntityFunctionStartingFromVariableEntity().accept(toEntity, fromEntity -> graph.addEdge(graph.lookup(fromVariableId, fromEntity), graph.lookup(toVariableId, toEntity))));
        }
    }

    private static <Solution_> void createFixedVariableRelationEdges(VariableReferenceGraph<Solution_> variableReferenceGraph, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors) {
        for (Object entity : entities) {
            for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel toVariableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                block2: for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (!source.isTopLevel() || !source.isDeclarative()) continue;
                        VariableMetaModel<?, ?, ?> fromVariableId = source.variableMetaModel();
                        sourceRoot.valueEntityFunction().accept(entity, fromEntity -> variableReferenceGraph.addFixedEdge(variableReferenceGraph.lookup(fromVariableId, fromEntity), variableReferenceGraph.lookup(toVariableId, entity)));
                        continue block2;
                    }
                }
            }
        }
    }

    public DefaultShadowVariableSession<Solution_> forSolution(Solution_ solution) {
        ArrayList entities = new ArrayList();
        this.solutionDescriptor.visitAllEntities(solution, entities::add);
        return this.forEntities(entities.toArray());
    }

    public DefaultShadowVariableSession<Solution_> forEntities(Object ... entities) {
        VariableReferenceGraph<Solution_> variableReferenceGraph = new VariableReferenceGraph<Solution_>(ChangedVariableNotifier.of(this.scoreDirector));
        DefaultShadowVariableSessionFactory.visitGraph(this.solutionDescriptor, variableReferenceGraph, entities, this.graphCreator);
        return new DefaultShadowVariableSession<Solution_>(variableReferenceGraph);
    }
}

