/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.variable.declarative.ShadowSources;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;

public record RootVariableSource<Entity_, Value_>(Class<? extends Entity_> rootEntity, BiConsumer<Object, Consumer<Value_>> valueEntityFunction, List<VariableSourceReference> variableSourceReferences) {
    public static final String COLLECTION_REFERENCE_SUFFIX = "[]";
    public static final String MEMBER_SEPERATOR_REGEX = "\\.";

    public static <Entity_, Value_> RootVariableSource<Entity_, Value_> from(PlanningSolutionMetaModel<?> solutionMetaModel, Class<? extends Entity_> rootEntityClass, String targetVariableName, String variablePath, MemberAccessorFactory memberAccessorFactory, DescriptorPolicy descriptorPolicy) {
        String[] pathParts = variablePath.split(MEMBER_SEPERATOR_REGEX);
        ArrayList<MemberAccessor> chainToVariable = new ArrayList<MemberAccessor>();
        ArrayList<MemberAccessor> listMemberAccessors = new ArrayList<MemberAccessor>();
        boolean hasListMemberAccessor = false;
        ArrayList chainStartingFromSourceVariableList = new ArrayList();
        boolean isAfterVariable = false;
        Class<Object> currentEntity = rootEntityClass;
        int factCount = 0;
        for (String pathPart : pathParts) {
            if (pathPart.endsWith(COLLECTION_REFERENCE_SUFFIX)) {
                if (isAfterVariable) {
                    throw new IllegalArgumentException("The source path (%s) starting from root class (%s) accesses a collection (%s) after a variable (%s), which is not allowed.".formatted(variablePath, rootEntityClass.getSimpleName(), pathPart, ((MemberAccessor)((List)chainStartingFromSourceVariableList.get(0)).get(0)).getName()));
                }
                if (hasListMemberAccessor) {
                    throw new IllegalArgumentException("The source path (%s) starting from root class (%s) accesses a collection (%s) after another collection (%s), which is not allowed.".formatted(variablePath, rootEntityClass.getSimpleName(), pathPart, ((MemberAccessor)listMemberAccessors.get(listMemberAccessors.size() - 1)).getName()));
                }
                String memberName = pathPart.substring(0, pathPart.length() - COLLECTION_REFERENCE_SUFFIX.length());
                MemberAccessor memberAccessor = RootVariableSource.getMemberAccessor(rootEntityClass, variablePath, currentEntity, memberName, memberAccessorFactory, descriptorPolicy);
                listMemberAccessors.add(memberAccessor);
                chainToVariable = new ArrayList();
                factCount = 0;
                currentEntity = ConfigUtils.extractGenericTypeParameterOrFail(ShadowSources.class.getSimpleName(), currentEntity, memberAccessor.getType(), memberAccessor.getGenericType(), ShadowSources.class, memberAccessor.getName());
                hasListMemberAccessor = true;
                continue;
            }
            MemberAccessor memberAccessor = RootVariableSource.getMemberAccessor(rootEntityClass, variablePath, currentEntity, pathPart, memberAccessorFactory, descriptorPolicy);
            if (!hasListMemberAccessor) {
                listMemberAccessors.add(memberAccessor);
            }
            boolean isVariable = false;
            for (Class<Annotation> clazz : EntityDescriptor.getVariableAnnotationClasses()) {
                if (RootVariableSource.getAnnotation(currentEntity, memberAccessor.getName(), clazz) == null) continue;
                isVariable = true;
                break;
            }
            chainToVariable.add(memberAccessor);
            for (List list : chainStartingFromSourceVariableList) {
                list.add(memberAccessor);
            }
            if (isVariable) {
                ArrayList<MemberAccessor> chainStartingFromSourceVariable = new ArrayList<MemberAccessor>();
                chainStartingFromSourceVariable.add(memberAccessor);
                chainStartingFromSourceVariableList.add(chainStartingFromSourceVariable);
                isAfterVariable = true;
                factCount = 0;
            } else if (++factCount == 2) {
                throw new IllegalArgumentException("The source path (%s) starting from root entity (%s) referencing multiple facts (%s, %s) in a row.".formatted(variablePath, rootEntityClass.getSimpleName(), ((MemberAccessor)chainToVariable.get(chainToVariable.size() - 2)).getName(), ((MemberAccessor)chainToVariable.get(chainToVariable.size() - 1)).getName()));
            }
            currentEntity = memberAccessor.getType();
        }
        List<MemberAccessor> chainToVariableEntity = chainToVariable.subList(0, chainToVariable.size() - 1);
        BiConsumer<Object, Consumer<Value_>> valueEntityFunction = !hasListMemberAccessor ? RootVariableSource.getRegularSourceEntityVisitor(chainToVariableEntity) : RootVariableSource.getCollectionSourceEntityVisitor(listMemberAccessors, chainToVariableEntity);
        ArrayList<VariableSourceReference> variableSourceReferences = new ArrayList<VariableSourceReference>();
        for (int i = 0; i < chainStartingFromSourceVariableList.size(); ++i) {
            List chainStartingFromSourceVariable = (List)chainStartingFromSourceVariableList.get(i);
            VariableSourceReference newSourceReference = RootVariableSource.createVariableSourceReferenceFromChain(solutionMetaModel, rootEntityClass, targetVariableName, chainStartingFromSourceVariable, chainToVariable, i == 0, i == chainStartingFromSourceVariableList.size() - 1);
            variableSourceReferences.add(newSourceReference);
        }
        if (variableSourceReferences.isEmpty()) {
            throw new IllegalArgumentException("The source path (%s) starting from root entity class (%s) does not reference any variables.".formatted(variablePath, rootEntityClass.getSimpleName()));
        }
        for (VariableSourceReference variableSourceReference : variableSourceReferences) {
            RootVariableSource.assertIsValidVariableReference(rootEntityClass, variablePath, variableSourceReference);
        }
        return new RootVariableSource<Entity_, Value_>(rootEntityClass, valueEntityFunction, variableSourceReferences);
    }

    private static <Value_> @NonNull BiConsumer<Object, Consumer<Value_>> getRegularSourceEntityVisitor(List<MemberAccessor> finalChainToVariable) {
        return (entity, consumer) -> {
            Object current = entity;
            for (MemberAccessor accessor : finalChainToVariable) {
                current = accessor.executeGetter(current);
                if (current != null) continue;
                return;
            }
            consumer.accept(current);
        };
    }

    private static <Value_> @NonNull BiConsumer<Object, Consumer<Value_>> getCollectionSourceEntityVisitor(List<MemberAccessor> listMemberAccessors, List<MemberAccessor> finalChainToVariable) {
        BiConsumer entityListMemberAccessor = RootVariableSource.getRegularSourceEntityVisitor(listMemberAccessors);
        BiConsumer elementSourceEntityVisitor = RootVariableSource.getRegularSourceEntityVisitor(finalChainToVariable);
        return (entity, consumer) -> entityListMemberAccessor.accept(entity, iterable -> {
            for (Object item : iterable) {
                elementSourceEntityVisitor.accept(item, (Consumer)consumer);
            }
        });
    }

    private static <Entity_> @NonNull VariableSourceReference createVariableSourceReferenceFromChain(PlanningSolutionMetaModel<?> solutionMetaModel, Class<? extends Entity_> rootEntityClass, String targetVariableName, List<MemberAccessor> afterChain, List<MemberAccessor> chainToVariable, boolean isTopLevel, boolean isBottomLevel) {
        MemberAccessor variableMemberAccessor = afterChain.get(0);
        VariablePath sourceVariablePath = new VariablePath(variableMemberAccessor.getDeclaringClass(), variableMemberAccessor.getName(), chainToVariable.subList(0, chainToVariable.size() - afterChain.size()), afterChain);
        VariableMetaModel downstreamDeclarativeVariable = null;
        MemberAccessor maybeDownstreamVariable = afterChain.remove(afterChain.size() - 1);
        if (RootVariableSource.isDeclarativeShadowVariable(maybeDownstreamVariable)) {
            downstreamDeclarativeVariable = solutionMetaModel.entity(maybeDownstreamVariable.getDeclaringClass()).variable(maybeDownstreamVariable.getName());
        }
        return new VariableSourceReference(solutionMetaModel.entity(variableMemberAccessor.getDeclaringClass()).variable(variableMemberAccessor.getName()), sourceVariablePath.memberAccessorsBeforeEntity, isTopLevel, isBottomLevel, RootVariableSource.isDeclarativeShadowVariable(variableMemberAccessor), solutionMetaModel.entity(rootEntityClass).variable(targetVariableName), downstreamDeclarativeVariable, sourceVariablePath.getValueVisitorFromVariableEntity());
    }

    private static void assertIsValidVariableReference(Class<?> rootEntityClass, String variablePath, VariableSourceReference variableSourceReference) {
        VariableMetaModel<?, ?, ?> sourceVariableId = variableSourceReference.variableMetaModel();
        if (variableSourceReference.isDeclarative() && variableSourceReference.downstreamDeclarativeVariableMetamodel() != null && !variableSourceReference.isBottomLevel()) {
            throw new IllegalArgumentException("The source path (%s) starting from root entity class (%s) accesses a declarative shadow variable (%s) from another declarative shadow variable (%s).".formatted(variablePath, rootEntityClass.getSimpleName(), variableSourceReference.downstreamDeclarativeVariableMetamodel().name(), sourceVariableId.name()));
        }
        if (!variableSourceReference.isDeclarative() && !variableSourceReference.chainToVariableEntity().isEmpty()) {
            throw new IllegalArgumentException("The source path (%s) starting from root entity class (%s) accesses a non-declarative shadow variable (%s) not from the root entity or collection.".formatted(variablePath, rootEntityClass.getSimpleName(), variableSourceReference.variableMetaModel().name()));
        }
    }

    private static MemberAccessor getMemberAccessor(Class<?> rootClass, String sourcePath, Class<?> declaringClass, String memberName, MemberAccessorFactory memberAccessorFactory, DescriptorPolicy descriptorPolicy) {
        AccessibleObject member = ReflectionHelper.getDeclaredField(declaringClass, memberName);
        if (member == null && (member = ReflectionHelper.getDeclaredGetterMethod(declaringClass, memberName)) == null) {
            throw new IllegalArgumentException("The source path (%s) starting from root class (%s) references a member (%s) on class (%s) that does not exist.".formatted(sourcePath, rootClass.getSimpleName(), memberName, declaringClass.getSimpleName()));
        }
        return memberAccessorFactory.buildAndCacheMemberAccessor((Member)((Object)member), MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD, descriptorPolicy.getDomainAccessType());
    }

    private static <T extends Annotation> T getAnnotation(Class<?> declaringClass, String memberName, Class<? extends T> annotationClass) {
        Field field = ReflectionHelper.getDeclaredField(declaringClass, memberName);
        Method getterMethod = ReflectionHelper.getDeclaredGetterMethod(declaringClass, memberName);
        if (field != null && field.getAnnotation(annotationClass) != null) {
            return field.getAnnotation(annotationClass);
        }
        if (getterMethod != null && getterMethod.getAnnotation(annotationClass) != null) {
            return getterMethod.getAnnotation(annotationClass);
        }
        return null;
    }

    private static boolean isDeclarativeShadowVariable(MemberAccessor memberAccessor) {
        ShadowVariable shadowVariable = RootVariableSource.getAnnotation(memberAccessor.getDeclaringClass(), memberAccessor.getName(), ShadowVariable.class);
        if (shadowVariable == null) {
            return false;
        }
        return !shadowVariable.supplierName().isEmpty();
    }

    private record VariablePath(Class<?> variableEntityClass, String variableName, List<MemberAccessor> memberAccessorsBeforeEntity, List<MemberAccessor> memberAccessorsAfterEntity) {
        public BiConsumer<Object, Consumer<Object>> getValueVisitorFromVariableEntity() {
            return (entity, consumer) -> {
                Object currentEntity = entity;
                for (MemberAccessor member : this.memberAccessorsAfterEntity) {
                    currentEntity = member.executeGetter(currentEntity);
                    if (currentEntity != null) continue;
                    return;
                }
                consumer.accept(currentEntity);
            };
        }
    }
}

