/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityVariablePair;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.ShadowVariableLoopedVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;

public class VariableReferenceGraph<Solution_> {
    private final Map<VariableMetaModel<?, ?, ?>, Map<Object, EntityVariablePair>> variableReferenceToInstanceMap;
    private final List<EntityVariablePair> instanceList;
    private final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    private final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<VariableReferenceGraph<Solution_>, Object>>> variableReferenceToBeforeProcessor;
    private final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<VariableReferenceGraph<Solution_>, Object>>> variableReferenceToAfterProcessor;
    private final Map<EntityVariablePair, List<EntityVariablePair>> fixedEdges;
    private final IdentityHashMap<Object, List<EntityVariablePair>> entityToVariableReferenceMap;
    private int[][] counts;
    private TopologicalOrderGraph graph;
    private BitSet changed;

    public VariableReferenceGraph(ChangedVariableNotifier<Solution_> changedVariableNotifier) {
        this.changedVariableNotifier = changedVariableNotifier;
        this.variableReferenceToInstanceMap = new HashMap();
        this.instanceList = new ArrayList<EntityVariablePair>();
        this.variableReferenceToBeforeProcessor = new HashMap();
        this.variableReferenceToAfterProcessor = new HashMap();
        this.fixedEdges = new HashMap<EntityVariablePair, List<EntityVariablePair>>();
        this.entityToVariableReferenceMap = new IdentityHashMap();
    }

    public <Entity_> EntityVariablePair addVariableReferenceEntity(VariableMetaModel<?, ?, ?> variableId, Entity_ entity, VariableUpdaterInfo variableReference) {
        if (this.variableReferenceToInstanceMap.containsKey(variableId) && this.variableReferenceToInstanceMap.get(variableId).containsKey(entity)) {
            return this.variableReferenceToInstanceMap.get(variableId).get(entity);
        }
        EntityVariablePair node = new EntityVariablePair(entity, variableId, variableReference, this.instanceList.size());
        this.variableReferenceToInstanceMap.computeIfAbsent(variableId, k -> new IdentityHashMap()).put(entity, node);
        this.instanceList.add(node);
        return node;
    }

    public void addBeforeProcessor(VariableMetaModel<?, ?, ?> variableId, BiConsumer<VariableReferenceGraph<Solution_>, Object> consumer) {
        this.variableReferenceToBeforeProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public void addAfterProcessor(VariableMetaModel<?, ?, ?> variableId, BiConsumer<VariableReferenceGraph<Solution_>, Object> consumer) {
        this.variableReferenceToAfterProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public void createGraph(IntFunction<TopologicalOrderGraph> graphCreator) {
        this.counts = new int[this.instanceList.size()][this.instanceList.size()];
        this.graph = graphCreator.apply(this.instanceList.size());
        this.graph.withNodeData(this.instanceList);
        this.changed = new BitSet(this.instanceList.size());
        this.graph.startBatchChange();
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        for (EntityVariablePair entityVariablePair : this.instanceList) {
            if (visited.add(entityVariablePair.entity())) {
                for (VariableMetaModel<Object, Object, Object> variableMetaModel : this.variableReferenceToAfterProcessor.keySet()) {
                    if (!variableMetaModel.entity().type().isInstance(entityVariablePair.entity())) continue;
                    this.afterVariableChanged(variableMetaModel, entityVariablePair.entity());
                }
            }
            this.entityToVariableReferenceMap.computeIfAbsent(entityVariablePair.entity(), ignored -> new ArrayList()).add(entityVariablePair);
        }
        for (Map.Entry entry : this.fixedEdges.entrySet()) {
            for (EntityVariablePair entityVariablePair : (List)entry.getValue()) {
                this.addEdge((EntityVariablePair)entry.getKey(), entityVariablePair);
            }
        }
    }

    public EntityVariablePair lookup(VariableMetaModel<?, ?, ?> variableId, Object entity) {
        return (EntityVariablePair)this.variableReferenceToInstanceMap.getOrDefault(variableId, Collections.emptyMap()).get(entity);
    }

    public void addFixedEdge(EntityVariablePair from, EntityVariablePair to) {
        if (from.graphNodeId() == to.graphNodeId()) {
            return;
        }
        this.fixedEdges.computeIfAbsent(from, k -> new ArrayList()).add(to);
    }

    public void addEdge(EntityVariablePair from, EntityVariablePair to) {
        if (from.graphNodeId() == to.graphNodeId()) {
            return;
        }
        if (this.changed.isEmpty()) {
            this.graph.startBatchChange();
        }
        int[] nArray = this.counts[from.graphNodeId()];
        int n = to.graphNodeId();
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        int oldCount = n2;
        if (oldCount == 0) {
            this.graph.addEdge(from.graphNodeId(), to.graphNodeId());
        }
        this.markChanged(to);
    }

    public void removeEdge(EntityVariablePair from, EntityVariablePair to) {
        if (from.graphNodeId() == to.graphNodeId()) {
            return;
        }
        if (this.changed.isEmpty()) {
            this.graph.startBatchChange();
        }
        int[] nArray = this.counts[from.graphNodeId()];
        int n = to.graphNodeId();
        nArray[n] = nArray[n] - 1;
        int newCount = nArray[n];
        if (newCount == 0) {
            this.graph.removeEdge(from.graphNodeId(), to.graphNodeId());
        }
        this.markChanged(to);
    }

    public void markChanged(EntityVariablePair node) {
        if (this.changed.isEmpty()) {
            this.graph.startBatchChange();
        }
        this.changed.set(node.graphNodeId());
    }

    public void updateChanged() {
        this.graph.endBatchChange();
        boolean[] visited = new boolean[this.instanceList.size()];
        LoopedTracker loopedTracker = new LoopedTracker(visited.length);
        Set<AffectedEntity> affectedEntities = Collections.newSetFromMap(new IdentityHashMap());
        PriorityQueue<AffectedShadowVariable> nodeHeap = this.createInitialChangeQueue();
        while (!nodeHeap.isEmpty()) {
            int nextNode = nodeHeap.poll().nodeId;
            if (visited[nextNode]) continue;
            visited[nextNode] = true;
            EntityVariablePair shadowVariable = this.instanceList.get(nextNode);
            boolean isChanged = this.updateShadowVariable(shadowVariable, this.graph.isLooped(loopedTracker, nextNode), affectedEntities);
            if (!isChanged) continue;
            this.graph.nodeForwardEdges(nextNode).forEachRemaining(node -> {
                if (!visited[node]) {
                    nodeHeap.add(new AffectedShadowVariable(node, this.graph.getTopologicalOrder(node)));
                }
            });
        }
        this.updateInvalidityStatusOfAffectedEntities(affectedEntities, loopedTracker);
    }

    private boolean updateShadowVariable(EntityVariablePair shadowVariable, boolean isLooped, Set<AffectedEntity> affectedEntities) {
        boolean isChanged = false;
        Object entity = shadowVariable.entity();
        VariableUpdaterInfo shadowVariableReference = shadowVariable.variableReference();
        Object oldValue = shadowVariableReference.memberAccessor().executeGetter(entity);
        if (isLooped) {
            isChanged = true;
            affectedEntities.add(new AffectedEntity(entity, shadowVariableReference));
            if (oldValue != null) {
                this.changedVariableNotifier.beforeVariableChanged().accept(shadowVariableReference.variableDescriptor(), entity);
                shadowVariableReference.memberAccessor().executeSetter(entity, null);
                this.changedVariableNotifier.afterVariableChanged().accept(shadowVariableReference.variableDescriptor(), entity);
            }
        } else {
            Object newValue = shadowVariableReference.calculator().apply(entity);
            if (!Objects.equals(oldValue, newValue)) {
                affectedEntities.add(new AffectedEntity(entity, shadowVariableReference));
                this.changedVariableNotifier.beforeVariableChanged().accept(shadowVariableReference.variableDescriptor(), entity);
                shadowVariableReference.memberAccessor().executeSetter(entity, newValue);
                this.changedVariableNotifier.afterVariableChanged().accept(shadowVariableReference.variableDescriptor(), entity);
                isChanged = true;
            }
        }
        return isChanged;
    }

    private PriorityQueue<AffectedShadowVariable> createInitialChangeQueue() {
        PriorityQueue<AffectedShadowVariable> heap = new PriorityQueue<AffectedShadowVariable>(this.instanceList.size());
        int i = this.changed.nextSetBit(0);
        while (i >= 0) {
            int topologicalOrder = this.graph.getTopologicalOrder(i);
            heap.add(new AffectedShadowVariable(i, topologicalOrder));
            if (i == Integer.MAX_VALUE) break;
            i = this.changed.nextSetBit(i + 1);
        }
        this.changed.clear();
        return heap;
    }

    private void updateInvalidityStatusOfAffectedEntities(Set<AffectedEntity> affectedEntities, LoopedTracker loopedTracker) {
        for (AffectedEntity affectedEntity : affectedEntities) {
            Object oldValue;
            ShadowVariableLoopedVariableDescriptor<?> shadowVariableLoopedDescriptor = affectedEntity.variableUpdaterInfo.shadowVariableLoopedDescriptor();
            if (shadowVariableLoopedDescriptor == null) continue;
            Object entity = affectedEntity.entity;
            boolean isEntityLooped = false;
            for (EntityVariablePair node : this.entityToVariableReferenceMap.get(entity)) {
                if (!this.graph.isLooped(loopedTracker, node.graphNodeId())) continue;
                isEntityLooped = true;
                break;
            }
            if (Objects.equals(oldValue = shadowVariableLoopedDescriptor.getValue(entity), isEntityLooped)) continue;
            this.changedVariableNotifier.beforeVariableChanged().accept(shadowVariableLoopedDescriptor, entity);
            shadowVariableLoopedDescriptor.setValue(entity, isEntityLooped);
            this.changedVariableNotifier.afterVariableChanged().accept(shadowVariableLoopedDescriptor, entity);
        }
    }

    public void beforeVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (variableReference.entity().type().isInstance(entity)) {
            List updaterList = this.variableReferenceToBeforeProcessor.getOrDefault(variableReference, Collections.emptyList());
            for (BiConsumer consumer : updaterList) {
                consumer.accept(this, entity);
            }
        }
    }

    public void afterVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (variableReference.entity().type().isInstance(entity)) {
            List updaterList = this.variableReferenceToAfterProcessor.getOrDefault(variableReference, Collections.emptyList());
            EntityVariablePair node = this.lookup(variableReference, entity);
            if (node != null) {
                this.markChanged(node);
            }
            for (BiConsumer consumer : updaterList) {
                consumer.accept(this, entity);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{\n");
        for (int from = 0; from < this.counts.length; ++from) {
            boolean first = true;
            for (int to = 0; to < this.counts.length; ++to) {
                if (this.counts[from][to] == 0) continue;
                if (first) {
                    first = false;
                    builder.append("    \"").append(this.instanceList.get(from)).append("\": [");
                } else {
                    builder.append(", ");
                }
                builder.append("\"%s\"".formatted(this.instanceList.get(to)));
            }
            if (first) continue;
            builder.append("],\n");
        }
        builder.append("}");
        return builder.toString();
    }

    record AffectedShadowVariable(int nodeId, int topologicalIndex) implements Comparable<AffectedShadowVariable>
    {
        @Override
        public int compareTo(AffectedShadowVariable heapItem) {
            return this.topologicalIndex - heapItem.topologicalIndex;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof AffectedShadowVariable) {
                AffectedShadowVariable other = (AffectedShadowVariable)o;
                return this.nodeId == other.nodeId;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.nodeId;
        }
    }

    record AffectedEntity(Object entity, VariableUpdaterInfo variableUpdaterInfo) {
        @Override
        public boolean equals(Object o) {
            if (o instanceof AffectedEntity) {
                AffectedEntity other = (AffectedEntity)o;
                return this.entity == other.entity;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.entity);
        }
    }
}

