/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support.violation;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.ListVariableTracker;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableId;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableSnapshot;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableSnapshotTotal;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableTracker;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class SolutionTracker<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final List<VariableTracker<Solution_>> normalVariableTrackers;
    private final List<ListVariableTracker<Solution_>> listVariableTrackers;
    private List<String> missingEventsForward;
    private List<String> missingEventsBackward;
    Solution_ beforeMoveSolution;
    VariableSnapshotTotal<Solution_> beforeVariables;
    Solution_ afterMoveSolution;
    VariableSnapshotTotal<Solution_> afterVariables;
    Solution_ afterUndoSolution;
    VariableSnapshotTotal<Solution_> undoVariables;
    VariableSnapshotTotal<Solution_> undoFromScratchVariables;
    VariableSnapshotTotal<Solution_> beforeFromScratchVariables;

    public SolutionTracker(SolutionDescriptor<Solution_> solutionDescriptor, SupplyManager supplyManager) {
        this.solutionDescriptor = solutionDescriptor;
        this.normalVariableTrackers = new ArrayList<VariableTracker<Solution_>>();
        this.listVariableTrackers = new ArrayList<ListVariableTracker<Solution_>>();
        for (EntityDescriptor<Solution_> entityDescriptor : solutionDescriptor.getEntityDescriptors()) {
            for (VariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                if (variableDescriptor instanceof ListVariableDescriptor) {
                    ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
                    this.listVariableTrackers.add(new ListVariableTracker(listVariableDescriptor));
                    continue;
                }
                this.normalVariableTrackers.add(new VariableTracker<Solution_>(variableDescriptor));
            }
        }
        this.normalVariableTrackers.forEach(tracker -> supplyManager.demand(tracker.demand()));
        this.listVariableTrackers.forEach(tracker -> supplyManager.demand(tracker.demand()));
    }

    public Solution_ getBeforeMoveSolution() {
        return this.beforeMoveSolution;
    }

    public Solution_ getAfterMoveSolution() {
        return this.afterMoveSolution;
    }

    public Solution_ getAfterUndoSolution() {
        return this.afterUndoSolution;
    }

    public void setBeforeMoveSolution(Solution_ workingSolution) {
        this.beforeVariables = VariableSnapshotTotal.takeSnapshot(this.solutionDescriptor, workingSolution);
        this.beforeMoveSolution = this.cloneSolution(workingSolution);
    }

    public void setAfterMoveSolution(Solution_ workingSolution) {
        this.afterVariables = VariableSnapshotTotal.takeSnapshot(this.solutionDescriptor, workingSolution);
        this.afterMoveSolution = this.cloneSolution(workingSolution);
        if (this.beforeVariables != null) {
            this.missingEventsForward = this.getEntitiesMissingBeforeAfterEvents(this.beforeVariables, this.afterVariables);
        } else {
            this.missingEventsBackward = Collections.emptyList();
        }
    }

    public void setAfterUndoSolution(Solution_ workingSolution) {
        this.undoVariables = VariableSnapshotTotal.takeSnapshot(this.solutionDescriptor, workingSolution);
        this.afterUndoSolution = this.cloneSolution(workingSolution);
        this.missingEventsBackward = this.beforeVariables != null ? this.getEntitiesMissingBeforeAfterEvents(this.undoVariables, this.afterVariables) : Collections.emptyList();
    }

    public void setUndoFromScratchSolution(Solution_ workingSolution) {
        this.undoFromScratchVariables = VariableSnapshotTotal.takeSnapshot(this.solutionDescriptor, workingSolution);
    }

    public void setBeforeFromScratchSolution(Solution_ workingSolution) {
        this.beforeFromScratchVariables = VariableSnapshotTotal.takeSnapshot(this.solutionDescriptor, workingSolution);
    }

    private Solution_ cloneSolution(Solution_ workingSolution) {
        return this.solutionDescriptor.getSolutionCloner().cloneSolution(workingSolution);
    }

    public void restoreBeforeSolution() {
        this.beforeVariables.restore();
    }

    private List<String> getEntitiesMissingBeforeAfterEvents(VariableSnapshotTotal<Solution_> beforeSolution, VariableSnapshotTotal<Solution_> afterSolution) {
        ArrayList<String> out = new ArrayList<String>();
        List<VariableId<Solution_>> changes = afterSolution.changedVariablesFrom(beforeSolution);
        for (VariableTracker<Solution_> variableTracker : this.normalVariableTrackers) {
            out.addAll(variableTracker.getEntitiesMissingBeforeAfterEvents(changes));
        }
        for (ListVariableTracker listVariableTracker : this.listVariableTrackers) {
            out.addAll(listVariableTracker.getEntitiesMissingBeforeAfterEvents(changes));
        }
        return out;
    }

    public String buildScoreCorruptionMessage() {
        if (this.beforeMoveSolution == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        List<String> changedBetweenBeforeAndUndo = SolutionTracker.getVariableChangedViolations(this.beforeVariables, this.undoVariables);
        List<String> changedBetweenBeforeAndScratch = SolutionTracker.getVariableChangedViolations(this.beforeFromScratchVariables, this.beforeVariables);
        List<String> changedBetweenUndoAndScratch = SolutionTracker.getVariableChangedViolations(this.undoFromScratchVariables, this.undoVariables);
        if (!changedBetweenBeforeAndUndo.isEmpty()) {
            out.append("Variables that are different between before and undo:\n%s\n".formatted(SolutionTracker.formatList(changedBetweenBeforeAndUndo)));
        }
        if (!changedBetweenBeforeAndScratch.isEmpty()) {
            out.append("Variables that are different between from scratch and before:\n%s\n".formatted(SolutionTracker.formatList(changedBetweenBeforeAndScratch)));
        }
        if (!changedBetweenUndoAndScratch.isEmpty()) {
            out.append("Variables that are different between from scratch and undo:\n%s\n".formatted(SolutionTracker.formatList(changedBetweenUndoAndScratch)));
        }
        if (!this.missingEventsForward.isEmpty()) {
            out.append("Missing variable listener events for actual move:\n%s\n".formatted(SolutionTracker.formatList(this.missingEventsForward)));
        }
        if (!this.missingEventsBackward.isEmpty()) {
            out.append("Missing variable listener events for undo move:\")\n%s\n".formatted(SolutionTracker.formatList(this.missingEventsBackward)));
        }
        if (out.isEmpty()) {
            return "Genuine and shadow variables agree with from scratch calculation after the undo move and match the state prior to the move.";
        }
        return out.toString();
    }

    static <Solution_> List<String> getVariableChangedViolations(VariableSnapshotTotal<Solution_> expectedSnapshot, VariableSnapshotTotal<Solution_> actualSnapshot) {
        ArrayList<String> out = new ArrayList<String>();
        List<VariableId<Solution_>> changedVariables = expectedSnapshot.changedVariablesFrom(actualSnapshot);
        for (VariableId<Solution_> changedVariable : changedVariables) {
            VariableSnapshot<Solution_> expectedSnapshotVariable = expectedSnapshot.getVariableSnapshot(changedVariable);
            VariableSnapshot<Solution_> actualSnapshotVariable = actualSnapshot.getVariableSnapshot(changedVariable);
            out.add("Actual value (%s) of variable %s on %s entity (%s) differs from expected (%s)".formatted(actualSnapshotVariable.getValue(), expectedSnapshotVariable.getVariableDescriptor().getVariableName(), expectedSnapshotVariable.getVariableDescriptor().getEntityDescriptor().getEntityClass().getSimpleName(), expectedSnapshotVariable.getEntity(), expectedSnapshotVariable.getValue()));
        }
        return out;
    }

    static String formatList(List<String> messages) {
        int LIMIT = 5;
        if (messages.isEmpty()) {
            return "";
        }
        if (messages.size() <= 5) {
            return messages.stream().collect(Collectors.joining("\n  - ", "  - ", "\n"));
        }
        return messages.stream().limit(5L).collect(Collectors.joining("\n  - ", "  - ", "\n  ...(" + (messages.size() - 5) + " more)\n"));
    }
}

