/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch.node.comparator;

import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import java.util.Comparator;

public class BreadthFirstNodeComparator
implements Comparator<ExhaustiveSearchNode> {
    private final boolean scoreBounderEnabled;

    public BreadthFirstNodeComparator(boolean scoreBounderEnabled) {
        this.scoreBounderEnabled = scoreBounderEnabled;
    }

    @Override
    public int compare(ExhaustiveSearchNode a, ExhaustiveSearchNode b) {
        Object bScore;
        int bDepth;
        int aDepth = a.getDepth();
        if (aDepth < (bDepth = b.getDepth())) {
            return 1;
        }
        if (aDepth > bDepth) {
            return -1;
        }
        Object aScore = a.getScore().raw();
        int scoreComparison = aScore.compareTo(bScore = b.getScore().raw());
        if (scoreComparison < 0) {
            return -1;
        }
        if (scoreComparison > 0) {
            return 1;
        }
        if (this.scoreBounderEnabled) {
            int optimisticBoundComparison = a.getOptimisticBound().compareTo(b.getOptimisticBound());
            if (optimisticBoundComparison < 0) {
                return -1;
            }
            if (optimisticBoundComparison > 0) {
                return 1;
            }
        }
        return Long.compare(b.getBreadth(), a.getBreadth());
    }
}

