/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch.node.comparator;

import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import java.util.Comparator;

public class OptimisticBoundFirstNodeComparator
implements Comparator<ExhaustiveSearchNode> {
    public OptimisticBoundFirstNodeComparator(boolean scoreBounderEnabled) {
        if (!scoreBounderEnabled) {
            throw new IllegalArgumentException("This %s only works if scoreBounderEnabled (%s) is true.".formatted(this.getClass().getSimpleName(), scoreBounderEnabled));
        }
    }

    @Override
    public int compare(ExhaustiveSearchNode a, ExhaustiveSearchNode b) {
        long bParentBreadth;
        int bDepth;
        Object bScore;
        int optimisticBoundComparison = a.getOptimisticBound().compareTo(b.getOptimisticBound());
        if (optimisticBoundComparison < 0) {
            return -1;
        }
        if (optimisticBoundComparison > 0) {
            return 1;
        }
        Object aScore = a.getScore().raw();
        int scoreComparison = aScore.compareTo(bScore = b.getScore().raw());
        if (scoreComparison < 0) {
            return -1;
        }
        if (scoreComparison > 0) {
            return 1;
        }
        int aDepth = a.getDepth();
        if (aDepth < (bDepth = b.getDepth())) {
            return -1;
        }
        if (aDepth > bDepth) {
            return 1;
        }
        long aParentBreadth = a.getParentBreadth();
        if (aParentBreadth < (bParentBreadth = b.getParentBreadth())) {
            return -1;
        }
        if (aParentBreadth > bParentBreadth) {
            return 1;
        }
        return Long.compare(b.getBreadth(), a.getBreadth());
    }
}

