/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubList;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.TriangleElementFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.TriangularNumbers;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.Objects;

public class RandomSubListSelector<Solution_>
extends AbstractSelector<Solution_>
implements SubListSelector<Solution_> {
    private final EntitySelector<Solution_> entitySelector;
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final int minimumSubListSize;
    private final int maximumSubListSize;
    private TriangleElementFactory triangleElementFactory;
    private ListVariableStateSupply<Solution_> listVariableStateSupply;

    public RandomSubListSelector(EntitySelector<Solution_> entitySelector, EntityIndependentValueSelector<Solution_> valueSelector, int minimumSubListSize, int maximumSubListSize) {
        this.entitySelector = entitySelector;
        this.valueSelector = ListChangeMoveSelector.filterPinnedListPlanningVariableValuesWithIndex(valueSelector, this::getListVariableStateSupply);
        this.listVariableDescriptor = (ListVariableDescriptor)valueSelector.getVariableDescriptor();
        if (minimumSubListSize < 1) {
            throw new IllegalArgumentException("The minimumSubListSize (" + minimumSubListSize + ") must be greater than 0.");
        }
        if (minimumSubListSize > maximumSubListSize) {
            throw new IllegalArgumentException("The minimumSubListSize (" + minimumSubListSize + ") must be less than or equal to the maximumSubListSize (" + maximumSubListSize + ").");
        }
        this.minimumSubListSize = minimumSubListSize;
        this.maximumSubListSize = maximumSubListSize;
        this.phaseLifecycleSupport.addEventListener(this.entitySelector);
        this.phaseLifecycleSupport.addEventListener(this.valueSelector);
    }

    private ListVariableStateSupply<Solution_> getListVariableStateSupply() {
        return Objects.requireNonNull(this.listVariableStateSupply, "Impossible state: The listVariableStateSupply is not initialized yet.");
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.triangleElementFactory = new TriangleElementFactory(this.minimumSubListSize, this.maximumSubListSize, this.workingRandom);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.listVariableStateSupply = (ListVariableStateSupply)supplyManager.demand(this.listVariableDescriptor.getStateDemand());
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.listVariableStateSupply = null;
    }

    @Override
    public ListVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.listVariableDescriptor;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long subListCount = 0L;
        for (Object entity : this.entitySelector::endingIterator) {
            int listSize = this.listVariableDescriptor.getUnpinnedSubListSize(entity);
            if (listSize < this.minimumSubListSize) continue;
            subListCount += (long)TriangularNumbers.nthTriangle(listSize - this.minimumSubListSize + 1);
            if (listSize <= this.maximumSubListSize) continue;
            subListCount -= (long)TriangularNumbers.nthTriangle(listSize - this.maximumSubListSize);
        }
        return subListCount;
    }

    @Override
    public Iterator<Object> endingValueIterator() {
        return this.valueSelector.endingIterator(null);
    }

    @Override
    public long getValueCount() {
        return this.valueSelector.getSize();
    }

    @Override
    public Iterator<SubList> iterator() {
        int biggestListSize = 0;
        for (Object entity : this.entitySelector::endingIterator) {
            biggestListSize = Math.max(biggestListSize, this.listVariableDescriptor.getUnpinnedSubListSize(entity));
        }
        if (biggestListSize < this.minimumSubListSize) {
            return new UpcomingSelectionIterator<SubList>(){

                @Override
                protected SubList createUpcomingSelection() {
                    return (SubList)this.noUpcomingSelection();
                }
            };
        }
        return new RandomSubListIterator(this.valueSelector.iterator());
    }

    public int getMinimumSubListSize() {
        return this.minimumSubListSize;
    }

    public int getMaximumSubListSize() {
        return this.maximumSubListSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.valueSelector) + ")";
    }

    private final class RandomSubListIterator
    extends UpcomingSelectionIterator<SubList> {
        private final Iterator<Object> valueIterator;

        private RandomSubListIterator(Iterator<Object> valueIterator) {
            this.valueIterator = valueIterator;
        }

        @Override
        protected SubList createUpcomingSelection() {
            Object sourceEntity = null;
            int listSize = 0;
            int firstUnpinnedIndex = 0;
            while (listSize < RandomSubListSelector.this.minimumSubListSize) {
                if (!this.valueIterator.hasNext()) {
                    throw new IllegalStateException("The valueIterator (" + String.valueOf(this.valueIterator) + ") should never end.");
                }
                Object value = this.valueIterator.next();
                sourceEntity = RandomSubListSelector.this.listVariableStateSupply.getInverseSingleton(value);
                if (sourceEntity == null) continue;
                firstUnpinnedIndex = RandomSubListSelector.this.listVariableDescriptor.getFirstUnpinnedIndex(sourceEntity);
                listSize = RandomSubListSelector.this.listVariableDescriptor.getListSize(sourceEntity) - firstUnpinnedIndex;
            }
            TriangleElementFactory.TriangleElement triangleElement = RandomSubListSelector.this.triangleElementFactory.nextElement(listSize);
            int subListLength = listSize - triangleElement.level() + 1;
            if (subListLength < 1) {
                throw new IllegalStateException("Impossible state: The subListLength (%s) must be greater than 0.".formatted(subListLength));
            }
            int sourceIndex = triangleElement.indexOnLevel() - 1 + firstUnpinnedIndex;
            return new SubList(sourceEntity, sourceIndex, subListLength);
        }
    }
}

