/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.AbstractFromConfigFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.RandomSubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.MimicRecordingSubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.MimicReplayingSubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.SubListMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.Objects;

public final class SubListSelectorFactory<Solution_>
extends AbstractFromConfigFactory<Solution_, SubListSelectorConfig> {
    private static final int DEFAULT_MINIMUM_SUB_LIST_SIZE = 1;
    private static final int DEFAULT_MAXIMUM_SUB_LIST_SIZE = Integer.MAX_VALUE;

    private SubListSelectorFactory(SubListSelectorConfig config) {
        super(config);
    }

    public static <Solution_> SubListSelectorFactory<Solution_> create(SubListSelectorConfig subListSelectorConfig) {
        return new SubListSelectorFactory<Solution_>(subListSelectorConfig);
    }

    public SubListSelector<Solution_> buildSubListSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (((SubListSelectorConfig)this.config).getMimicSelectorRef() != null) {
            return this.buildMimicReplaying(configPolicy);
        }
        if (inheritedSelectionOrder != SelectionOrder.RANDOM) {
            throw new IllegalArgumentException("The subListSelector (" + String.valueOf(this.config) + ") has an inheritedSelectionOrder(" + String.valueOf((Object)inheritedSelectionOrder) + ") which is not supported. SubListSelector only supports random selection order.");
        }
        EntityIndependentValueSelector<Solution_> valueSelector = this.buildEntityIndependentValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, inheritedSelectionOrder);
        int minimumSubListSize = Objects.requireNonNullElse(((SubListSelectorConfig)this.config).getMinimumSubListSize(), 1);
        int maximumSubListSize = Objects.requireNonNullElse(((SubListSelectorConfig)this.config).getMaximumSubListSize(), Integer.MAX_VALUE);
        RandomSubListSelector<Solution_> baseSubListSelector = new RandomSubListSelector<Solution_>(entitySelector, valueSelector, minimumSubListSize, maximumSubListSize);
        SubListSelector<Solution_> subListSelector = this.applyNearbySelection(configPolicy, minimumCacheType, inheritedSelectionOrder, baseSubListSelector);
        subListSelector = this.applyMimicRecording(configPolicy, subListSelector);
        return subListSelector;
    }

    SubListSelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (((SubListSelectorConfig)this.config).getId() != null || ((SubListSelectorConfig)this.config).getMinimumSubListSize() != null || ((SubListSelectorConfig)this.config).getMaximumSubListSize() != null || ((SubListSelectorConfig)this.config).getValueSelectorConfig() != null || ((SubListSelectorConfig)this.config).getNearbySelectionConfig() != null) {
            throw new IllegalArgumentException("The subListSelectorConfig (" + String.valueOf(this.config) + ") with mimicSelectorRef (" + ((SubListSelectorConfig)this.config).getMimicSelectorRef() + ") has another property that is not null.");
        }
        SubListMimicRecorder<Solution_> subListMimicRecorder = configPolicy.getSubListMimicRecorder(((SubListSelectorConfig)this.config).getMimicSelectorRef());
        if (subListMimicRecorder == null) {
            throw new IllegalArgumentException("The subListSelectorConfig (" + String.valueOf(this.config) + ") has a mimicSelectorRef (" + ((SubListSelectorConfig)this.config).getMimicSelectorRef() + ") for which no subListSelector with that id exists (in its solver phase).");
        }
        return new MimicReplayingSubListSelector<Solution_>(subListMimicRecorder);
    }

    private SubListSelector<Solution_> applyMimicRecording(HeuristicConfigPolicy<Solution_> configPolicy, SubListSelector<Solution_> subListSelector) {
        String id = ((SubListSelectorConfig)this.config).getId();
        if (id != null) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("The subListSelectorConfig (%s) has an empty id (%s).".formatted(this.config, id));
            }
            MimicRecordingSubListSelector<Solution_> mimicRecordingSubListSelector = new MimicRecordingSubListSelector<Solution_>(subListSelector);
            configPolicy.addSubListMimicRecorder(id, mimicRecordingSubListSelector);
            subListSelector = mimicRecordingSubListSelector;
        }
        return subListSelector;
    }

    private SubListSelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, RandomSubListSelector<Solution_> subListSelector) {
        NearbySelectionConfig nearbySelectionConfig = ((SubListSelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig == null) {
            return subListSelector;
        }
        return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((SubListSelectorConfig)this.config, configPolicy, minimumCacheType, resolvedSelectionOrder, subListSelector);
    }

    private EntityIndependentValueSelector<Solution_> buildEntityIndependentValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelectorConfig valueSelectorConfig = Objects.requireNonNullElseGet(((SubListSelectorConfig)this.config).getValueSelectorConfig(), ValueSelectorConfig::new);
        ValueSelector valueSelector = ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder);
        GenuineVariableDescriptor solutionGenuineVariableDescriptor = valueSelector.getVariableDescriptor();
        if (!solutionGenuineVariableDescriptor.isListVariable()) {
            throw new IllegalArgumentException("The subListSelector (" + String.valueOf(this.config) + ") can only be used when the domain model has a list variable. Check your @" + PlanningEntity.class.getSimpleName() + " and make sure it has a @" + PlanningListVariable.class.getSimpleName() + ".");
        }
        if (!(valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The subListSelector (" + String.valueOf(this.config) + ") for a list variable needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + String.valueOf(valueSelector) + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
        }
        return (EntityIndependentValueSelector)valueSelector;
    }
}

