/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained;

import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.KOptMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Arrays;
import java.util.Iterator;

public class KOptMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    protected final EntitySelector<Solution_> entitySelector;
    protected final ValueSelector<Solution_>[] valueSelectors;
    protected final boolean randomSelection;
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected SingletonInverseVariableSupply inverseVariableSupply;
    protected AnchorVariableSupply anchorVariableSupply;

    public KOptMoveSelector(EntitySelector<Solution_> entitySelector, ValueSelector<Solution_>[] valueSelectors, boolean randomSelection) {
        BasicVariableDescriptor basicVariableDescriptor;
        boolean isChained;
        this.entitySelector = entitySelector;
        this.valueSelectors = valueSelectors;
        this.randomSelection = randomSelection;
        if (!randomSelection) {
            throw new UnsupportedOperationException("Non randomSelection (such as original selection) is not yet supported on " + KOptMoveSelector.class.getSimpleName() + ".");
        }
        this.variableDescriptor = valueSelectors[0].getVariableDescriptor();
        GenuineVariableDescriptor<Solution_> genuineVariableDescriptor = this.variableDescriptor;
        boolean bl = isChained = genuineVariableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)genuineVariableDescriptor).isChained();
        if (!isChained) {
            throw new IllegalStateException("The selector (%s)'s valueSelector's variableDescriptor (%s) must be chained (%s).".formatted(this, this.variableDescriptor, isChained));
        }
        if (!this.variableDescriptor.getEntityDescriptor().getEntityClass().isAssignableFrom(entitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a valueSelector with a entityClass (" + String.valueOf(this.variableDescriptor.getEntityDescriptor().getEntityClass()) + ") which is not equal or a superclass to the entitySelector's entityClass (" + String.valueOf(entitySelector.getEntityDescriptor().getEntityClass()) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        for (ValueSelector<Solution_> valueSelector : valueSelectors) {
            if (valueSelector.getVariableDescriptor() != this.variableDescriptor) {
                throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a valueSelector with a variableDescriptor (" + String.valueOf(valueSelector.getVariableDescriptor()) + ") that differs from the first variableDescriptor (" + String.valueOf(this.variableDescriptor) + ").");
            }
            this.phaseLifecycleSupport.addEventListener(valueSelector);
        }
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand<Solution_>(this.variableDescriptor));
        this.anchorVariableSupply = supplyManager.demand(new AnchorVariableDemand<Solution_>(this.variableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.anchorVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        if (!this.entitySelector.isCountable()) {
            return false;
        }
        for (ValueSelector<Solution_> valueSelector : this.valueSelectors) {
            if (valueSelector.isCountable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        if (this.randomSelection || this.entitySelector.isNeverEnding()) {
            return true;
        }
        for (ValueSelector<Solution_> valueSelector : this.valueSelectors) {
            if (!valueSelector.isNeverEnding()) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            throw new UnsupportedOperationException("Non randomSelection (such as original selection) is not yet supported on " + KOptMoveSelector.class.getSimpleName() + ".");
        }
        final Iterator entityIterator = this.entitySelector.iterator();
        return new UpcomingSelectionIterator<Move<Solution_>>(){

            @Override
            protected Move<Solution_> createUpcomingSelection() {
                if (!entityIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                Object entity = entityIterator.next();
                Object[] values = new Object[KOptMoveSelector.this.valueSelectors.length];
                for (int i = 0; i < KOptMoveSelector.this.valueSelectors.length; ++i) {
                    Iterator<Object> valueIterator = KOptMoveSelector.this.valueSelectors[i].iterator(entity);
                    if (!valueIterator.hasNext()) {
                        return (Move)this.noUpcomingSelection();
                    }
                    values[i] = valueIterator.next();
                }
                return new KOptMove(KOptMoveSelector.this.variableDescriptor, KOptMoveSelector.this.inverseVariableSupply, KOptMoveSelector.this.anchorVariableSupply, entity, values);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.entitySelector) + ", " + Arrays.toString(this.valueSelectors) + ")";
    }
}

