/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin.ListRuinRecreateMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

final class ListRuinRecreateMoveIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final SolverScope<Solution_> solverScope;
    private final ListVariableStateSupply<Solution_> listVariableStateSupply;
    private final int minimumRuinedCount;
    private final int maximumRuinedCount;
    private final Random workingRandom;

    public ListRuinRecreateMoveIterator(EntityIndependentValueSelector<Solution_> valueSelector, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, SolverScope<Solution_> solverScope, ListVariableStateSupply<Solution_> listVariableStateSupply, int minimumRuinedCount, int maximumRuinedCount, Random workingRandom) {
        this.valueSelector = valueSelector;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.solverScope = solverScope;
        this.listVariableStateSupply = listVariableStateSupply;
        this.minimumRuinedCount = minimumRuinedCount;
        this.maximumRuinedCount = maximumRuinedCount;
        this.workingRandom = workingRandom;
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        Iterator valueIterator = this.valueSelector.iterator();
        int ruinedCount = this.workingRandom.nextInt(this.minimumRuinedCount, this.maximumRuinedCount + 1);
        ArrayList<Object> selectedValueList = new ArrayList<Object>(ruinedCount);
        Set<Object> affectedEntitySet = CollectionUtils.newLinkedHashSet(ruinedCount);
        Set selectedValueSet = Collections.newSetFromMap(CollectionUtils.newIdentityHashMap(ruinedCount));
        block0: for (int i = 0; i < ruinedCount; ++i) {
            int remainingAttempts = ruinedCount;
            do {
                if (!valueIterator.hasNext()) {
                    return NoChangeMove.getInstance();
                }
                Object selectedValue = valueIterator.next();
                if (!selectedValueSet.add(selectedValue)) continue;
                selectedValueList.add(selectedValue);
                Object affectedEntity = this.listVariableStateSupply.getInverseSingleton(selectedValue);
                if (affectedEntity == null) continue block0;
                affectedEntitySet.add(affectedEntity);
                continue block0;
            } while (--remainingAttempts != 0);
            return NoChangeMove.getInstance();
        }
        return new ListRuinRecreateMove<Solution_>(this.listVariableStateSupply.getSourceVariableDescriptor(), this.constructionHeuristicPhaseBuilder, this.solverScope, (List<Object>)selectedValueList, affectedEntitySet);
    }
}

