/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.EntityIndependentFilteringValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;

public class FilteringValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements ValueSelector<Solution_> {
    protected final ValueSelector<Solution_> childValueSelector;
    final SelectionFilter<Solution_, Object> selectionFilter;
    protected final boolean bailOutEnabled;
    private ScoreDirector<Solution_> scoreDirector = null;

    public static <Solution_> ValueSelector<Solution_> of(ValueSelector<Solution_> valueSelector, SelectionFilter<Solution_, Object> filter) {
        if (valueSelector instanceof EntityIndependentFilteringValueSelector) {
            EntityIndependentFilteringValueSelector filteringValueSelector = (EntityIndependentFilteringValueSelector)valueSelector;
            return new EntityIndependentFilteringValueSelector((EntityIndependentValueSelector)filteringValueSelector.childValueSelector, SelectionFilter.compose(filteringValueSelector.selectionFilter, filter));
        }
        if (valueSelector instanceof FilteringValueSelector) {
            FilteringValueSelector filteringValueSelector = (FilteringValueSelector)valueSelector;
            return new FilteringValueSelector<Solution_>(filteringValueSelector.childValueSelector, SelectionFilter.compose(filteringValueSelector.selectionFilter, filter));
        }
        if (valueSelector instanceof EntityIndependentValueSelector) {
            EntityIndependentValueSelector entityIndependentValueSelector = (EntityIndependentValueSelector)valueSelector;
            return new EntityIndependentFilteringValueSelector<Solution_>(entityIndependentValueSelector, filter);
        }
        return new FilteringValueSelector<Solution_>(valueSelector, filter);
    }

    public static <Solution_> ValueSelector<Solution_> ofAssigned(ValueSelector<Solution_> valueSelector, Supplier<ListVariableStateSupply<Solution_>> listVariableStateSupplier) {
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)valueSelector.getVariableDescriptor();
        if (!listVariableDescriptor.allowsUnassignedValues()) {
            return valueSelector;
        }
        return FilteringValueSelector.of(valueSelector, (scoreDirector, selection) -> {
            ListVariableStateSupply listVariableStateSupply = (ListVariableStateSupply)listVariableStateSupplier.get();
            if (listVariableStateSupply.getUnassignedCount() == 0) {
                return true;
            }
            return listVariableStateSupply.isAssigned(selection);
        });
    }

    public static <Solution_> EntityIndependentValueSelector<Solution_> ofAssigned(EntityIndependentValueSelector<Solution_> entityIndependentValueSelector, Supplier<ListVariableStateSupply<Solution_>> listVariableStateSupplier) {
        return (EntityIndependentValueSelector)FilteringValueSelector.ofAssigned(entityIndependentValueSelector, listVariableStateSupplier);
    }

    protected FilteringValueSelector(ValueSelector<Solution_> childValueSelector, SelectionFilter<Solution_, Object> filter) {
        this.childValueSelector = Objects.requireNonNull(childValueSelector);
        this.selectionFilter = Objects.requireNonNull(filter);
        this.bailOutEnabled = childValueSelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new JustInTimeFilteringValueIterator(this.childValueSelector.iterator(entity), this.determineBailOutSize(entity));
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new JustInTimeFilteringValueIterator(this.childValueSelector.endingIterator(entity), this.determineBailOutSize(entity));
    }

    protected long determineBailOutSize(Object entity) {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childValueSelector.getSize(entity) * 10L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FilteringValueSelector)) return false;
        FilteringValueSelector that = (FilteringValueSelector)o;
        if (!Objects.equals(this.childValueSelector, that.childValueSelector)) return false;
        if (!Objects.equals(this.selectionFilter, that.selectionFilter)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childValueSelector, this.selectionFilter);
    }

    public String toString() {
        return "Filtering(" + String.valueOf(this.childValueSelector) + ")";
    }

    protected class JustInTimeFilteringValueIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> childValueIterator;
        private final long bailOutSize;

        public JustInTimeFilteringValueIterator(Iterator<Object> childValueIterator, long bailOutSize) {
            this.childValueIterator = childValueIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childValueIterator.hasNext()) {
                    return this.noUpcomingSelection();
                }
                if (!FilteringValueSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringValueSelector.this.logger.trace("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringValueSelector.this);
                    return this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!FilteringValueSelector.this.selectionFilter.accept(FilteringValueSelector.this.scoreDirector, next = this.childValueIterator.next()));
            return next;
        }
    }
}

