/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.lateacceptance;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import java.util.Arrays;

public class DiversifiedLateAcceptanceAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected InnerScore<?> lateWorseScore;
    protected int lateWorseOccurrences = -1;
    protected int lateAcceptanceSize = -1;
    protected InnerScore<?>[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateAcceptanceSize(int lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.validate();
        this.previousScores = new InnerScore[this.lateAcceptanceSize];
        InnerScore initialScore = phaseScope.getBestScore();
        Arrays.fill(this.previousScores, initialScore);
        this.lateScoreIndex = 0;
        this.lateWorseOccurrences = this.lateAcceptanceSize;
        this.lateWorseScore = initialScore;
    }

    private void validate() {
        if (this.lateAcceptanceSize <= 0) {
            throw new IllegalArgumentException("The lateAcceptanceSize (%d) cannot be negative or zero.".formatted(this.lateAcceptanceSize));
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        boolean currentScoreBetter;
        InnerScore lateScore;
        int currentScoreCmp;
        boolean accept;
        InnerScore current;
        InnerScore moveScore = moveScope.getScore();
        InnerScore previous = current = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
        boolean bl = accept = moveScore.compareTo(current) == 0 || moveScore.compareTo(this.getLateWorseScore()) > 0;
        if (accept) {
            current = moveScore;
        }
        boolean currentScoreWorse = (currentScoreCmp = current.compareTo(lateScore = this.getPreviousScore(this.lateScoreIndex))) < 0;
        boolean bl2 = currentScoreBetter = currentScoreCmp > 0 && current.compareTo(previous) > 0;
        if (currentScoreWorse || currentScoreBetter) {
            this.updateLateScore(current);
        }
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateAcceptanceSize;
        return accept;
    }

    private <Score_ extends Score<Score_>> void updateLateScore(InnerScore<Score_> newScore) {
        boolean lateScoreEqual;
        InnerScore<Score_> castLateWorse = this.getLateWorseScore();
        int newScoreWorseCmp = newScore.compareTo(castLateWorse);
        InnerScore<Score_> lateScore = this.getPreviousScore(this.lateScoreIndex);
        boolean bl = lateScoreEqual = lateScore.compareTo(castLateWorse) == 0;
        if (newScoreWorseCmp < 0) {
            castLateWorse = newScore;
            this.lateWorseOccurrences = 1;
        } else if (lateScoreEqual && newScoreWorseCmp != 0) {
            --this.lateWorseOccurrences;
        } else if (!lateScoreEqual && newScoreWorseCmp == 0) {
            ++this.lateWorseOccurrences;
        }
        this.previousScores[this.lateScoreIndex] = newScore;
        if (this.lateWorseOccurrences == 0) {
            castLateWorse = this.getPreviousScore(0);
            this.lateWorseOccurrences = 1;
            for (int i = 1; i < this.lateAcceptanceSize; ++i) {
                InnerScore<Score_> previousScore = this.getPreviousScore(i);
                int scoreCmp = previousScore.compareTo(castLateWorse);
                if (scoreCmp < 0) {
                    castLateWorse = previousScore;
                    this.lateWorseOccurrences = 1;
                    continue;
                }
                if (scoreCmp != 0) continue;
                ++this.lateWorseOccurrences;
            }
        }
        this.lateWorseScore = castLateWorse;
    }

    private <Score_ extends Score<Score_>> InnerScore<Score_> getLateWorseScore() {
        return this.lateWorseScore;
    }

    private <Score_ extends Score<Score_>> InnerScore<Score_> getPreviousScore(int lateScoreIndex) {
        return this.previousScores[lateScoreIndex];
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
        this.lateWorseScore = null;
        this.lateWorseOccurrences = -1;
    }
}

