/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.tabu;

import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.tabu.size.TabuSizeStrategy;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractTabuAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected final String logIndentation;
    protected TabuSizeStrategy<Solution_> tabuSizeStrategy = null;
    protected TabuSizeStrategy<Solution_> fadingTabuSizeStrategy = null;
    protected boolean aspirationEnabled = true;
    protected boolean assertTabuHashCodeCorrectness = false;
    protected Map<Object, Integer> tabuToStepIndexMap;
    protected Deque<Object> tabuSequenceDeque;
    protected int workingTabuSize = -1;
    protected int workingFadingTabuSize = -1;

    public AbstractTabuAcceptor(String logIndentation) {
        this.logIndentation = logIndentation;
    }

    public void setTabuSizeStrategy(TabuSizeStrategy<Solution_> tabuSizeStrategy) {
        this.tabuSizeStrategy = tabuSizeStrategy;
    }

    public void setFadingTabuSizeStrategy(TabuSizeStrategy<Solution_> fadingTabuSizeStrategy) {
        this.fadingTabuSizeStrategy = fadingTabuSizeStrategy;
    }

    public void setAspirationEnabled(boolean aspirationEnabled) {
        this.aspirationEnabled = aspirationEnabled;
    }

    public void setAssertTabuHashCodeCorrectness(boolean assertTabuHashCodeCorrectness) {
        this.assertTabuHashCodeCorrectness = assertTabuHashCodeCorrectness;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        AbstractStepScope lastCompletedStepScope = phaseScope.getLastCompletedStepScope();
        this.workingTabuSize = this.tabuSizeStrategy == null ? 0 : this.tabuSizeStrategy.determineTabuSize((LocalSearchStepScope<Solution_>)lastCompletedStepScope);
        this.workingFadingTabuSize = this.fadingTabuSizeStrategy == null ? 0 : this.fadingTabuSizeStrategy.determineTabuSize((LocalSearchStepScope<Solution_>)lastCompletedStepScope);
        int totalTabuListSize = this.workingTabuSize + this.workingFadingTabuSize;
        this.tabuToStepIndexMap = new HashMap<Object, Integer>(totalTabuListSize);
        this.tabuSequenceDeque = new ArrayDeque<Object>();
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.tabuToStepIndexMap = null;
        this.tabuSequenceDeque = null;
        this.workingTabuSize = -1;
        this.workingFadingTabuSize = -1;
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.workingTabuSize = this.tabuSizeStrategy == null ? 0 : this.tabuSizeStrategy.determineTabuSize(stepScope);
        this.workingFadingTabuSize = this.fadingTabuSizeStrategy == null ? 0 : this.fadingTabuSizeStrategy.determineTabuSize(stepScope);
        this.adjustTabuList(stepScope.getStepIndex(), this.findNewTabu(stepScope));
    }

    protected void adjustTabuList(int tabuStepIndex, Collection<? extends Object> tabus) {
        int totalTabuListSize = this.workingTabuSize + this.workingFadingTabuSize;
        Iterator<Object> it = this.tabuSequenceDeque.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            Integer oldTabuStepIndexInteger = this.tabuToStepIndexMap.get(object);
            if (oldTabuStepIndexInteger == null) {
                throw new IllegalStateException("HashCode stability violation: the hashCode() of tabu (" + String.valueOf(object) + ") of class (" + String.valueOf(object.getClass()) + ") changed during planning, since it was inserted in the tabu Map or Set.");
            }
            int oldTabuStepCount = tabuStepIndex - oldTabuStepIndexInteger;
            if (oldTabuStepCount < totalTabuListSize) break;
            it.remove();
            this.tabuToStepIndexMap.remove(object);
        }
        for (Object object : tabus) {
            if (this.tabuToStepIndexMap.containsKey(object)) {
                this.tabuToStepIndexMap.remove(object);
                this.tabuSequenceDeque.remove(object);
            }
            this.tabuToStepIndexMap.put(object, tabuStepIndex);
            this.tabuSequenceDeque.add(object);
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        boolean accepted;
        int maximumTabuStepIndex = this.locateMaximumTabuStepIndex(moveScope);
        if (maximumTabuStepIndex < 0) {
            return true;
        }
        if (this.aspirationEnabled && moveScope.getScore().compareTo(((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope().getBestScore()) > 0) {
            this.logger.trace("{}        Proposed move ({}) is tabu, but is accepted anyway due to aspiration.", (Object)this.logIndentation, moveScope.getMove());
            return true;
        }
        int tabuStepCount = moveScope.getStepScope().getStepIndex() - maximumTabuStepIndex;
        if (tabuStepCount <= this.workingTabuSize) {
            this.logger.trace("{}        Proposed move ({}) is tabu and is therefore not accepted.", (Object)this.logIndentation, moveScope.getMove());
            return false;
        }
        double acceptChance = this.calculateFadingTabuAcceptChance(tabuStepCount - this.workingTabuSize);
        boolean bl = accepted = moveScope.getWorkingRandom().nextDouble() < acceptChance;
        if (accepted) {
            this.logger.trace("{}        Proposed move ({}) is fading tabu with acceptChance ({}) and is accepted.", new Object[]{this.logIndentation, moveScope.getMove(), acceptChance});
        } else {
            this.logger.trace("{}        Proposed move ({}) is fading tabu with acceptChance ({}) and is not accepted.", new Object[]{this.logIndentation, moveScope.getMove(), acceptChance});
        }
        return accepted;
    }

    private int locateMaximumTabuStepIndex(LocalSearchMoveScope<Solution_> moveScope) {
        Collection<Object> checkingTabus = this.findTabu(moveScope);
        int maximumTabuStepIndex = -1;
        for (Object checkingTabu : checkingTabus) {
            Integer tabuStepIndexInteger = this.tabuToStepIndexMap.get(checkingTabu);
            if (tabuStepIndexInteger != null) {
                maximumTabuStepIndex = Math.max(tabuStepIndexInteger, maximumTabuStepIndex);
            }
            if (!this.assertTabuHashCodeCorrectness) continue;
            for (Object tabu : this.tabuSequenceDeque) {
                if (tabu == null || !tabu.equals(checkingTabu)) continue;
                if (tabu.hashCode() != checkingTabu.hashCode()) {
                    throw new IllegalStateException("HashCode/equals contract violation: tabu (" + String.valueOf(tabu) + ") of class (" + String.valueOf(tabu.getClass()) + ") and checkingTabu (" + String.valueOf(checkingTabu) + ") are equals() but have a different hashCode().");
                }
                if (tabuStepIndexInteger != null) continue;
                throw new IllegalStateException("HashCode stability violation: the hashCode() of tabu (" + String.valueOf(tabu) + ") of class (" + String.valueOf(tabu.getClass()) + ") changed during planning, since it was inserted in the tabu Map or Set.");
            }
        }
        return maximumTabuStepIndex;
    }

    protected double calculateFadingTabuAcceptChance(int fadingTabuStepCount) {
        return (double)(this.workingFadingTabuSize - fadingTabuStepCount) / (double)(this.workingFadingTabuSize + 1);
    }

    protected abstract Collection<? extends Object> findTabu(LocalSearchMoveScope<Solution_> var1);

    protected abstract Collection<? extends Object> findNewTabu(LocalSearchStepScope<Solution_> var1);
}

