/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.forager.finalist;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.localsearch.decider.forager.finalist.AbstractFinalistPodium;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;

public final class StrategicOscillationByLevelFinalistPodium<Solution_>
extends AbstractFinalistPodium<Solution_> {
    private final boolean referenceBestScoreInsteadOfLastStepScore;
    private Score<?> referenceScore;
    private Number[] referenceLevelNumbers;
    private Score<?> finalistScore;
    private Number[] finalistLevelNumbers;
    private boolean finalistImprovesUponReference;

    public StrategicOscillationByLevelFinalistPodium(boolean referenceBestScoreInsteadOfLastStepScore) {
        this.referenceBestScoreInsteadOfLastStepScore = referenceBestScoreInsteadOfLastStepScore;
    }

    @Override
    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.referenceScore = this.referenceBestScoreInsteadOfLastStepScore ? stepScope.getPhaseScope().getBestScore().raw() : ((LocalSearchPhaseScope)stepScope.getPhaseScope()).getLastCompletedStepScope().getScore().raw();
        this.referenceLevelNumbers = this.referenceScore.toLevelNumbers();
        this.finalistScore = null;
        this.finalistLevelNumbers = null;
        this.finalistImprovesUponReference = false;
    }

    @Override
    public void addMove(LocalSearchMoveScope<Solution_> moveScope) {
        Number[] moveLevelNumbers;
        Object moveScore;
        int comparison;
        boolean accepted = moveScope.getAccepted();
        if (this.finalistIsAccepted && !accepted) {
            return;
        }
        if (accepted && !this.finalistIsAccepted) {
            this.finalistIsAccepted = true;
            this.finalistScore = null;
            this.finalistLevelNumbers = null;
        }
        if ((comparison = this.doComparison((Score)(moveScore = moveScope.getScore().raw()), moveLevelNumbers = moveScore.toLevelNumbers())) > 0) {
            this.finalistScore = moveScore;
            this.finalistLevelNumbers = moveLevelNumbers;
            this.finalistImprovesUponReference = moveScore.compareTo(this.referenceScore) > 0;
            this.clearAndAddFinalist(moveScope);
        } else if (comparison == 0) {
            this.addFinalist(moveScope);
        }
    }

    private int doComparison(Score moveScore, Number[] moveLevelNumbers) {
        if (this.finalistScore == null) {
            return 1;
        }
        if (!this.finalistImprovesUponReference && moveScore.compareTo(this.referenceScore) < 0) {
            for (int i = 0; i < this.referenceLevelNumbers.length; ++i) {
                boolean finalistIsHigher;
                boolean moveIsHigher = ((Comparable)((Object)moveLevelNumbers[i])).compareTo(this.referenceLevelNumbers[i]) > 0;
                boolean bl = finalistIsHigher = ((Comparable)((Object)this.finalistLevelNumbers[i])).compareTo(this.referenceLevelNumbers[i]) > 0;
                if (moveIsHigher) {
                    if (finalistIsHigher) break;
                    return 1;
                }
                if (!finalistIsHigher) continue;
                return -1;
            }
        }
        return moveScore.compareTo(this.finalistScore);
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.referenceScore = null;
        this.referenceLevelNumbers = null;
        this.finalistScore = null;
        this.finalistLevelNumbers = null;
    }
}

