/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.generic.move;

import ai.timefold.solver.core.impl.move.streams.generic.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ChangeMove<Solution_, Entity_, Value_>
extends AbstractMove<Solution_> {
    protected final PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    protected final Entity_ entity;
    protected final @Nullable Value_ toPlanningValue;
    private @Nullable Value_ currentValue;

    public ChangeMove(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, @Nullable Value_ toPlanningValue) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        this.entity = Objects.requireNonNull(entity);
        this.toPlanningValue = toPlanningValue;
    }

    protected @Nullable Value_ readValue(SolutionView<Solution_> solutionView) {
        if (this.currentValue == null) {
            this.currentValue = solutionView.getValue(this.variableMetaModel, this.entity);
        }
        return this.currentValue;
    }

    @Override
    public void execute(MutableSolutionView<Solution_> solutionView) {
        solutionView.changeVariable(this.variableMetaModel, this.entity, this.toPlanningValue);
    }

    public ChangeMove<Solution_, Entity_, Value_> rebase(Rebaser rebaser) {
        return new ChangeMove<Solution_, Entity_, Value_>(this.variableMetaModel, Objects.requireNonNull(rebaser.rebase(this.entity)), rebaser.rebase(this.toPlanningValue));
    }

    @Override
    public Collection<Entity_> extractPlanningEntities() {
        return Collections.singletonList(this.entity);
    }

    @Override
    public Collection<Value_> extractPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    @Override
    protected List<VariableMetaModel<Solution_, ?, ?>> getVariableMetaModels() {
        return List.of(this.variableMetaModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ChangeMove)) return false;
        ChangeMove that = (ChangeMove)o;
        if (!Objects.equals(this.variableMetaModel, that.variableMetaModel)) return false;
        if (!Objects.equals(this.entity, that.entity)) return false;
        if (!Objects.equals(this.toPlanningValue, that.toPlanningValue)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModel, this.entity, this.toPlanningValue);
    }

    @Override
    public String toString() {
        Value_ oldValue = this.currentValue == null ? ChangeMove.getVariableDescriptor(this.variableMetaModel).getValue(this.entity) : this.currentValue;
        return String.valueOf(this.entity) + " {" + String.valueOf(oldValue) + " -> " + String.valueOf(this.toPlanningValue) + "}";
    }
}

