/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.generic.move;

import ai.timefold.solver.core.impl.move.streams.generic.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class ListChangeMove<Solution_, Entity_, Value_>
extends AbstractMove<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    private final Entity_ sourceEntity;
    private final int sourceIndex;
    private final Entity_ destinationEntity;
    private final int destinationIndex;
    private Value_ planningValue;

    public ListChangeMove(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ sourceEntity, int sourceIndex, Entity_ destinationEntity, int destinationIndex) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        this.sourceEntity = Objects.requireNonNull(sourceEntity);
        if (sourceIndex < 0) {
            throw new IllegalArgumentException("The sourceIndex (" + sourceIndex + ") must be greater than 0.");
        }
        this.sourceIndex = sourceIndex;
        this.destinationEntity = Objects.requireNonNull(destinationEntity);
        if (destinationIndex < 0) {
            throw new IllegalArgumentException("The destinationIndex (" + destinationIndex + ") must be greater than 0.");
        }
        this.destinationIndex = destinationIndex;
    }

    private Value_ getMovedValue() {
        if (this.planningValue == null) {
            this.planningValue = ListChangeMove.getVariableDescriptor(this.variableMetaModel).getValue(this.sourceEntity).get(this.sourceIndex);
        }
        return this.planningValue;
    }

    @Override
    public void execute(@NonNull MutableSolutionView<Solution_> solutionView) {
        this.planningValue = this.sourceEntity == this.destinationEntity ? solutionView.moveValueInList(this.variableMetaModel, this.sourceEntity, this.sourceIndex, this.destinationIndex) : solutionView.moveValueBetweenLists(this.variableMetaModel, this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }

    public @NonNull ListChangeMove<Solution_, Entity_, Value_> rebase(@NonNull Rebaser rebaser) {
        return new ListChangeMove<Solution_, Entity_, Value_>(this.variableMetaModel, rebaser.rebase(this.sourceEntity), this.sourceIndex, rebaser.rebase(this.destinationEntity), this.destinationIndex);
    }

    @Override
    public @NonNull Collection<Object> extractPlanningEntities() {
        if (this.sourceEntity == this.destinationEntity) {
            return Collections.singleton(this.sourceEntity);
        }
        return List.of(this.sourceEntity, this.destinationEntity);
    }

    @Override
    public @NonNull Collection<Object> extractPlanningValues() {
        return Collections.singleton(this.planningValue);
    }

    @Override
    protected List<VariableMetaModel<Solution_, ?, ?>> getVariableMetaModels() {
        return List.of(this.variableMetaModel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListChangeMove)) {
            return false;
        }
        ListChangeMove that = (ListChangeMove)o;
        return this.sourceIndex == that.sourceIndex && this.destinationIndex == that.destinationIndex && Objects.equals(this.variableMetaModel, that.variableMetaModel) && Objects.equals(this.sourceEntity, that.sourceEntity) && Objects.equals(this.destinationEntity, that.destinationEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModel, this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }

    @Override
    public @NonNull String toString() {
        return String.format("%s {%s[%d] -> %s[%d]}", this.getMovedValue(), this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }
}

