/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.generic.provider;

import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.move.streams.DefaultMoveStreamFactory;
import ai.timefold.solver.core.impl.move.streams.generic.move.ChangeMove;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProducer;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProvider;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamFactory;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniDataStream;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ChangeMoveProvider<Solution_, Entity_, Value_>
implements MoveProvider<Solution_> {
    private final PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    private final Predicate<@Nullable Value_> valueFilter;
    private final BiPredicate<Entity_, @Nullable Value_> entityAndValueFilter;

    public ChangeMoveProvider(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        VariableDescriptor variableDescriptor = ((DefaultPlanningVariableMetaModel)variableMetaModel).variableDescriptor();
        this.valueFilter = variableMetaModel.allowsUnassigned() ? value -> true : Objects::nonNull;
        this.entityAndValueFilter = (arg_0, arg_1) -> ChangeMoveProvider.lambda$new$1((BasicVariableDescriptor)variableDescriptor, arg_0, arg_1);
    }

    @Override
    public MoveProducer<Solution_> apply(MoveStreamFactory<Solution_> moveStreamFactory) {
        DefaultMoveStreamFactory defaultMoveStreamFactory = (DefaultMoveStreamFactory)moveStreamFactory;
        UniDataStream<Solution_, Object> valueStream = defaultMoveStreamFactory.enumeratePossibleValues(this.variableMetaModel).filter(this::acceptValue);
        UniDataStream<Solution_, Object> entityStream = defaultMoveStreamFactory.enumerateEntities(this.variableMetaModel).filter(this::acceptEntity);
        return moveStreamFactory.pick(entityStream).pick(valueStream, this::acceptEntityValuePair).asMove((solution, entity, value) -> new ChangeMove<Solution_, Object, Object>(this.variableMetaModel, entity, value));
    }

    protected boolean acceptEntity(Entity_ entity) {
        return true;
    }

    protected boolean acceptValue(@Nullable Value_ value) {
        return this.valueFilter.test(value);
    }

    protected boolean acceptEntityValuePair(Entity_ entity, @Nullable Value_ value) {
        return this.entityAndValueFilter.test(entity, value);
    }

    private static /* synthetic */ boolean lambda$new$1(BasicVariableDescriptor variableDescriptor, Object entity, Object value) {
        return variableDescriptor.getValue(entity) != value;
    }
}

