/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase.scope;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhaseScope<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SolverScope<Solution_> solverScope;
    protected final int phaseIndex;
    protected final boolean phaseSendingBestSolutionEvents;
    protected Long startingSystemTimeMillis;
    protected Long startingScoreCalculationCount;
    protected Long startingMoveEvaluationCount;
    protected InnerScore<?> startingScore;
    protected Long endingSystemTimeMillis;
    protected Long endingScoreCalculationCount;
    protected Long endingMoveEvaluationCount;
    protected long childThreadsScoreCalculationCount = 0L;
    protected int bestSolutionStepIndex;

    protected AbstractPhaseScope(SolverScope<Solution_> solverScope, int phaseIndex) {
        this(solverScope, phaseIndex, true);
    }

    protected AbstractPhaseScope(SolverScope<Solution_> solverScope, int phaseIndex, boolean phaseSendingBestSolutionEvents) {
        this.solverScope = solverScope;
        this.phaseIndex = phaseIndex;
        this.phaseSendingBestSolutionEvents = phaseSendingBestSolutionEvents;
    }

    public SolverScope<Solution_> getSolverScope() {
        return this.solverScope;
    }

    public int getPhaseIndex() {
        return this.phaseIndex;
    }

    public boolean isPhaseSendingBestSolutionEvents() {
        return this.phaseSendingBestSolutionEvents;
    }

    public Long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> getStartingScore() {
        return this.startingScore;
    }

    public Long getEndingSystemTimeMillis() {
        return this.endingSystemTimeMillis;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public abstract AbstractStepScope<Solution_> getLastCompletedStepScope();

    public void reset() {
        this.bestSolutionStepIndex = -1;
        InnerScore<Object> innerScore = this.startingScore = this.solverScope.getBestScore() == null ? this.solverScope.calculateScore() : this.solverScope.getBestScore();
        if (this.getLastCompletedStepScope().getStepIndex() < 0) {
            this.getLastCompletedStepScope().setScore(this.startingScore);
        }
    }

    public void startingNow() {
        this.startingSystemTimeMillis = this.getSolverScope().getClock().millis();
        this.startingScoreCalculationCount = this.getScoreDirector().getCalculationCount();
        this.startingMoveEvaluationCount = this.getSolverScope().getMoveEvaluationCount();
    }

    public void endingNow() {
        this.endingSystemTimeMillis = this.getSolverScope().getClock().millis();
        this.endingScoreCalculationCount = this.getScoreDirector().getCalculationCount();
        this.endingMoveEvaluationCount = this.getSolverScope().getMoveEvaluationCount();
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solverScope.getSolutionDescriptor();
    }

    public long calculateSolverTimeMillisSpentUpToNow() {
        return this.solverScope.calculateTimeMillisSpentUpToNow();
    }

    public long calculatePhaseTimeMillisSpentUpToNow() {
        long now = this.getSolverScope().getClock().millis();
        return now - this.startingSystemTimeMillis;
    }

    public long getPhaseTimeMillisSpent() {
        return this.endingSystemTimeMillis - this.startingSystemTimeMillis;
    }

    public void addChildThreadsScoreCalculationCount(long addition) {
        this.solverScope.addChildThreadsScoreCalculationCount(addition);
        this.childThreadsScoreCalculationCount += addition;
    }

    public void addMoveEvaluationCount(Move<Solution_> move, long count) {
        this.solverScope.addMoveEvaluationCount(1L);
        this.addMoveEvaluationCountPerType(move, count);
    }

    public void addMoveEvaluationCountPerType(Move<Solution_> move, long count) {
        if (this.solverScope.isMetricEnabled(SolverMetric.MOVE_COUNT_PER_TYPE)) {
            this.solverScope.addMoveEvaluationCountPerType(move.describe(), count);
        }
    }

    public long getPhaseScoreCalculationCount() {
        return this.endingScoreCalculationCount - this.startingScoreCalculationCount + this.childThreadsScoreCalculationCount;
    }

    public long getPhaseMoveEvaluationCount() {
        Long currentMoveEvaluationCount = this.endingMoveEvaluationCount;
        if (this.endingMoveEvaluationCount == null) {
            currentMoveEvaluationCount = this.getSolverScope().getMoveEvaluationCount();
        }
        return currentMoveEvaluationCount - this.startingMoveEvaluationCount;
    }

    public long getPhaseScoreCalculationSpeed() {
        return this.getMetricCalculationSpeed(this.getPhaseScoreCalculationCount());
    }

    public long getPhaseMoveEvaluationSpeed() {
        return this.getMetricCalculationSpeed(this.getPhaseMoveEvaluationCount());
    }

    private long getMetricCalculationSpeed(long metric) {
        long timeMillisSpent = this.getPhaseTimeMillisSpent();
        return metric * 1000L / (timeMillisSpent == 0L ? 1L : timeMillisSpent);
    }

    public <Score_ extends Score<Score_>> InnerScoreDirector<Solution_, Score_> getScoreDirector() {
        return this.solverScope.getScoreDirector();
    }

    public Solution_ getWorkingSolution() {
        return this.solverScope.getWorkingSolution();
    }

    public int getWorkingEntityCount() {
        return this.solverScope.getWorkingEntityCount();
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> calculateScore() {
        return this.solverScope.calculateScore();
    }

    public <Score_ extends Score<Score_>> void assertExpectedWorkingScore(InnerScore<Score_> expectedWorkingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertExpectedWorkingScore(expectedWorkingScore, completedAction);
    }

    public <Score_ extends Score<Score_>> void assertWorkingScoreFromScratch(InnerScore<Score_> workingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertWorkingScoreFromScratch(workingScore, completedAction);
    }

    public <Score_ extends Score<Score_>> void assertPredictedScoreFromScratch(InnerScore<Score_> workingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertPredictedScoreFromScratch(workingScore, completedAction);
    }

    public <Score_ extends Score<Score_>> void assertShadowVariablesAreNotStale(InnerScore<Score_> workingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertShadowVariablesAreNotStale(workingScore, completedAction);
    }

    public Random getWorkingRandom() {
        return this.getSolverScope().getWorkingRandom();
    }

    public boolean isBestSolutionInitialized() {
        return this.solverScope.isBestSolutionInitialized();
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> getBestScore() {
        return this.solverScope.getBestScore();
    }

    public long getPhaseBestSolutionTimeMillis() {
        long bestSolutionTimeMillis = this.solverScope.getBestSolutionTimeMillis();
        if (bestSolutionTimeMillis < this.startingSystemTimeMillis) {
            bestSolutionTimeMillis = this.startingSystemTimeMillis;
        }
        return bestSolutionTimeMillis;
    }

    public int getNextStepIndex() {
        return this.getLastCompletedStepScope().getStepIndex() + 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.phaseIndex + ")";
    }
}

