/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.bi;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.bi.MapBiToUniNode;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.bi.BavetAbstractBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeUniConstraintStream;
import java.util.Objects;
import java.util.function.BiFunction;

final class BavetUniMapBiConstraintStream<Solution_, A, B, NewA>
extends BavetAbstractBiConstraintStream<Solution_, A, B> {
    private final BiFunction<A, B, NewA> mappingFunction;
    private BavetAftBridgeUniConstraintStream<Solution_, NewA> aftStream;

    public BavetUniMapBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BiFunction<A, B, NewA> mappingFunction) {
        super(constraintFactory, parent);
        this.mappingFunction = mappingFunction;
    }

    public void setAftBridge(BavetAftBridgeUniConstraintStream<Solution_, NewA> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public boolean guaranteesDistinct() {
        return false;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        MapBiToUniNode<A, B, NewA> node = new MapBiToUniNode<A, B, NewA>(inputStoreIndex, this.mappingFunction, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), outputStoreSize);
        buildHelper.addNode(node, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetUniMapBiConstraintStream that = (BavetUniMapBiConstraintStream)object;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.mappingFunction, that.mappingFunction);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.mappingFunction);
    }

    public String toString() {
        return "UniMap()";
    }
}

