/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.RangeSplitPoint;
import java.util.function.Function;

public final class Range<Range_, Point_ extends Comparable<Point_>> {
    private final Range_ value;
    private final RangeSplitPoint<Range_, Point_> startSplitPoint;
    private final RangeSplitPoint<Range_, Point_> endSplitPoint;

    public Range(Range_ value, Function<? super Range_, ? extends Point_> startMapping, Function<? super Range_, ? extends Point_> endMapping) {
        this.value = value;
        Comparable start = (Comparable)startMapping.apply(value);
        Comparable end = (Comparable)endMapping.apply(value);
        this.startSplitPoint = new RangeSplitPoint(start);
        this.endSplitPoint = start == end ? this.startSplitPoint : new RangeSplitPoint(end);
    }

    public Range_ getValue() {
        return this.value;
    }

    public Point_ getStart() {
        return this.startSplitPoint.splitPoint;
    }

    public Point_ getEnd() {
        return this.endSplitPoint.splitPoint;
    }

    public RangeSplitPoint<Range_, Point_> getStartSplitPoint() {
        return this.startSplitPoint;
    }

    public RangeSplitPoint<Range_, Point_> getEndSplitPoint() {
        return this.endSplitPoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range that = (Range)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return System.identityHashCode(this.value);
    }

    public String toString() {
        return "Range{value=" + String.valueOf(this.value) + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + "}";
    }
}

