/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.Range;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.TreeMultiSet;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class RangeSplitPoint<Range_, Point_ extends Comparable<Point_>>
implements Comparable<RangeSplitPoint<Range_, Point_>> {
    final Point_ splitPoint;
    Map<Range_, Integer> startpointRangeToCountMap;
    Map<Range_, Integer> endpointRangeToCountMap;
    TreeMultiSet<Range<Range_, Point_>> rangesStartingAtSplitPointSet;
    TreeMultiSet<Range<Range_, Point_>> rangesEndingAtSplitPointSet;

    public RangeSplitPoint(Point_ splitPoint) {
        this.splitPoint = splitPoint;
    }

    protected void createCollections() {
        this.startpointRangeToCountMap = new IdentityHashMap<Range_, Integer>();
        this.endpointRangeToCountMap = new IdentityHashMap<Range_, Integer>();
        this.rangesStartingAtSplitPointSet = new TreeMultiSet<Range>(Comparator.comparing(Range::getEnd).thenComparingInt(range -> System.identityHashCode(range.getValue())));
        this.rangesEndingAtSplitPointSet = new TreeMultiSet<Range>(Comparator.comparing(Range::getStart).thenComparingInt(range -> System.identityHashCode(range.getValue())));
    }

    public boolean addRangeStartingAtSplitPoint(Range<Range_, Point_> range) {
        this.startpointRangeToCountMap.merge(range.getValue(), 1, Integer::sum);
        return this.rangesStartingAtSplitPointSet.add(range);
    }

    public void removeRangeStartingAtSplitPoint(Range<Range_, Point_> range) {
        Integer newCount = this.startpointRangeToCountMap.computeIfPresent(range.getValue(), (key, count) -> {
            if (count > 1) {
                return count - 1;
            }
            return null;
        });
        if (null == newCount) {
            this.rangesStartingAtSplitPointSet.remove(range);
        }
    }

    public boolean addRangeEndingAtSplitPoint(Range<Range_, Point_> range) {
        this.endpointRangeToCountMap.merge(range.getValue(), 1, Integer::sum);
        return this.rangesEndingAtSplitPointSet.add(range);
    }

    public void removeRangeEndingAtSplitPoint(Range<Range_, Point_> range) {
        Integer newCount = this.endpointRangeToCountMap.computeIfPresent(range.getValue(), (key, count) -> {
            if (count > 1) {
                return count - 1;
            }
            return null;
        });
        if (null == newCount) {
            this.rangesEndingAtSplitPointSet.remove(range);
        }
    }

    public boolean containsRangeStarting(Range<Range_, Point_> range) {
        return this.rangesStartingAtSplitPointSet.contains(range);
    }

    public boolean containsRangeEnding(Range<Range_, Point_> range) {
        return this.rangesEndingAtSplitPointSet.contains(range);
    }

    public Iterator<Range_> getValuesStartingFromSplitPointIterator() {
        return this.rangesStartingAtSplitPointSet.stream().map(Range::getValue).iterator();
    }

    public boolean isEmpty() {
        return this.rangesStartingAtSplitPointSet.isEmpty() && this.rangesEndingAtSplitPointSet.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeSplitPoint that = (RangeSplitPoint)o;
        return this.splitPoint.equals(that.splitPoint);
    }

    public boolean isBefore(RangeSplitPoint<Range_, Point_> other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(RangeSplitPoint<Range_, Point_> other) {
        return this.compareTo(other) > 0;
    }

    public int hashCode() {
        return Objects.hash(this.splitPoint);
    }

    @Override
    public int compareTo(RangeSplitPoint<Range_, Point_> other) {
        return this.splitPoint.compareTo(other.splitPoint);
    }

    public String toString() {
        return this.splitPoint.toString();
    }
}

