/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.quad;

import ai.timefold.solver.core.api.function.PentaFunction;
import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.UndoableActionable;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class UndoableActionableQuadCollector<A, B, C, D, Input_, Output_, Calculator_ extends UndoableActionable<Input_, Output_>>
implements QuadConstraintCollector<A, B, C, D, Calculator_, Output_> {
    private final QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Input_> mapper;

    public UndoableActionableQuadCollector(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Input_> mapper) {
        this.mapper = mapper;
    }

    @Override
    public @NonNull PentaFunction<Calculator_, A, B, C, D, Runnable> accumulator() {
        return (calculator, a, b, c, d) -> {
            Input_ mapped = this.mapper.apply(a, b, c, d);
            return calculator.insert(mapped);
        };
    }

    @Override
    public @NonNull Function<Calculator_, Output_> finisher() {
        return UndoableActionable::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UndoableActionableQuadCollector that = (UndoableActionableQuadCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

