/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractUniversalTermination;
import ai.timefold.solver.core.impl.solver.termination.ChildThreadSupportingTermination;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.termination.UniversalTermination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
abstract class AbstractCompositeTermination<Solution_>
extends AbstractUniversalTermination<Solution_> {
    protected final List<Termination<Solution_>> terminationList;
    protected final List<PhaseTermination<Solution_>> phaseTerminationList;
    protected final List<SolverTermination<Solution_>> solverTerminationList;

    protected AbstractCompositeTermination(List<Termination<Solution_>> terminationList) {
        this.terminationList = Objects.requireNonNull(terminationList);
        this.phaseTerminationList = terminationList.stream().filter(PhaseTermination.class::isInstance).map(t -> (PhaseTermination)t).toList();
        this.solverTerminationList = terminationList.stream().filter(SolverTermination.class::isInstance).map(t -> (SolverTermination)t).toList();
    }

    @SafeVarargs
    public AbstractCompositeTermination(Termination<Solution_> ... terminations) {
        this(Arrays.asList(terminations));
    }

    @Override
    public final void solvingStarted(SolverScope<Solution_> solverScope) {
        for (SolverTermination<Solution_> termination : this.solverTerminationList) {
            termination.solvingStarted(solverScope);
        }
    }

    @Override
    public final void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        for (PhaseTermination<Solution_> termination : this.phaseTerminationList) {
            termination.phaseStarted(phaseScope);
        }
    }

    @Override
    public final void stepStarted(AbstractStepScope<Solution_> stepScope) {
        for (PhaseTermination<Solution_> termination : this.phaseTerminationList) {
            termination.stepStarted(stepScope);
        }
    }

    @Override
    public final void stepEnded(AbstractStepScope<Solution_> stepScope) {
        for (PhaseTermination<Solution_> termination : this.phaseTerminationList) {
            termination.stepEnded(stepScope);
        }
    }

    @Override
    public final void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        for (PhaseTermination<Solution_> termination : this.phaseTerminationList) {
            termination.phaseEnded(phaseScope);
        }
    }

    @Override
    public final void solvingEnded(SolverScope<Solution_> solverScope) {
        for (SolverTermination<Solution_> termination : this.solverTerminationList) {
            termination.solvingEnded(solverScope);
        }
    }

    protected final List<Termination<Solution_>> createChildThreadTerminationList(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        ArrayList<Termination<Solution_>> childThreadTerminationList = new ArrayList<Termination<Solution_>>(this.terminationList.size());
        for (Termination<Solution_> termination : this.terminationList) {
            ChildThreadSupportingTermination<Solution_, SolverScope<Solution_>> childThreadSupportingTermination = ChildThreadSupportingTermination.assertChildThreadSupport(termination);
            childThreadTerminationList.add(childThreadSupportingTermination.createChildThreadTermination(solverScope, childThreadType));
        }
        return childThreadTerminationList;
    }

    @Override
    public final List<PhaseTermination<Solution_>> getPhaseTerminationList() {
        ArrayList result = new ArrayList();
        for (PhaseTermination<Solution_> termination : this.phaseTerminationList) {
            result.add(termination);
            if (!(termination instanceof UniversalTermination)) continue;
            UniversalTermination universalTermination = (UniversalTermination)termination;
            result.addAll(universalTermination.getPhaseTerminationList());
        }
        return List.copyOf(result);
    }
}

