/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionUtils {
    public static <E> List<E> copy(List<E> originalList, boolean reverse) {
        if (!reverse) {
            return new ArrayList<E>(originalList);
        }
        switch (originalList.size()) {
            case 0: {
                return new ArrayList(0);
            }
            case 1: {
                ArrayList<E> singletonList = new ArrayList<E>(1);
                singletonList.add(originalList.get(0));
                return singletonList;
            }
            case 2: {
                ArrayList<E> smallList = new ArrayList<E>(2);
                smallList.add(originalList.get(1));
                smallList.add(originalList.get(0));
                return smallList;
            }
        }
        ArrayList<E> largeList = new ArrayList<E>(originalList);
        Collections.reverse(largeList);
        return largeList;
    }

    public static <T> List<T> concat(List<T> left, List<T> right) {
        ArrayList<T> result = new ArrayList<T>(left.size() + right.size());
        result.addAll(left);
        result.addAll(right);
        return result;
    }

    public static <T> List<T> toDistinctList(Collection<T> collection) {
        int size = collection.size();
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                if (collection instanceof List) {
                    List list = (List)collection;
                    return list;
                }
                return Collections.singletonList(collection.iterator().next());
            }
        }
        if (collection instanceof Set) {
            Set set = (Set)collection;
            return new ArrayList(set);
        }
        ArrayList<T> resultList = new ArrayList<T>(size);
        Set<T> set = CollectionUtils.newHashSet(size);
        for (T element : collection) {
            if (!set.add(element)) continue;
            resultList.add(element);
        }
        resultList.trimToSize();
        return resultList;
    }

    public static <T> Set<T> newHashSet(int size) {
        return new HashSet(CollectionUtils.calculateCapacityForDefaultLoadFactor(size));
    }

    private static int calculateCapacityForDefaultLoadFactor(int numElements) {
        return (int)Math.ceil((float)numElements / 0.75f);
    }

    public static <T> Set<T> newLinkedHashSet(int size) {
        return new LinkedHashSet(CollectionUtils.calculateCapacityForDefaultLoadFactor(size));
    }

    public static <K, V> Map<K, V> newHashMap(int size) {
        return new HashMap(CollectionUtils.calculateCapacityForDefaultLoadFactor(size));
    }

    public static <K, V> Map<K, V> newIdentityHashMap(int size) {
        return new IdentityHashMap(CollectionUtils.calculateCapacityForDefaultLoadFactor(size));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int size) {
        return new LinkedHashMap(CollectionUtils.calculateCapacityForDefaultLoadFactor(size));
    }

    private CollectionUtils() {
    }
}

