/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LinkedIdentityHashSet<V>
extends AbstractSet<V> {
    private final ElementAwareList<V> delegate = new ElementAwareList();
    private final IdentityHashMap<V, ElementAwareListEntry<V>> identityMap = new IdentityHashMap();
    private int size = 0;

    @Override
    public Iterator<V> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (this.size == 0) {
            return false;
        }
        return this.identityMap.containsKey(o);
    }

    @Override
    public boolean add(V v) {
        ElementAwareListEntry<V> entry = this.identityMap.get(v);
        if (entry == null) {
            this.identityMap.put((ElementAwareListEntry<V>)v, (ElementAwareListEntry<ElementAwareListEntry<V>>)this.delegate.add(v));
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.size == 0) {
            return false;
        }
        ElementAwareListEntry<V> entry = this.identityMap.remove(o);
        if (entry == null) {
            return false;
        }
        entry.remove();
        --this.size;
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.identityMap.clear();
        this.delegate.clear();
        this.size = 0;
    }
}

