/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jaxb.api.score;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import ai.timefold.solver.core.api.score.buildin.simple.SimpleScore;
import ai.timefold.solver.core.impl.io.jaxb.GenericJaxbIO;
import ai.timefold.solver.jaxb.api.score.PolymorphicScoreJaxbAdapter;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Reader;
import java.io.StringReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PolymorphicScoreJaxbAdapterTest {
    private final PolymorphicScoreJaxbAdapter scoreJaxbAdapter = new PolymorphicScoreJaxbAdapter();

    PolymorphicScoreJaxbAdapterTest() {
    }

    @Test
    void marshall() {
        SimpleScore score = SimpleScore.of((int)1);
        PolymorphicScoreJaxbAdapter.JaxbAdaptedScore adaptedScore = this.scoreJaxbAdapter.marshal((Score)score);
        Assertions.assertThat((String)adaptedScore.getScoreClassName()).isEqualTo(SimpleScore.class.getName());
        Assertions.assertThat((String)adaptedScore.getScoreString()).isEqualTo(score.toString());
    }

    @Test
    void unmarshall() {
        String xmlString = "<dummy><score class=\"ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore\">-1hard/-10soft</score></dummy>";
        GenericJaxbIO xmlIO = new GenericJaxbIO(DummyRootElement.class);
        DummyRootElement dummyRootElement = (DummyRootElement)xmlIO.read((Reader)new StringReader(xmlString));
        Assertions.assertThat(dummyRootElement.score).isEqualTo((Object)HardSoftLongScore.of((long)-1L, (long)-10L));
    }

    @XmlRootElement(name="dummy")
    private static class DummyRootElement {
        @XmlJavaTypeAdapter(value=PolymorphicScoreJaxbAdapter.class)
        private Score<?> score;

        private DummyRootElement() {
        }

        private DummyRootElement(Score<?> score) {
            this.score = score;
        }
    }
}

