/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jaxb.api.score;

import ai.timefold.solver.core.api.score.Score;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.assertj.core.api.Assertions;

public abstract class AbstractScoreJaxbAdapterTest {
    private static final String JAVAX_XML_BIND_CONTEXT_FACTORY_PROPERTY = "javax.xml.bind.context.factory";
    private static final String JAKARTA_XML_BIND_CONTEXT_FACTORY_PROPERTY = "jakarta.xml.bind.JAXBContextFactory";

    protected <Score_ extends Score<Score_>, W extends TestScoreWrapper<Score_>> void assertSerializeAndDeserialize(Score_ expectedScore, W input) {
        this.assertSerializeAndDeserializeXML(expectedScore, input);
    }

    protected <Score_ extends Score<Score_>, W extends TestScoreWrapper<Score_>> void assertSerializeAndDeserializeXML(Score_ expectedScore, W input) {
        TestScoreWrapper output;
        String xmlString;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{input.getClass()});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            StringWriter writer = new StringWriter();
            jaxbMarshaller.marshal(input, (Writer)writer);
            xmlString = writer.toString();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xmlString);
            output = (TestScoreWrapper)unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assertions.assertThat(output.getScore()).isEqualTo(expectedScore);
        Object regex = expectedScore != null ? "<\\?[^\\?]*\\?><([\\w\\-\\.]+)>\\s*<score>" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "</score>\\s*</\\1>" : "<\\?[^\\?]*\\?><([\\w\\-\\.]+)/>";
        if (!xmlString.matches((String)regex)) {
            Assertions.fail((String)String.format("Regular expression match failed.%nExpected regular expression: %s%nActual string: %s", regex, xmlString));
        }
    }

    public static abstract class TestScoreWrapper<Score_ extends Score<Score_>> {
        public abstract Score_ getScore();
    }
}

