/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jaxb.impl.domain.solution;

import ai.timefold.solver.core.api.score.buildin.simple.SimpleScore;
import ai.timefold.solver.core.impl.testdata.util.CodeAssertable;
import ai.timefold.solver.core.impl.testdata.util.PlannerAssert;
import ai.timefold.solver.jaxb.impl.domain.solution.JaxbSolutionFileIO;
import ai.timefold.solver.jaxb.impl.testdata.domain.JaxbTestdataEntity;
import ai.timefold.solver.jaxb.impl.testdata.domain.JaxbTestdataSolution;
import ai.timefold.solver.jaxb.impl.testdata.domain.JaxbTestdataValue;
import java.io.File;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class JaxbSolutionFileIOTest {
    private static File solutionTestDir;

    JaxbSolutionFileIOTest() {
    }

    @BeforeAll
    public static void setup() {
        solutionTestDir = new File("target/solutionTest/");
        solutionTestDir.mkdirs();
    }

    @Test
    void readAndWrite() {
        JaxbSolutionFileIO solutionFileIO = new JaxbSolutionFileIO(new Class[]{JaxbTestdataSolution.class});
        File file = new File(solutionTestDir, "testdataSolution.xml");
        JaxbTestdataSolution original = new JaxbTestdataSolution("s1");
        JaxbTestdataValue originalV1 = new JaxbTestdataValue("v1");
        original.setValueList(Arrays.asList(originalV1, new JaxbTestdataValue("v2")));
        original.setEntityList(Arrays.asList(new JaxbTestdataEntity("e1"), new JaxbTestdataEntity("e2", originalV1), new JaxbTestdataEntity("e3")));
        original.setScore(SimpleScore.of((int)-123));
        solutionFileIO.write((Object)original, file);
        JaxbTestdataSolution copy = (JaxbTestdataSolution)solutionFileIO.read(file);
        Assertions.assertThat((Object)copy).isNotSameAs((Object)original);
        PlannerAssert.assertCode((String)"s1", (CodeAssertable)copy);
        PlannerAssert.assertAllCodesOfIterator(copy.getValueList().iterator(), (String[])new String[]{"v1", "v2"});
        PlannerAssert.assertAllCodesOfIterator(copy.getEntityList().iterator(), (String[])new String[]{"e1", "e2", "e3"});
        JaxbTestdataValue copyV1 = copy.getValueList().get(0);
        JaxbTestdataEntity copyE2 = copy.getEntityList().get(1);
        PlannerAssert.assertCode((String)"v1", (CodeAssertable)copyE2.getValue());
        Assertions.assertThat((Object)copyE2.getValue()).isSameAs((Object)copyV1);
        Assertions.assertThat((Comparable)copy.getScore()).isEqualTo((Object)SimpleScore.of((int)-123));
    }
}

