/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jpa.impl;

import ai.timefold.solver.core.api.score.Score;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import org.assertj.core.api.Assertions;

public abstract class AbstractScoreJpaTest {
    @Inject
    EntityManagerFactory entityManagerFactory;

    protected <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> Long persistAndAssert(E jpaEntity) {
        try {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.getTransaction().begin();
            em.persist(jpaEntity);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Transaction failed.", e);
        }
        Long id = jpaEntity.getId();
        Assertions.assertThat((Long)id).isNotNull();
        return id;
    }

    @SafeVarargs
    protected final <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> void persistAndMerge(E jpaEntity, Score_ ... newScores) {
        Long id = this.persistAndAssert(jpaEntity);
        Class<?> jpaEntityClass = jpaEntity.getClass();
        Score_ oldScore = jpaEntity.getScore();
        for (Score_ newScore : newScores) {
            this.findAssertAndChangeScore((Class<E>)jpaEntityClass, id, oldScore, newScore);
            this.findAndAssert((Class<E>)jpaEntityClass, id, newScore);
            oldScore = newScore;
        }
    }

    protected <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> void findAssertAndChangeScore(Class<E> jpaEntityClass, Long id, Score_ oldScore, Score_ newScore) {
        try {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.getTransaction().begin();
            AbstractTestJpaEntity jpaEntity = (AbstractTestJpaEntity)em.find(jpaEntityClass, (Object)id);
            em.persist((Object)jpaEntity);
            Assertions.assertThat(jpaEntity.getScore()).isEqualTo(oldScore);
            jpaEntity.setScore(newScore);
            jpaEntity = (AbstractTestJpaEntity)em.merge((Object)jpaEntity);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Transaction failed.", e);
        }
    }

    protected <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> void findAndAssert(Class<E> jpaEntityClass, Long id, Score_ score) {
        try {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.getTransaction().begin();
            AbstractTestJpaEntity jpaEntity = (AbstractTestJpaEntity)em.find(jpaEntityClass, (Object)id);
            Assertions.assertThat(jpaEntity.getScore()).isEqualTo(score);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Transaction failed.", e);
        }
    }

    @MappedSuperclass
    protected static abstract class AbstractTestJpaEntity<Score_ extends Score<Score_>> {
        @Id
        @GeneratedValue(strategy=GenerationType.AUTO)
        protected Long id;

        protected AbstractTestJpaEntity() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public abstract Score_ getScore();

        public abstract void setScore(Score_ var1);
    }
}

