/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jsonb.api;

import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScore;
import ai.timefold.solver.jsonb.api.AbstractJsonbJsonAdapterTest;
import ai.timefold.solver.jsonb.api.TimefoldJsonbConfig;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TimefoldJsonbConfigTest
extends AbstractJsonbJsonAdapterTest {
    TimefoldJsonbConfigTest() {
    }

    @Test
    void jsonbConfigSerializeAndDeserialize() {
        JsonbConfig config = TimefoldJsonbConfig.createConfig();
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        TestTimefoldJsonbConfigWrapper input = new TestTimefoldJsonbConfigWrapper();
        input.setBendableScore(BendableScore.of((int[])new int[]{1000, 200}, (int[])new int[]{34}));
        input.setHardSoftScore(HardSoftScore.of((int)-1, (int)-20));
        TestTimefoldJsonbConfigWrapper output = TimefoldJsonbConfigTest.serializeAndDeserialize(jsonb, input);
        Assertions.assertThat((Comparable)output.getBendableScore()).isEqualTo((Object)BendableScore.of((int[])new int[]{1000, 200}, (int[])new int[]{34}));
        Assertions.assertThat((Comparable)output.getHardSoftScore()).isEqualTo((Object)HardSoftScore.of((int)-1, (int)-20));
    }

    public static class TestTimefoldJsonbConfigWrapper {
        private BendableScore bendableScore;
        private HardSoftScore hardSoftScore;

        public BendableScore getBendableScore() {
            return this.bendableScore;
        }

        public void setBendableScore(BendableScore bendableScore) {
            this.bendableScore = bendableScore;
        }

        public HardSoftScore getHardSoftScore() {
            return this.hardSoftScore;
        }

        public void setHardSoftScore(HardSoftScore hardSoftScore) {
            this.hardSoftScore = hardSoftScore;
        }
    }
}

