/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jsonb.api.score;

import ai.timefold.solver.core.api.score.Score;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import org.assertj.core.api.Assertions;

public abstract class AbstractScoreJsonbAdapterTest {
    protected <Score_ extends Score<Score_>, W extends TestScoreWrapper<Score_>> void assertSerializeAndDeserialize(Score_ expectedScore, W input) {
        TestScoreWrapper output;
        String jsonString;
        try {
            Jsonb jsonb = JsonbBuilder.create();
            jsonString = jsonb.toJson(input);
            output = (TestScoreWrapper)jsonb.fromJson(jsonString, input.getClass());
        }
        catch (JsonbException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assertions.assertThat(output.getScore()).isEqualTo(expectedScore);
        String newLine = System.lineSeparator();
        Object regex = expectedScore != null ? "\\{\"score\":\"" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "\"\\}" : "\\{\\}";
        if (!jsonString.matches((String)regex)) {
            Assertions.fail((String)("Regular expression match failed." + newLine + "Expected regular expression: " + (String)regex + newLine + "Actual string: " + jsonString));
        }
    }

    public static abstract class TestScoreWrapper<Score_ extends Score<Score_>> {
        public abstract Score_ getScore();

        public abstract void setScore(Score_ var1);
    }
}

