/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.deployment;

import ai.timefold.solver.core.api.domain.autodiscover.AutoDiscoverMemberType;
import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningEntityCollectionProperty;
import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.solution.ProblemFactCollectionProperty;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.enterprise.MultithreadedSolvingEnterpriseService;
import ai.timefold.solver.core.enterprise.NearbySelectionEnterpriseService;
import ai.timefold.solver.core.enterprise.PartitionedSearchEnterpriseService;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.io.jaxb.SolverConfigIO;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactoryService;
import ai.timefold.solver.core.impl.score.stream.JoinerService;
import ai.timefold.solver.quarkus.TimefoldRecorder;
import ai.timefold.solver.quarkus.bean.DefaultTimefoldBeanProvider;
import ai.timefold.solver.quarkus.bean.UnavailableTimefoldBeanProvider;
import ai.timefold.solver.quarkus.config.TimefoldRuntimeConfig;
import ai.timefold.solver.quarkus.deployment.DetermineIfNativeBuildItem;
import ai.timefold.solver.quarkus.deployment.DotNames;
import ai.timefold.solver.quarkus.deployment.GeneratedGizmoClasses;
import ai.timefold.solver.quarkus.deployment.GizmoMemberAccessorEntityEnhancer;
import ai.timefold.solver.quarkus.deployment.SolverConfigBuildItem;
import ai.timefold.solver.quarkus.deployment.config.TimefoldBuildTimeConfig;
import ai.timefold.solver.quarkus.devui.TimefoldDevUIPropertiesSupplier;
import ai.timefold.solver.quarkus.gizmo.TimefoldGizmoBeanFactory;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class TimefoldProcessor {
    private static final Logger log = Logger.getLogger((String)TimefoldProcessor.class.getName());
    TimefoldBuildTimeConfig timefoldBuildTimeConfig;

    TimefoldProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("timefold-solver");
    }

    @BuildStep
    void registerSpi(BuildProducer<ServiceProviderBuildItem> services) {
        Stream.of(ScoreDirectorFactoryService.class, JoinerService.class, MultithreadedSolvingEnterpriseService.class, PartitionedSearchEnterpriseService.class, NearbySelectionEnterpriseService.class).forEach(service -> TimefoldProcessor.registerSpi(service, services));
    }

    private static void registerSpi(Class<?> serviceClass, BuildProducer<ServiceProviderBuildItem> services) {
        String serviceName = serviceClass.getName();
        String service = "META-INF/services/" + serviceName;
        try {
            Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service);
            services.produce((BuildItem)new ServiceProviderBuildItem(serviceName, implementations.toArray(new String[0])));
        }
        catch (IOException e) {
            throw new IllegalStateException("Impossible state: Failed registering service " + serviceClass.getCanonicalName(), e);
        }
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchSolverConfigXml() {
        String solverConfigXML = this.timefoldBuildTimeConfig.solverConfigXml.orElse("solverConfig.xml");
        return new HotDeploymentWatchedFileBuildItem(solverConfigXML);
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencyBuildItem() {
        return new IndexDependencyBuildItem("ai.timefold.solver", "timefold-solver-core-impl");
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void makeGizmoBeanFactoryUnremovable(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TimefoldGizmoBeanFactory.class}));
    }

    @BuildStep(onlyIfNot={NativeBuild.class})
    DetermineIfNativeBuildItem ifNotNativeBuild() {
        return new DetermineIfNativeBuildItem(false);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    DetermineIfNativeBuildItem ifNativeBuild() {
        return new DetermineIfNativeBuildItem(true);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRuntimeTemplateInfoBuildItem getSolverConfig(SolverConfigBuildItem solverConfigBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        SolverConfig solverConfig = solverConfigBuildItem.getSolverConfig();
        if (solverConfig != null) {
            StringWriter effectiveSolverConfigWriter = new StringWriter();
            SolverConfigIO solverConfigIO = new SolverConfigIO();
            solverConfigIO.write(solverConfig, (Writer)effectiveSolverConfigWriter);
            return new DevConsoleRuntimeTemplateInfoBuildItem("solverConfigProperties", (Supplier)new TimefoldDevUIPropertiesSupplier(effectiveSolverConfigWriter.toString()), this.getClass(), curateOutcomeBuildItem);
        }
        return new DevConsoleRuntimeTemplateInfoBuildItem("solverConfigProperties", (Supplier)new TimefoldDevUIPropertiesSupplier(), this.getClass(), curateOutcomeBuildItem);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void makeSolverFactoryUnremovableInDevMode(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{SolverFactory.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SolverConfigBuildItem recordAndRegisterBeans(TimefoldRecorder recorder, RecorderContext recorderContext, CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        SolverConfig solverConfig;
        IndexView indexView = combinedIndex.getIndex();
        if (indexView.getAnnotations(DotNames.PLANNING_SOLUTION).isEmpty() && indexView.getAnnotations(DotNames.PLANNING_ENTITY).isEmpty()) {
            log.warn((Object)("Skipping Timefold extension because there are no @" + PlanningSolution.class.getSimpleName() + " or @" + PlanningEntity.class.getSimpleName() + " annotated classes.\nIf your domain classes are located in a dependency of this project, maybe try generating the Jandex index by using the jandex-maven-plugin in that dependency, or by addingapplication.properties entries (quarkus.index-dependency.<name>.group-id and quarkus.index-dependency.<name>.artifact-id)."));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{UnavailableTimefoldBeanProvider.class}));
            return new SolverConfigBuildItem(null);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.timefoldBuildTimeConfig.solverConfigXml.isPresent()) {
            String solverConfigXML = this.timefoldBuildTimeConfig.solverConfigXml.get();
            if (classLoader.getResource(solverConfigXML) == null) {
                throw new ConfigurationException("Invalid quarkus.timefold.solverConfigXML property (" + solverConfigXML + "): that classpath resource does not exist.");
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverConfigXML);
        } else {
            solverConfig = classLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml") : new SolverConfig();
        }
        this.applySolverProperties(indexView, solverConfig);
        this.assertNoMemberAnnotationWithoutClassAnnotation(indexView);
        if (solverConfig.getSolutionClass() != null) {
            Type jandexType = Type.create((DotName)DotName.createSimple((String)solverConfig.getSolutionClass().getName()), (Type.Kind)Type.Kind.CLASS);
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(jandexType).ignoreTypePredicate(dotName -> ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName) || dotName.toString().startsWith("ai.timefold.solver.api") || dotName.toString().startsWith("ai.timefold.solver.config") || dotName.toString().startsWith("ai.timefold.solver.impl")).build());
        }
        LinkedHashSet reflectiveClassSet = new LinkedHashSet();
        this.registerClassesFromAnnotations(indexView, reflectiveClassSet);
        this.registerCustomClassesFromSolverConfig(solverConfig, reflectiveClassSet);
        this.generateConstraintVerifier(solverConfig, syntheticBeanBuildItemBuildProducer);
        GeneratedGizmoClasses generatedGizmoClasses = this.generateDomainAccessors(solverConfig, indexView, generatedBeans, generatedClasses, transformers, reflectiveClassSet);
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverConfigSupplier(solverConfig, GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, generatedGizmoClasses.generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, generatedGizmoClasses.generatedGizmoSolutionClonerClassSet))).done());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManagerConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverManagerConfig(solverManagerConfig)).done());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultTimefoldBeanProvider.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TimefoldRuntimeConfig.class}));
        return new SolverConfigBuildItem(solverConfig);
    }

    private void generateConstraintVerifier(SolverConfig solverConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        String constraintVerifierClassName = DotNames.CONSTRAINT_VERIFIER.toString();
        if (solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null && this.isClassDefined(constraintVerifierClassName)) {
            Class constraintProviderClass = solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass();
            Class planningSolutionClass = solverConfig.getSolutionClass();
            List planningEntityClasses = solverConfig.getEntityClassList();
            ConstraintStreamImplType constraintStreamImplType = solverConfig.getScoreDirectorFactoryConfig().getConstraintStreamImplType();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotNames.CONSTRAINT_VERIFIER).scope(Singleton.class)).creator(methodCreator -> {
                ResultHandle constraintProviderResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Class)constraintProviderClass, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle planningSolutionClassResultHandle = methodCreator.loadClass(planningSolutionClass);
                ResultHandle planningEntityClassesResultHandle = methodCreator.newArray(Class.class, planningEntityClasses.size());
                for (int i = 0; i < planningEntityClasses.size(); ++i) {
                    ResultHandle planningEntityClassResultHandle = methodCreator.loadClass((Class)planningEntityClasses.get(i));
                    methodCreator.writeArrayValue(planningEntityClassesResultHandle, i, planningEntityClassResultHandle);
                }
                ResultHandle solutionDescriptorResultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(SolutionDescriptor.class, (String)"buildSolutionDescriptor", SolutionDescriptor.class, (Class[])new Class[]{Class.class, Class[].class}), new ResultHandle[]{planningSolutionClassResultHandle, planningEntityClassesResultHandle});
                ResultHandle constraintVerifierResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Object)"ai.timefold.solver.test.impl.score.stream.DefaultConstraintVerifier", (Object[])new Object[]{ConstraintProvider.class, SolutionDescriptor.class}), new ResultHandle[]{constraintProviderResultHandle, solutionDescriptorResultHandle});
                if (constraintStreamImplType != null) {
                    constraintVerifierResultHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)constraintVerifierClassName, (String)"withConstraintStreamImplType", (Object)constraintVerifierClassName, (Object[])new Object[]{ConstraintStreamImplType.class}), constraintVerifierResultHandle, new ResultHandle[]{methodCreator.load((Enum)constraintStreamImplType)});
                }
                methodCreator.returnValue(constraintVerifierResultHandle);
            })).addType((Type)ParameterizedType.create((DotName)DotNames.CONSTRAINT_VERIFIER, (Type[])new Type[]{Type.create((DotName)DotName.createSimple((String)constraintProviderClass.getName()), (Type.Kind)Type.Kind.CLASS), Type.create((DotName)DotName.createSimple((String)planningSolutionClass.getName()), (Type.Kind)Type.Kind.CLASS)}, null))).forceApplicationClass()).defaultBean()).done());
        }
    }

    private void applySolverProperties(IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findSolutionClass(indexView));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(indexView));
        }
        this.applyScoreDirectorFactoryProperties(indexView, solverConfig);
        this.timefoldBuildTimeConfig.solver.environmentMode.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setEnvironmentMode(arg_0));
        this.timefoldBuildTimeConfig.solver.daemon.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDaemon(arg_0));
        this.timefoldBuildTimeConfig.solver.domainAccessType.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDomainAccessType(arg_0));
        this.timefoldBuildTimeConfig.solver.constraintStreamImplType.ifPresent(arg_0 -> ((SolverConfig)solverConfig).withConstraintStreamImplType(arg_0));
        if (solverConfig.getDomainAccessType() == null) {
            solverConfig.setDomainAccessType(DomainAccessType.GIZMO);
        }
    }

    private Class<?> findSolutionClass(IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
        if (annotationInstances.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        AnnotationTarget solutionTarget = ((AnnotationInstance)annotationInstances.iterator().next()).target();
        if (solutionTarget.kind() != AnnotationTarget.Kind.CLASS) {
            throw new IllegalStateException("A target (" + solutionTarget + ") with a @" + PlanningSolution.class.getSimpleName() + " must be a class.");
        }
        return this.convertClassInfoToClass(solutionTarget.asClass());
    }

    private List<Class<?>> findEntityClassList(IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_ENTITY);
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        List targetList = annotationInstances.stream().map(AnnotationInstance::target).collect(Collectors.toList());
        if (targetList.stream().anyMatch(target -> target.kind() != AnnotationTarget.Kind.CLASS)) {
            throw new IllegalStateException("All targets (" + targetList + ") with a @" + PlanningEntity.class.getSimpleName() + " must be a class.");
        }
        return targetList.stream().map(target -> this.convertClassInfoToClass(target.asClass())).collect(Collectors.toList());
    }

    private void assertNoMemberAnnotationWithoutClassAnnotation(IndexView indexView) {
        HashSet timefoldFieldAnnotations = new HashSet();
        for (DotName annotationName : DotNames.PLANNING_ENTITY_FIELD_ANNOTATIONS) {
            timefoldFieldAnnotations.addAll(indexView.getAnnotations(annotationName));
        }
        for (AnnotationInstance annotationInstance : timefoldFieldAnnotations) {
            String prefix;
            AnnotationTarget annotationTarget = annotationInstance.target();
            ClassInfo declaringClass = switch (annotationTarget.kind()) {
                case AnnotationTarget.Kind.FIELD -> {
                    prefix = "The field (" + annotationTarget.asField().name() + ") ";
                    yield annotationTarget.asField().declaringClass();
                }
                case AnnotationTarget.Kind.METHOD -> {
                    prefix = "The method (" + annotationTarget.asMethod().name() + ") ";
                    yield annotationTarget.asMethod().declaringClass();
                }
                default -> throw new IllegalStateException("Member annotation @" + annotationInstance.name().withoutPackagePrefix() + " is on (" + annotationTarget + "), which is an invalid target type (" + annotationTarget.kind() + ") for @" + annotationInstance.name().withoutPackagePrefix() + ".");
            };
            if (declaringClass.annotationsMap().containsKey(DotNames.PLANNING_ENTITY)) continue;
            throw new IllegalStateException(prefix + "with a @" + annotationInstance.name().withoutPackagePrefix() + " annotation is in a class (" + declaringClass.name() + ") that does not have a @" + PlanningEntity.class.getSimpleName() + " annotation.\nMaybe add a @" + PlanningEntity.class.getSimpleName() + " annotation on the class (" + declaringClass.name() + ").");
        }
    }

    private void registerClassesFromAnnotations(IndexView indexView, Set<Class<?>> reflectiveClassSet) {
        for (DotNames.BeanDefiningAnnotations beanDefiningAnnotation : DotNames.BeanDefiningAnnotations.values()) {
            for (AnnotationInstance annotationInstance : indexView.getAnnotations(beanDefiningAnnotation.getAnnotationDotName())) {
                for (String parameterName : beanDefiningAnnotation.getParameterNames()) {
                    AnnotationValue value = annotationInstance.value(parameterName);
                    if (value == null) continue;
                    Type type = value.asClass();
                    try {
                        Class<?> beanClass = Class.forName(type.name().toString(), false, Thread.currentThread().getContextClassLoader());
                        reflectiveClassSet.add(beanClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Cannot find bean class (" + type.name() + ") referenced in annotation (" + annotationInstance + ").");
                    }
                }
            }
        }
    }

    protected void applyScoreDirectorFactoryProperties(IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = this.defaultScoreDirectoryFactoryConfig(indexView);
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        }
    }

    private boolean isClassDefined(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private ScoreDirectorFactoryConfig defaultScoreDirectoryFactoryConfig(IndexView indexView) {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findImplementingClass(DotNames.EASY_SCORE_CALCULATOR, indexView));
        scoreDirectorFactoryConfig.setConstraintProviderClass(this.findImplementingClass(DotNames.CONSTRAINT_PROVIDER, indexView));
        scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findImplementingClass(DotNames.INCREMENTAL_SCORE_CALCULATOR, indexView));
        if (scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getConstraintProviderClass() == null && scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() == null) {
            throw new IllegalStateException("No classes found that implement " + EasyScoreCalculator.class.getSimpleName() + ", " + ConstraintProvider.class.getSimpleName() + " or " + IncrementalScoreCalculator.class.getSimpleName() + ".");
        }
        return scoreDirectorFactoryConfig;
    }

    private <T> Class<? extends T> findImplementingClass(DotName targetDotName, IndexView indexView) {
        Collection classInfos = indexView.getAllKnownImplementors(targetDotName);
        if (classInfos.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertClassInfosToString(classInfos) + ") found that implement the interface " + targetDotName + ".");
        }
        if (classInfos.isEmpty()) {
            return null;
        }
        ClassInfo classInfo = (ClassInfo)classInfos.iterator().next();
        return this.convertClassInfoToClass(classInfo);
    }

    private String convertAnnotationInstancesToString(Collection<AnnotationInstance> annotationInstances) {
        return "[" + annotationInstances.stream().map(instance -> instance.target().toString()).collect(Collectors.joining(", ")) + "]";
    }

    private String convertClassInfosToString(Collection<ClassInfo> classInfos) {
        return "[" + classInfos.stream().map(instance -> instance.name().toString()).collect(Collectors.joining(", ")) + "]";
    }

    private <T> Class<? extends T> convertClassInfoToClass(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + className + ") cannot be created during deployment.", e);
        }
    }

    private GeneratedGizmoClasses generateDomainAccessors(SolverConfig solverConfig, IndexView indexView, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers, Set<Class<?>> reflectiveClassSet) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        HashSet<String> generatedMemberAccessorsClassNameSet = new HashSet<String>();
        HashSet<String> gizmoSolutionClonerClassNameSet = new HashSet<String>();
        GizmoMemberAccessorEntityEnhancer entityEnhancer = new GizmoMemberAccessorEntityEnhancer();
        if (solverConfig.getDomainAccessType() == DomainAccessType.GIZMO) {
            ArrayList<AnnotationInstance> membersToGeneratedAccessorsFor = new ArrayList<AnnotationInstance>();
            for (DotName dotName : DotNames.GIZMO_MEMBER_ACCESSOR_ANNOTATIONS) {
                membersToGeneratedAccessorsFor.addAll(indexView.getAnnotations(dotName));
            }
            membersToGeneratedAccessorsFor.removeIf(this::shouldIgnoreMember);
            Collection planningSolutionAnnotationInstanceCollection = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
            if (planningSolutionAnnotationInstanceCollection.isEmpty()) {
                throw new IllegalStateException("No classes found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
            }
            if (planningSolutionAnnotationInstanceCollection.size() > 1) {
                throw new IllegalStateException("Multiple classes (" + this.convertAnnotationInstancesToString(planningSolutionAnnotationInstanceCollection) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
            }
            AnnotationInstance planningSolutionAnnotationInstance = (AnnotationInstance)planningSolutionAnnotationInstanceCollection.stream().findFirst().orElseThrow();
            AutoDiscoverMemberType autoDiscoverMemberType = planningSolutionAnnotationInstance.values().stream().filter(v -> v.name().equals("autoDiscoverMemberType")).findFirst().map(AnnotationValue::asEnum).map(AutoDiscoverMemberType::valueOf).orElse(AutoDiscoverMemberType.NONE);
            if (autoDiscoverMemberType != AutoDiscoverMemberType.NONE) {
                throw new UnsupportedOperationException("Auto-discovery of members using %s is not supported under Quarkus.\nRemove the autoDiscoverMemberType property from the @%s annotation\nand explicitly annotate the fields or getters with annotations such as @%s, @%s or @%s.\n".formatted(AutoDiscoverMemberType.class.getSimpleName(), PlanningSolution.class.getSimpleName(), PlanningScore.class.getSimpleName(), PlanningEntityCollectionProperty.class.getSimpleName(), ProblemFactCollectionProperty.class.getSimpleName()));
            }
            block9: for (AnnotationInstance annotatedMember : membersToGeneratedAccessorsFor) {
                switch (annotatedMember.target().kind()) {
                    case FIELD: {
                        FieldInfo fieldInfo = annotatedMember.target().asField();
                        ClassInfo classInfo = fieldInfo.declaringClass();
                        try {
                            generatedMemberAccessorsClassNameSet.add(entityEnhancer.generateFieldAccessor(annotatedMember, (ClassOutput)classOutput, fieldInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchFieldException e) {
                            throw new IllegalStateException("Fail to generate member accessor for field (" + fieldInfo.name() + ") of the class( " + classInfo.name().toString() + ").", e);
                        }
                    }
                    case METHOD: {
                        MethodInfo methodInfo = annotatedMember.target().asMethod();
                        ClassInfo classInfo = methodInfo.declaringClass();
                        try {
                            generatedMemberAccessorsClassNameSet.add(entityEnhancer.generateMethodAccessor(annotatedMember, (ClassOutput)classOutput, classInfo, methodInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchMethodException e) {
                            throw new IllegalStateException("Failed to generate member accessor for the method (" + methodInfo.name() + ") of the class (" + classInfo.name() + ").", e);
                        }
                    }
                }
                throw new IllegalStateException("The member (" + annotatedMember + ") is not on a field or method.");
            }
            SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor((DomainAccessType)DomainAccessType.REFLECTION, (Class)solverConfig.getSolutionClass(), null, null, (List)solverConfig.getEntityClassList());
            gizmoSolutionClonerClassNameSet.add(entityEnhancer.generateSolutionCloner(solutionDescriptor, (ClassOutput)classOutput, indexView, transformers));
        }
        entityEnhancer.generateGizmoBeanFactory((ClassOutput)beanClassOutput, reflectiveClassSet, transformers);
        return new GeneratedGizmoClasses(generatedMemberAccessorsClassNameSet, gizmoSolutionClonerClassNameSet);
    }

    private boolean shouldIgnoreMember(AnnotationInstance annotationInstance) {
        switch (annotationInstance.target().kind()) {
            case FIELD: {
                return (annotationInstance.target().asField().flags() & 8) != 0;
            }
            case METHOD: {
                return (annotationInstance.target().asMethod().flags() & 8) != 0;
            }
        }
        throw new IllegalArgumentException("Annotation (" + annotationInstance.name() + ") can only be applied to methods and fields.");
    }

    private void registerCustomClassesFromSolverConfig(SolverConfig solverConfig, Set<Class<?>> reflectiveClassSet) {
        solverConfig.visitReferencedClasses(clazz -> {
            if (clazz != null) {
                reflectiveClassSet.add((Class<?>)clazz);
            }
        });
    }
}

