/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.deployment;

import ai.timefold.solver.core.api.domain.autodiscover.AutoDiscoverMemberType;
import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningEntityCollectionProperty;
import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.solution.ProblemFactCollectionProperty;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactoryService;
import ai.timefold.solver.core.impl.score.stream.JoinerService;
import ai.timefold.solver.quarkus.TimefoldRecorder;
import ai.timefold.solver.quarkus.bean.DefaultTimefoldBeanProvider;
import ai.timefold.solver.quarkus.bean.TimefoldSolverBannerBean;
import ai.timefold.solver.quarkus.bean.UnavailableTimefoldBeanProvider;
import ai.timefold.solver.quarkus.config.TimefoldRuntimeConfig;
import ai.timefold.solver.quarkus.deployment.DetermineIfNativeBuildItem;
import ai.timefold.solver.quarkus.deployment.DotNames;
import ai.timefold.solver.quarkus.deployment.GeneratedGizmoClasses;
import ai.timefold.solver.quarkus.deployment.GizmoMemberAccessorEntityEnhancer;
import ai.timefold.solver.quarkus.deployment.SolverConfigBuildItem;
import ai.timefold.solver.quarkus.deployment.config.SolverBuildTimeConfig;
import ai.timefold.solver.quarkus.deployment.config.TimefoldBuildTimeConfig;
import ai.timefold.solver.quarkus.devui.DevUISolverConfig;
import ai.timefold.solver.quarkus.devui.TimefoldDevUIPropertiesRPCService;
import ai.timefold.solver.quarkus.devui.TimefoldDevUIRecorder;
import ai.timefold.solver.quarkus.gizmo.TimefoldGizmoBeanFactory;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

class TimefoldProcessor {
    private static final Logger log = Logger.getLogger((String)TimefoldProcessor.class.getName());
    TimefoldBuildTimeConfig timefoldBuildTimeConfig;

    TimefoldProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("timefold-solver");
    }

    @BuildStep
    void registerSpi(BuildProducer<ServiceProviderBuildItem> services) {
        Stream.of(ScoreDirectorFactoryService.class, JoinerService.class, TimefoldSolverEnterpriseService.class).forEach(service -> TimefoldProcessor.registerSpi(service, services));
    }

    private static void registerSpi(Class<?> serviceClass, BuildProducer<ServiceProviderBuildItem> services) {
        String serviceName = serviceClass.getName();
        String service = "META-INF/services/" + serviceName;
        try {
            Set implementationSet = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service);
            services.produce((BuildItem)new ServiceProviderBuildItem(serviceName, implementationSet.toArray(new String[0])));
        }
        catch (IOException e) {
            throw new IllegalStateException("Impossible state: Failed registering service " + serviceClass.getCanonicalName(), e);
        }
    }

    @BuildStep
    void watchSolverConfigXml(BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        String solverConfigXML = this.timefoldBuildTimeConfig.solverConfigXml().orElse("solverConfig.xml");
        HashSet<String> solverCongigXmlFileSet = new HashSet<String>();
        solverCongigXmlFileSet.add(solverConfigXML);
        this.timefoldBuildTimeConfig.solver().values().stream().map(SolverBuildTimeConfig::solverConfigXml).filter(Optional::isPresent).map(Optional::get).forEach(solverCongigXmlFileSet::add);
        solverCongigXmlFileSet.forEach(file -> hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(file)));
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencyBuildItem() {
        return new IndexDependencyBuildItem("ai.timefold.solver", "timefold-solver-core-impl");
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void makeGizmoBeanFactoryUnremovable(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TimefoldGizmoBeanFactory.class}));
    }

    @BuildStep(onlyIfNot={NativeBuild.class})
    DetermineIfNativeBuildItem ifNotNativeBuild() {
        return new DetermineIfNativeBuildItem(false);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    DetermineIfNativeBuildItem ifNativeBuild() {
        return new DetermineIfNativeBuildItem(true);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem registerDevUICard() {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Configuration")).icon("font-awesome-solid:wrench")).componentLink("config-component.js"));
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Model")).icon("font-awesome-solid:wrench")).componentLink("model-component.js"));
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Constraints")).icon("font-awesome-solid:wrench")).componentLink("constraints-component.js"));
        return cardPageBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public JsonRPCProvidersBuildItem registerRPCService() {
        return new JsonRPCProvidersBuildItem("Timefold Solver", TimefoldDevUIPropertiesRPCService.class);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void makeSolverFactoryUnremovableInDevMode(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{SolverFactory.class}));
    }

    @BuildStep
    SolverConfigBuildItem recordAndRegisterBuildTimeBeans(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        IndexView indexView = combinedIndex.getIndex();
        if (indexView.getAnnotations(DotNames.PLANNING_SOLUTION).isEmpty() && indexView.getAnnotations(DotNames.PLANNING_ENTITY).isEmpty()) {
            log.warn((Object)("Skipping Timefold extension because there are no @" + PlanningSolution.class.getSimpleName() + " or @" + PlanningEntity.class.getSimpleName() + " annotated classes.\nIf your domain classes are located in a dependency of this project, maybe try generating the Jandex index by using the jandex-maven-plugin in that dependency, or by addingapplication.properties entries (quarkus.index-dependency.<name>.group-id and quarkus.index-dependency.<name>.artifact-id)."));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{UnavailableTimefoldBeanProvider.class}));
            HashMap<String, SolverConfig> solverConfigMap = new HashMap<String, SolverConfig>();
            this.timefoldBuildTimeConfig.solver().keySet().forEach(solverName -> solverConfigMap.put((String)solverName, (SolverConfig)null));
            return new SolverConfigBuildItem(solverConfigMap, null);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashMap<String, SolverConfig> solverConfigMap = new HashMap<String, SolverConfig>();
        if (this.timefoldBuildTimeConfig.solver().isEmpty()) {
            solverConfigMap.put("default", this.createSolverConfig(classLoader, "default"));
        } else {
            this.timefoldBuildTimeConfig.solver().keySet().forEach(solverName -> solverConfigMap.put((String)solverName, this.createSolverConfig(classLoader, (String)solverName)));
        }
        this.assertNoMemberAnnotationWithoutClassAnnotation(indexView);
        this.assertSolverConfigSolutionClasses(indexView, solverConfigMap);
        this.assertSolverConfigEntityClasses(indexView);
        this.assertSolverConfigConstraintClasses(indexView, solverConfigMap);
        LinkedHashSet reflectiveClassSet = new LinkedHashSet();
        solverConfigMap.forEach((solverName, solverConfig) -> this.loadSolverConfig(indexView, reflectiveHierarchyClass, (SolverConfig)solverConfig, (String)solverName, reflectiveClassSet));
        this.registerClassesFromAnnotations(indexView, reflectiveClassSet);
        solverConfigMap.values().stream().filter(config -> config.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null).map(config -> config.getScoreDirectorFactoryConfig().getConstraintProviderClass().getName()).distinct().map(constraintName -> solverConfigMap.entrySet().stream().filter(entryConfig -> ((SolverConfig)entryConfig.getValue()).getScoreDirectorFactoryConfig().getConstraintProviderClass().getName().equals(constraintName)).findFirst().get()).forEach(entryConfig -> this.generateConstraintVerifier((SolverConfig)entryConfig.getValue(), syntheticBeanBuildItemBuildProducer));
        GeneratedGizmoClasses generatedGizmoClasses = this.generateDomainAccessors(solverConfigMap, indexView, generatedBeans, generatedClasses, transformers, reflectiveClassSet);
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{TimefoldSolverBannerBean.class}));
        if (solverConfigMap.size() <= 1) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultTimefoldBeanProvider.class}));
        }
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TimefoldRuntimeConfig.class}));
        return new SolverConfigBuildItem(solverConfigMap, generatedGizmoClasses);
    }

    private void assertNoMemberAnnotationWithoutClassAnnotation(IndexView indexView) {
        HashSet timefoldFieldAnnotationCollection = new HashSet();
        for (DotName annotationName : DotNames.PLANNING_ENTITY_FIELD_ANNOTATIONS) {
            timefoldFieldAnnotationCollection.addAll(indexView.getAnnotationsWithRepeatable(annotationName, indexView));
        }
        for (AnnotationInstance annotationInstance : timefoldFieldAnnotationCollection) {
            String prefix;
            AnnotationTarget annotationTarget = annotationInstance.target();
            ClassInfo declaringClass = switch (annotationTarget.kind()) {
                case AnnotationTarget.Kind.FIELD -> {
                    prefix = "The field (%s)".formatted(annotationTarget.asField().name());
                    yield annotationTarget.asField().declaringClass();
                }
                case AnnotationTarget.Kind.METHOD -> {
                    prefix = "The method (%s)".formatted(annotationTarget.asMethod().name());
                    yield annotationTarget.asMethod().declaringClass();
                }
                default -> throw new IllegalStateException("Member annotation @%s is on (%s), which is an invalid target type (%s) for @%s.".formatted(annotationInstance.name().withoutPackagePrefix(), annotationTarget, annotationTarget.kind(), annotationInstance.name().withoutPackagePrefix()));
            };
            if (declaringClass.annotationsMap().containsKey(DotNames.PLANNING_ENTITY)) continue;
            throw new IllegalStateException("%s with a @%s annotation is in a class (%s) that does not have a @%s annotation.\nMaybe add a @%s annotation on the class (%s).".formatted(prefix, annotationInstance.name().withoutPackagePrefix(), declaringClass.name(), PlanningEntity.class.getSimpleName(), PlanningEntity.class.getSimpleName(), declaringClass.name()));
        }
    }

    private void assertSolverConfigSolutionClasses(IndexView indexView, Map<String, SolverConfig> solverConfigMap) {
        this.assertEmptyInstances(indexView, DotNames.PLANNING_SOLUTION);
        Collection annotationInstanceCollection = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
        if (annotationInstanceCollection.size() > 1 && solverConfigMap.size() == 1) {
            throw new IllegalStateException("Multiple classes (%s) found in the classpath with a @%s annotation.".formatted(this.convertAnnotationInstancesToString(annotationInstanceCollection), PlanningSolution.class.getSimpleName()));
        }
        List<String> solverConfigWithoutSolutionClassList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getSolutionClass() == null).map(Map.Entry::getKey).toList();
        if (annotationInstanceCollection.size() > 1 && !solverConfigWithoutSolutionClassList.isEmpty()) {
            throw new IllegalStateException("Some solver configs (%s) don't specify a %s class, yet there are multiple available (%s) on the classpath.\nMaybe set the XML config file to the related solver configs, or add the missing solution classes to the XML files,\nor remove the unnecessary solution classes from the classpath.".formatted(String.join((CharSequence)", ", solverConfigWithoutSolutionClassList), PlanningSolution.class.getSimpleName(), this.convertAnnotationInstancesToString(annotationInstanceCollection)));
        }
        List<String> unusedSolutionClassList = annotationInstanceCollection.stream().map(planningClass -> planningClass.target().asClass().name().toString()).filter(planningClassName -> solverConfigMap.values().stream().filter(c -> c.getSolutionClass() != null).noneMatch(c -> c.getSolutionClass().getName().equals(planningClassName))).toList();
        if (annotationInstanceCollection.size() > 1 && !unusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException("Unused classes ([%s]) found with a @%s annotation.".formatted(String.join((CharSequence)", ", unusedSolutionClassList), PlanningSolution.class.getSimpleName()));
        }
        List<AnnotationTarget> targetList = annotationInstanceCollection.stream().map(AnnotationInstance::target).toList();
        this.assertTargetClasses(targetList, DotNames.PLANNING_SOLUTION);
    }

    private void assertSolverConfigEntityClasses(IndexView indexView) {
        this.assertEmptyInstances(indexView, DotNames.PLANNING_ENTITY);
        Collection annotationInstanceCollection = indexView.getAnnotations(DotNames.PLANNING_ENTITY);
        List<AnnotationTarget> targetList = annotationInstanceCollection.stream().map(AnnotationInstance::target).toList();
        this.assertTargetClasses(targetList, DotNames.PLANNING_ENTITY);
    }

    private void assertSolverConfigConstraintClasses(IndexView indexView, Map<String, SolverConfig> solverConfigMap) {
        Collection simpleScoreClassCollection = indexView.getAllKnownImplementors(DotNames.EASY_SCORE_CALCULATOR);
        Collection constraintScoreClassCollection = indexView.getAllKnownImplementors(DotNames.CONSTRAINT_PROVIDER);
        Collection incrementalScoreClassCollection = indexView.getAllKnownImplementors(DotNames.INCREMENTAL_SCORE_CALCULATOR);
        if (simpleScoreClassCollection.isEmpty() && constraintScoreClassCollection.isEmpty() && incrementalScoreClassCollection.isEmpty()) {
            throw new IllegalStateException("No classes found that implement %s, %s, or %s.".formatted(EasyScoreCalculator.class.getSimpleName(), ConstraintProvider.class.getSimpleName(), IncrementalScoreCalculator.class.getSimpleName()));
        }
        String errorMessage = "Multiple score classes classes (%s) that implements %s were found in the classpath.";
        if (simpleScoreClassCollection.size() > 1 && solverConfigMap.size() == 1) {
            throw new IllegalStateException(errorMessage.formatted(simpleScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", ")), EasyScoreCalculator.class.getSimpleName()));
        }
        if (constraintScoreClassCollection.size() > 1 && solverConfigMap.size() == 1) {
            throw new IllegalStateException(errorMessage.formatted(constraintScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", ")), ConstraintProvider.class.getSimpleName()));
        }
        if (incrementalScoreClassCollection.size() > 1 && solverConfigMap.size() == 1) {
            throw new IllegalStateException(errorMessage.formatted(incrementalScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", ")), IncrementalScoreCalculator.class.getSimpleName()));
        }
        errorMessage = "Some solver configs (%s) don't specify a %s score class, yet there are multiple available (%s) on the classpath.\nMaybe set the XML config file to the related solver configs, or add the missing score classes to the XML files,\nor remove the unnecessary score classes from the classpath.";
        List<String> solverConfigWithoutConstraintClassList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig() == null || ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig().getEasyScoreCalculatorClass() == null).map(Map.Entry::getKey).toList();
        if (simpleScoreClassCollection.size() > 1 && !solverConfigWithoutConstraintClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithoutConstraintClassList), EasyScoreCalculator.class.getSimpleName(), simpleScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", "))));
        }
        solverConfigWithoutConstraintClassList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig() == null || ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig().getConstraintProviderClass() == null).map(Map.Entry::getKey).toList();
        if (constraintScoreClassCollection.size() > 1 && !solverConfigWithoutConstraintClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithoutConstraintClassList), ConstraintProvider.class.getSimpleName(), constraintScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", "))));
        }
        solverConfigWithoutConstraintClassList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig() == null || ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig().getIncrementalScoreCalculatorClass() == null).map(Map.Entry::getKey).toList();
        if (incrementalScoreClassCollection.size() > 1 && !solverConfigWithoutConstraintClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithoutConstraintClassList), IncrementalScoreCalculator.class.getSimpleName(), incrementalScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", "))));
        }
        List<String> solverConfigWithUnusedSolutionClassList = simpleScoreClassCollection.stream().map(clazz -> clazz.name().toString()).filter(className -> solverConfigMap.values().stream().filter(c -> c.getScoreDirectorFactoryConfig() != null && c.getScoreDirectorFactoryConfig().getEasyScoreCalculatorClass() != null).noneMatch(c -> c.getScoreDirectorFactoryConfig().getEasyScoreCalculatorClass().getName().equals(className))).toList();
        errorMessage = "Unused classes ([%s]) that implements %s were found.";
        if (simpleScoreClassCollection.size() > 1 && !solverConfigWithUnusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithUnusedSolutionClassList), EasyScoreCalculator.class.getSimpleName()));
        }
        solverConfigWithUnusedSolutionClassList = constraintScoreClassCollection.stream().map(clazz -> clazz.name().toString()).filter(className -> solverConfigMap.values().stream().filter(c -> c.getScoreDirectorFactoryConfig() != null && c.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null).noneMatch(c -> c.getScoreDirectorFactoryConfig().getConstraintProviderClass().getName().equals(className))).toList();
        if (constraintScoreClassCollection.size() > 1 && !solverConfigWithUnusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithUnusedSolutionClassList), ConstraintProvider.class.getSimpleName()));
        }
        solverConfigWithUnusedSolutionClassList = incrementalScoreClassCollection.stream().map(clazz -> clazz.name().toString()).filter(className -> solverConfigMap.values().stream().filter(c -> c.getScoreDirectorFactoryConfig() != null && c.getScoreDirectorFactoryConfig().getIncrementalScoreCalculatorClass() != null).noneMatch(c -> c.getScoreDirectorFactoryConfig().getIncrementalScoreCalculatorClass().getName().equals(className))).toList();
        if (incrementalScoreClassCollection.size() > 1 && !solverConfigWithUnusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithUnusedSolutionClassList), IncrementalScoreCalculator.class.getSimpleName()));
        }
    }

    private void assertEmptyInstances(IndexView indexView, DotName dotName) {
        Collection annotationInstanceCollection = indexView.getAnnotations(dotName);
        if (annotationInstanceCollection.isEmpty()) {
            try {
                throw new IllegalStateException("No classes were found with a @%s annotation.".formatted(Class.forName(dotName.local()).getSimpleName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void assertTargetClasses(List<AnnotationTarget> targetList, DotName dotName) {
        if (targetList.stream().anyMatch(target -> target.kind() != AnnotationTarget.Kind.CLASS)) {
            throw new IllegalStateException("All classes ([%s]) annotated with @%s must be a class.".formatted(targetList.stream().map(t -> t.asClass().name().toString()).collect(Collectors.joining(", ")), dotName.local()));
        }
    }

    private SolverConfig createSolverConfig(ClassLoader classLoader, String solverName) {
        SolverConfig solverConfig;
        Optional<Object> solverConfigXml = this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::solverConfigXml);
        if (solverConfigXml.isEmpty()) {
            solverConfigXml = this.timefoldBuildTimeConfig.solverConfigXml();
        }
        if (solverConfigXml.isPresent()) {
            String solverUrl = (String)solverConfigXml.get();
            if (classLoader.getResource(solverUrl) == null) {
                String message = "Invalid quarkus.timefold.solverConfigXML property (%s): that classpath resource does not exist.".formatted(solverUrl);
                if (!solverName.equals("default")) {
                    message = "Invalid quarkus.timefold.solver.\"%s\".solverConfigXML property (%s): that classpath resource does not exist.".formatted(solverName, solverUrl);
                }
                throw new ConfigurationException(message);
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverUrl);
        } else {
            solverConfig = classLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml") : new SolverConfig();
        }
        return solverConfig;
    }

    private SolverConfig loadSolverConfig(IndexView indexView, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, SolverConfig solverConfig, String solverName, Set<Class<?>> reflectiveClassSet) {
        this.applySolverProperties(indexView, solverName, solverConfig);
        if (solverConfig.getSolutionClass() != null) {
            Type jandexType = Type.create((DotName)DotName.createSimple((String)solverConfig.getSolutionClass().getName()), (Type.Kind)Type.Kind.CLASS);
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(jandexType).ignoreTypePredicate(dotName -> ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName) || dotName.toString().startsWith("ai.timefold.solver.api") || dotName.toString().startsWith("ai.timefold.solver.config") || dotName.toString().startsWith("ai.timefold.solver.impl")).build());
        }
        this.registerCustomClassesFromSolverConfig(solverConfig, reflectiveClassSet);
        return solverConfig;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void recordAndRegisterRuntimeBeans(TimefoldRecorder recorder, RecorderContext recorderContext, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, SolverConfigBuildItem solverConfigBuildItem, TimefoldRuntimeConfig runtimeConfig) {
        if (solverConfigBuildItem.getGeneratedGizmoClasses() == null) {
            return;
        }
        solverConfigBuildItem.getSolverConfigMap().forEach((key, value) -> {
            if (this.timefoldBuildTimeConfig.isDefaultSolverConfig((String)key)) {
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverConfig.class).scope(Singleton.class)).supplier(recorder.solverConfigSupplier(key, value, runtimeConfig, GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoSolutionClonerClassSet))).setRuntimeInit().defaultBean()).done());
                SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManagerConfig.class).scope(Singleton.class)).supplier(recorder.solverManagerConfig(solverManagerConfig, runtimeConfig)).setRuntimeInit().defaultBean()).done());
            }
            if (!this.timefoldBuildTimeConfig.isDefaultSolverConfig((String)key)) {
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManager.class).scope(Singleton.class)).addType((Type)ParameterizedType.create((DotName)DotName.createSimple((String)SolverManager.class.getName()), (Type[])new Type[]{Type.create((DotName)DotName.createSimple((String)value.getSolutionClass().getName()), (Type.Kind)Type.Kind.CLASS), TypeVariable.create((String)Object.class.getName())}))).supplier(recorder.solverManager(key, value, runtimeConfig, GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoSolutionClonerClassSet))).setRuntimeInit().named(key)).done());
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordAndRegisterDevUIBean(TimefoldDevUIRecorder devUIRecorder, RecorderContext recorderContext, SolverConfigBuildItem solverConfigBuildItem, TimefoldRuntimeConfig runtimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DevUISolverConfig.class).scope(ApplicationScoped.class)).supplier(devUIRecorder.solverConfigSupplier(solverConfigBuildItem.getSolverConfigMap(), runtimeConfig, GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoSolutionClonerClassSet))).defaultBean()).setRuntimeInit().done());
    }

    private void generateConstraintVerifier(SolverConfig solverConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        String constraintVerifierClassName = DotNames.CONSTRAINT_VERIFIER.toString();
        if (solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null && this.isClassDefined(constraintVerifierClassName)) {
            Class constraintProviderClass = solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass();
            Class planningSolutionClass = solverConfig.getSolutionClass();
            List planningEntityClassList = solverConfig.getEntityClassList();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator constraintDescriptor = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotNames.CONSTRAINT_VERIFIER).scope(Singleton.class)).creator(methodCreator -> {
                ResultHandle constraintProviderResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Class)constraintProviderClass, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle planningSolutionClassResultHandle = methodCreator.loadClass(planningSolutionClass);
                ResultHandle planningEntityClassesResultHandle = methodCreator.newArray(Class.class, planningEntityClassList.size());
                for (int i = 0; i < planningEntityClassList.size(); ++i) {
                    ResultHandle planningEntityClassResultHandle = methodCreator.loadClass((Class)planningEntityClassList.get(i));
                    methodCreator.writeArrayValue(planningEntityClassesResultHandle, i, planningEntityClassResultHandle);
                }
                ResultHandle solutionDescriptorResultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(SolutionDescriptor.class, (String)"buildSolutionDescriptor", SolutionDescriptor.class, (Class[])new Class[]{Class.class, Class[].class}), new ResultHandle[]{planningSolutionClassResultHandle, planningEntityClassesResultHandle});
                ResultHandle constraintVerifierResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Object)"ai.timefold.solver.test.impl.score.stream.DefaultConstraintVerifier", (Object[])new Object[]{ConstraintProvider.class, SolutionDescriptor.class}), new ResultHandle[]{constraintProviderResultHandle, solutionDescriptorResultHandle});
                methodCreator.returnValue(constraintVerifierResultHandle);
            })).addType((Type)ParameterizedType.create((DotName)DotNames.CONSTRAINT_VERIFIER, (Type[])new Type[]{Type.create((DotName)DotName.createSimple((String)constraintProviderClass.getName()), (Type.Kind)Type.Kind.CLASS), Type.create((DotName)DotName.createSimple((String)planningSolutionClass.getName()), (Type.Kind)Type.Kind.CLASS)}, null))).forceApplicationClass()).defaultBean();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)constraintDescriptor.done());
        }
    }

    private void applySolverProperties(IndexView indexView, String solverName, SolverConfig solverConfig) {
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findFirstSolutionClass(indexView));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(indexView));
        }
        this.applyScoreDirectorFactoryProperties(indexView, solverConfig);
        this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::environmentMode).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setEnvironmentMode(arg_0));
        this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::daemon).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDaemon(arg_0));
        this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::domainAccessType).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDomainAccessType(arg_0));
        if (solverConfig.getDomainAccessType() == null) {
            solverConfig.setDomainAccessType(DomainAccessType.GIZMO);
        }
        this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::nearbyDistanceMeterClass).ifPresent(clazz -> {
            if (!NearbyDistanceMeter.class.isAssignableFrom((Class<?>)clazz)) {
                throw new IllegalArgumentException("The Nearby Selection Meter class (%s) of the solver config (%s) does not implement NearbyDistanceMeter.".formatted(clazz, solverName));
            }
            solverConfig.withNearbyDistanceMeterClass(clazz);
        });
    }

    private Class<?> findFirstSolutionClass(IndexView indexView) {
        Collection annotationInstanceCollection = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
        AnnotationTarget solutionTarget = ((AnnotationInstance)annotationInstanceCollection.iterator().next()).target();
        return this.convertClassInfoToClass(solutionTarget.asClass());
    }

    private List<Class<?>> findEntityClassList(IndexView indexView) {
        return indexView.getAnnotations(DotNames.PLANNING_ENTITY).stream().map(AnnotationInstance::target).map(target -> this.convertClassInfoToClass(target.asClass())).collect(Collectors.toList());
    }

    private void registerClassesFromAnnotations(IndexView indexView, Set<Class<?>> reflectiveClassSet) {
        for (DotNames.BeanDefiningAnnotations beanDefiningAnnotation : DotNames.BeanDefiningAnnotations.values()) {
            for (AnnotationInstance annotationInstance : indexView.getAnnotationsWithRepeatable(beanDefiningAnnotation.getAnnotationDotName(), indexView)) {
                for (String parameterName : beanDefiningAnnotation.getParameterNames()) {
                    AnnotationValue value = annotationInstance.value(parameterName);
                    if (value == null) continue;
                    Type type = value.asClass();
                    try {
                        Class<?> beanClass = Class.forName(type.name().toString(), false, Thread.currentThread().getContextClassLoader());
                        reflectiveClassSet.add(beanClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Cannot find bean class (%s) referenced in annotation (%s).".formatted(type.name(), annotationInstance));
                    }
                }
            }
        }
    }

    protected void applyScoreDirectorFactoryProperties(IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = this.defaultScoreDirectoryFactoryConfig(indexView);
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        }
    }

    private boolean isClassDefined(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private ScoreDirectorFactoryConfig defaultScoreDirectoryFactoryConfig(IndexView indexView) {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findFirstImplementingClass(DotNames.EASY_SCORE_CALCULATOR, indexView));
        scoreDirectorFactoryConfig.setConstraintProviderClass(this.findFirstImplementingClass(DotNames.CONSTRAINT_PROVIDER, indexView));
        scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findFirstImplementingClass(DotNames.INCREMENTAL_SCORE_CALCULATOR, indexView));
        return scoreDirectorFactoryConfig;
    }

    private <T> Class<? extends T> findFirstImplementingClass(DotName targetDotName, IndexView indexView) {
        Collection classInfoCollection = indexView.getAllKnownImplementors(targetDotName);
        if (classInfoCollection.isEmpty()) {
            return null;
        }
        ClassInfo classInfo = (ClassInfo)classInfoCollection.iterator().next();
        return this.convertClassInfoToClass(classInfo);
    }

    private String convertAnnotationInstancesToString(Collection<AnnotationInstance> annotationInstanceCollection) {
        return "[%s]".formatted(annotationInstanceCollection.stream().map(instance -> instance.target().toString()).collect(Collectors.joining(", ")));
    }

    private <T> Class<? extends T> convertClassInfoToClass(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (%s) cannot be created during deployment.".formatted(className), e);
        }
    }

    private GeneratedGizmoClasses generateDomainAccessors(Map<String, SolverConfig> solverConfigMap, IndexView indexView, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers, Set<Class<?>> reflectiveClassSet) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        HashSet<String> generatedMemberAccessorsClassNameSet = new HashSet<String>();
        HashSet<String> gizmoSolutionClonerClassNameSet = new HashSet<String>();
        this.assertSolverDomainAccessType(solverConfigMap);
        GizmoMemberAccessorEntityEnhancer entityEnhancer = new GizmoMemberAccessorEntityEnhancer();
        if (solverConfigMap.values().stream().anyMatch(c -> c.getDomainAccessType() == DomainAccessType.GIZMO)) {
            ArrayList<AnnotationInstance> membersToGeneratedAccessorsForCollection = new ArrayList<AnnotationInstance>();
            for (DotName dotName : DotNames.GIZMO_MEMBER_ACCESSOR_ANNOTATIONS) {
                membersToGeneratedAccessorsForCollection.addAll(indexView.getAnnotationsWithRepeatable(dotName, indexView));
            }
            membersToGeneratedAccessorsForCollection.removeIf(this::shouldIgnoreMember);
            Collection planningSolutionAnnotationInstanceCollection = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
            List<String> unusedSolutionClassList = planningSolutionAnnotationInstanceCollection.stream().map(planningClass -> planningClass.target().asClass().name().toString()).filter(planningClassName -> reflectiveClassSet.stream().noneMatch(clazz -> clazz.getName().equals(planningClassName))).toList();
            if (planningSolutionAnnotationInstanceCollection.isEmpty()) {
                throw new IllegalStateException("No classes found with a @%s annotation.".formatted(PlanningSolution.class.getSimpleName()));
            }
            if (planningSolutionAnnotationInstanceCollection.size() > 1 && !unusedSolutionClassList.isEmpty()) {
                throw new IllegalStateException("Unused classes (%s) found with a @%s annotation.".formatted(String.join((CharSequence)", ", unusedSolutionClassList), PlanningSolution.class.getSimpleName()));
            }
            planningSolutionAnnotationInstanceCollection.forEach(planningSolutionAnnotationInstance -> {
                AutoDiscoverMemberType autoDiscoverMemberType = planningSolutionAnnotationInstance.values().stream().filter(v -> v.name().equals("autoDiscoverMemberType")).findFirst().map(AnnotationValue::asEnum).map(AutoDiscoverMemberType::valueOf).orElse(AutoDiscoverMemberType.NONE);
                if (autoDiscoverMemberType != AutoDiscoverMemberType.NONE) {
                    throw new UnsupportedOperationException("Auto-discovery of members using %s is not supported under Quarkus.\nRemove the autoDiscoverMemberType property from the @%s annotation\nand explicitly annotate the fields or getters with annotations such as @%s, @%s or @%s.".strip().formatted(AutoDiscoverMemberType.class.getSimpleName(), PlanningSolution.class.getSimpleName(), PlanningScore.class.getSimpleName(), PlanningEntityCollectionProperty.class.getSimpleName(), ProblemFactCollectionProperty.class.getSimpleName()));
                }
            });
            block9: for (AnnotationInstance annotatedMember : membersToGeneratedAccessorsForCollection) {
                switch (annotatedMember.target().kind()) {
                    case FIELD: {
                        FieldInfo fieldInfo = annotatedMember.target().asField();
                        ClassInfo classInfo = fieldInfo.declaringClass();
                        try {
                            generatedMemberAccessorsClassNameSet.add(entityEnhancer.generateFieldAccessor(annotatedMember, (ClassOutput)classOutput, fieldInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchFieldException e) {
                            throw new IllegalStateException("Fail to generate member accessor for field (%s) of the class(%s).".formatted(fieldInfo.name(), classInfo.name().toString()), e);
                        }
                    }
                    case METHOD: {
                        MethodInfo methodInfo = annotatedMember.target().asMethod();
                        ClassInfo classInfo = methodInfo.declaringClass();
                        try {
                            generatedMemberAccessorsClassNameSet.add(entityEnhancer.generateMethodAccessor(annotatedMember, (ClassOutput)classOutput, classInfo, methodInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchMethodException e) {
                            throw new IllegalStateException("Failed to generate member accessor for the method (%s) of the class (%s).".formatted(methodInfo.name(), classInfo.name()), e);
                        }
                    }
                }
                throw new IllegalStateException("The member (%s) is not on a field or method.".formatted(annotatedMember));
            }
            solverConfigMap.values().forEach(arg_0 -> TimefoldProcessor.lambda$generateDomainAccessors$50(gizmoSolutionClonerClassNameSet, entityEnhancer, (ClassOutput)classOutput, indexView, transformers, arg_0));
        }
        entityEnhancer.generateGizmoBeanFactory((ClassOutput)beanClassOutput, reflectiveClassSet, transformers);
        return new GeneratedGizmoClasses(generatedMemberAccessorsClassNameSet, gizmoSolutionClonerClassNameSet);
    }

    private void assertSolverDomainAccessType(Map<String, SolverConfig> solverConfigMap) {
        if (solverConfigMap.values().stream().map(SolverConfig::getDomainAccessType).distinct().count() > 1L) {
            throw new ConfigurationException("The domain access type must be unique across all Solver configurations.\n%s".formatted(solverConfigMap.entrySet().stream().map(e -> String.format("quarkus.timefold.\"%s\".domain-access-type=%s", e.getKey(), ((SolverConfig)e.getValue()).getDomainAccessType())).collect(Collectors.joining("\n"))));
        }
    }

    private boolean shouldIgnoreMember(AnnotationInstance annotationInstance) {
        switch (annotationInstance.target().kind()) {
            case FIELD: {
                return (annotationInstance.target().asField().flags() & 8) != 0;
            }
            case METHOD: {
                return (annotationInstance.target().asMethod().flags() & 8) != 0;
            }
        }
        throw new IllegalArgumentException("Annotation (%s) can only be applied to methods and fields.".formatted(annotationInstance.name()));
    }

    private void registerCustomClassesFromSolverConfig(SolverConfig solverConfig, Set<Class<?>> reflectiveClassSet) {
        solverConfig.visitReferencedClasses(clazz -> {
            if (clazz != null) {
                reflectiveClassSet.add((Class<?>)clazz);
            }
        });
    }

    private static /* synthetic */ void lambda$generateDomainAccessors$50(Set gizmoSolutionClonerClassNameSet, GizmoMemberAccessorEntityEnhancer entityEnhancer, ClassOutput classOutput, IndexView indexView, BuildProducer transformers, SolverConfig c) {
        SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor((DomainAccessType)DomainAccessType.REFLECTION, (Class)c.getSolutionClass(), null, null, (List)c.getEntityClassList());
        gizmoSolutionClonerClassNameSet.add(entityEnhancer.generateSolutionCloner(solutionDescriptor, classOutput, indexView, (BuildProducer<BytecodeTransformerBuildItem>)transformers));
    }
}

