/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.service;

import ai.tock.bot.admin.bot.BotConfiguration;
import ai.tock.bot.api.model.UserRequest;
import ai.tock.bot.api.model.configuration.ClientConfiguration;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.service.BotApiClient;
import ai.tock.bot.api.service.BotApiClientController;
import ai.tock.bot.api.service.BotApiClientControllerKt;
import ai.tock.bot.api.service.BotApiDefinitionProvider;
import ai.tock.bot.api.service.WSHolder;
import ai.tock.bot.engine.WebSocketController;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0004\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/tock/bot/api/service/BotApiClientController;", "", "provider", "Lai/tock/bot/api/service/BotApiDefinitionProvider;", "configuration", "Lai/tock/bot/admin/bot/BotConfiguration;", "(Lai/tock/bot/api/service/BotApiDefinitionProvider;Lai/tock/bot/admin/bot/BotConfiguration;)V", "apiKey", "", "client", "Lai/tock/bot/api/service/BotApiClient;", "logger", "Lmu/KLogger;", "webhookUrl", "Lai/tock/bot/api/model/configuration/ClientConfiguration;", "send", "Lai/tock/bot/api/model/websocket/ResponseData;", "userRequest", "Lai/tock/bot/api/model/UserRequest;", "sendWithWebSocket", "request", "Lai/tock/bot/api/model/websocket/RequestData;", "tock-bot-api-service"})
@SourceDebugExtension(value={"SMAP\nBotApiClientController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiClientController.kt\nai/tock/bot/api/service/BotApiClientController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class BotApiClientController {
    @NotNull
    private final BotApiDefinitionProvider provider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String apiKey;
    @Nullable
    private final String webhookUrl;
    @Nullable
    private final BotApiClient client;

    /*
     * Unable to fully structure code
     */
    public BotApiClientController(@NotNull BotApiDefinitionProvider provider, @NotNull BotConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super();
        this.provider = provider;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.apiKey = configuration.getApiKey();
        this.webhookUrl = configuration.getWebhookUrl();
        v0 = this;
        v1 = this.webhookUrl;
        if (v1 == null) ** GOTO lbl-1000
        var4_4 = var3_3 = v1;
        var8_5 = v0;
        $i$a$-takeUnless-BotApiClientController$client$1 = false;
        var9_7 = StringsKt.isBlank((CharSequence)it);
        v0 = var8_5;
        v1 = var9_7 == false ? var3_3 : null;
        if (v1 != null) {
            it = v1;
            var8_5 = v0;
            $i$a$-let-BotApiClientController$client$2 = false;
            try {
                var6_8 = new BotApiClient(it);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)this.logger, (Throwable)e);
                var6_8 = null;
            }
            v2 = var6_8;
            v0 = var8_5;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v0.client = v2;
        if (WebSocketController.INSTANCE.getWebsocketEnabled()) {
            this.logger.debug((Function0)new Function0<Object>(){

                public final Object invoke() {
                    return "register " + apiKey;
                }
            });
            WebSocketController.INSTANCE.registerAuthorizedKey(this.apiKey);
            WebSocketController.INSTANCE.setReceiveHandler(this.apiKey, (Function1)new Function1<String, Unit>(){

                public final void invoke(final String content) {
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    try {
                        ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        final ResponseData response = (ResponseData)$this$readValue$iv.readValue(content, (TypeReference)new TypeReference<ResponseData>(){});
                        if (response != null) {
                            ClientConfiguration conf = response.getBotConfiguration();
                            if (conf == null) {
                                WSHolder holder = (WSHolder)BotApiClientControllerKt.access$getWsRepository$p().getIfPresent((Object)response.getRequestId());
                                if (holder == null) {
                                    logger.warn((Function0)new Function0<Object>(){

                                        public final Object invoke() {
                                            return "unknown request " + response.getRequestId();
                                        }
                                    });
                                }
                                WSHolder wSHolder = holder;
                                if (wSHolder != null) {
                                    wSHolder.receive(response);
                                }
                            } else {
                                provider.updateIfConfigurationChange(conf);
                            }
                        } else {
                            logger.warn((Function0)new Function0<Object>(){

                                public final Object invoke() {
                                    return "null response: " + content;
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)logger, (Throwable)e);
                    }
                }
            });
        }
    }

    @Nullable
    public final ClientConfiguration configuration() {
        BotApiClient botApiClient = this.client;
        if (botApiClient == null || (botApiClient = botApiClient.send(new RequestData(null, Boolean.valueOf(true), null, 5, null))) == null || (botApiClient = botApiClient.getBotConfiguration()) == null) {
            ResponseData responseData = this.sendWithWebSocket(new RequestData(null, Boolean.valueOf(true), null, 5, null));
            botApiClient = responseData != null ? responseData.getBotConfiguration() : null;
        }
        return botApiClient;
    }

    @Nullable
    public final ResponseData send(@NotNull UserRequest userRequest) {
        ResponseData responseData;
        Intrinsics.checkNotNullParameter((Object)userRequest, (String)"userRequest");
        RequestData request = new RequestData(userRequest, null, null, 6, null);
        if (this.client != null) {
            responseData = this.client.send(request);
        } else {
            responseData = this.sendWithWebSocket(request);
            if (responseData == null) {
                throw new IllegalStateException("no webhook set and no response from websocket".toString());
            }
        }
        return responseData;
    }

    private final ResponseData sendWithWebSocket(RequestData request) {
        ResponseData responseData;
        Function1 pushHandler = WebSocketController.INSTANCE.getPushHandler(this.apiKey);
        if (pushHandler != null) {
            WSHolder holder = new WSHolder(null, null, 3, null);
            BotApiClientControllerKt.access$getWsRepository$p().put((Object)request.getRequestId(), (Object)holder);
            this.logger.debug((Function0)new Function0<Object>(request){
                final /* synthetic */ RequestData $request;
                {
                    this.$request = $request;
                    super(0);
                }

                public final Object invoke() {
                    return "send request " + this.$request.getRequestId();
                }
            });
            String string = JacksonKt.getMapper().writeValueAsString((Object)request);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            pushHandler.invoke((Object)string);
            responseData = holder.wait();
        } else {
            responseData = null;
        }
        return responseData;
    }
}

