/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.open.data.client.sncf;

import ai.tock.bot.open.data.OpenDataConfiguration;
import ai.tock.bot.open.data.client.sncf.SncfOpenDataApi;
import ai.tock.bot.open.data.client.sncf.model.ArrivalsResponse;
import ai.tock.bot.open.data.client.sncf.model.DeparturesResponse;
import ai.tock.bot.open.data.client.sncf.model.Journey;
import ai.tock.bot.open.data.client.sncf.model.JourneysResponse;
import ai.tock.bot.open.data.client.sncf.model.Place;
import ai.tock.bot.open.data.client.sncf.model.PlaceValue;
import ai.tock.bot.open.data.client.sncf.model.PlacesNearbyResponse;
import ai.tock.bot.open.data.client.sncf.model.PlacesResponse;
import ai.tock.bot.open.data.client.sncf.model.SncfPlace;
import ai.tock.bot.open.data.client.sncf.model.StationStop;
import ai.tock.bot.open.data.client.sncf.model.VehicleJourney;
import ai.tock.bot.open.data.client.sncf.model.VehicleJourneysResponse;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/tock/bot/open/data/client/sncf/SncfOpenDataClient;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "api", "Lai/tock/bot/open/data/client/sncf/SncfOpenDataApi;", "findPlace", "Lai/tock/bot/open/data/client/sncf/model/PlaceValue;", "name", "", "places", "", "Lai/tock/bot/open/data/client/sncf/model/SncfPlace;", "query", "bestPlaceMatch", "journey", "Lai/tock/bot/open/data/client/sncf/model/Journey;", "from", "Lai/tock/bot/open/data/client/sncf/model/Place;", "to", "datetime", "Ljava/time/LocalDateTime;", "departures", "Lai/tock/bot/open/data/client/sncf/model/StationStop;", "arrivals", "vehicleJourney", "Lai/tock/bot/open/data/client/sncf/model/VehicleJourney;", "id", "tock-bot-open-data"})
@SourceDebugExtension(value={"SMAP\nSncfOpenDataClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SncfOpenDataClient.kt\nai/tock/bot/open/data/client/sncf/SncfOpenDataClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,126:1\n1#2:127\n295#3,2:128\n71#4:130\n*S KotlinDebug\n*F\n+ 1 SncfOpenDataClient.kt\nai/tock/bot/open/data/client/sncf/SncfOpenDataClient\n*L\n93#1:128,2\n75#1:130\n*E\n"})
public final class SncfOpenDataClient {
    @NotNull
    public static final SncfOpenDataClient INSTANCE = new SncfOpenDataClient();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(SncfOpenDataClient::logger$lambda$0);
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
    @NotNull
    private static final SncfOpenDataApi api;

    private SncfOpenDataClient() {
    }

    @Nullable
    public final PlaceValue findPlace(@NotNull String name) {
        PlaceValue placeValue;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SncfPlace sncfPlace = this.bestPlaceMatch(name);
        if (sncfPlace != null) {
            SncfPlace it = sncfPlace;
            boolean bl = false;
            placeValue = new PlaceValue(it);
        } else {
            placeValue = null;
        }
        return placeValue;
    }

    @NotNull
    public final List<SncfPlace> places(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Object object = (PlacesResponse)api.places(query).execute().body();
        if (object == null || (object = ((PlacesResponse)object).getPlaces()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final SncfPlace bestPlaceMatch(@NotNull String query) {
        SncfPlace sncfPlace;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        SncfPlace p = (SncfPlace)CollectionsKt.firstOrNull(this.places(query));
        if (p != null && !Intrinsics.areEqual((Object)p.getEmbeddedType(), (Object)"stop_area")) {
            List<SncfPlace> list;
            PlacesNearbyResponse placesNearbyResponse = (PlacesNearbyResponse)api.placesNearby(p.getId()).execute().body();
            if (placesNearbyResponse != null && (list = placesNearbyResponse.getPlaces()) != null) {
                Object v0;
                List<SncfPlace> $this$bestPlaceMatch_u24lambda_u244;
                block6: {
                    $this$bestPlaceMatch_u24lambda_u244 = list;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = $this$bestPlaceMatch_u24lambda_u244;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SncfPlace it = (SncfPlace)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getEmbeddedType(), (Object)"stop_area")) continue;
                        v0 = element$iv;
                        break block6;
                    }
                    v0 = null;
                }
                if ((sncfPlace = (SncfPlace)v0) == null) {
                    sncfPlace = (SncfPlace)CollectionsKt.firstOrNull($this$bestPlaceMatch_u24lambda_u244);
                }
            } else {
                sncfPlace = null;
            }
        } else {
            sncfPlace = p;
        }
        return sncfPlace;
    }

    @NotNull
    public final List<Journey> journey(@NotNull Place from, @NotNull Place to, @NotNull LocalDateTime datetime) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)datetime, (String)"datetime");
        String string = from.getId();
        String string2 = to.getId();
        String string3 = dateFormat.format(datetime);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        Object object = (JourneysResponse)api.journeys(string, string2, string3).execute().body();
        if (object == null || (object = ((JourneysResponse)object).getJourneys()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<StationStop> departures(@NotNull Place from, @NotNull LocalDateTime datetime) {
        List<StationStop> list;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)datetime, (String)"datetime");
        String string = from.getId();
        String string2 = dateFormat.format(datetime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        DeparturesResponse departuresResponse = (DeparturesResponse)api.departures(string, string2).execute().body();
        return departuresResponse != null && (list = departuresResponse.getDepartures()) != null ? list : CollectionsKt.emptyList();
    }

    @NotNull
    public final List<StationStop> arrivals(@NotNull Place from, @NotNull LocalDateTime datetime) {
        List<StationStop> list;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)datetime, (String)"datetime");
        String string = from.getId();
        String string2 = dateFormat.format(datetime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        ArrivalsResponse arrivalsResponse = (ArrivalsResponse)api.arrivals(string, string2).execute().body();
        return arrivalsResponse != null && (list = arrivalsResponse.getArrivals()) != null ? list : CollectionsKt.emptyList();
    }

    @Nullable
    public final VehicleJourney vehicleJourney(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = (VehicleJourneysResponse)api.vehicleJourneys(id).execute().body();
        return object != null && (object = ((VehicleJourneysResponse)object).getVehicleJourney()) != null ? (VehicleJourney)CollectionsKt.firstOrNull((List)object) : null;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Response api$lambda$1(Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        return chain.proceed(chain.request().newBuilder().header("Authorization", Credentials.basic$default((String)OpenDataConfiguration.INSTANCE.getSncfApiUser(), (String)"", null, (int)4, null)).build());
    }

    static {
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)30000L, (KLogger)logger, null, (List)CollectionsKt.listOf(SncfOpenDataClient::api$lambda$1), (boolean)false, (boolean)false, null, (int)116, null).baseUrl("https://api.sncf.com/v1/coverage/sncf/");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"baseUrl(...)");
        ObjectMapper objectMapper = JacksonKt.getMapper().copy();
        SimpleModule simpleModule = JacksonKt.addDeserializer((SimpleModule)new SimpleModule(), (KClass)Reflection.getOrCreateKotlinClass(LocalDateTime.class), (JsonDeserializer)((JsonDeserializer)new LocalDateTimeDeserializer(dateFormat)));
        Intrinsics.checkNotNullExpressionValue((Object)simpleModule, (String)"addDeserializer(...)");
        ObjectMapper objectMapper2 = objectMapper.registerModule((Module)JacksonKt.addSerializer((SimpleModule)simpleModule, (KClass)Reflection.getOrCreateKotlinClass(LocalDateTime.class), (JsonSerializer)((JsonSerializer)new LocalDateTimeSerializer(dateFormat))));
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"registerModule(...)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)objectMapper2).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(SncfOpenDataApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        api = (SncfOpenDataApi)object;
    }
}

