/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.open.data.story;

import ai.tock.bot.engine.BotBus;
import ai.tock.bot.open.data.client.sncf.SncfOpenDataClient;
import ai.tock.bot.open.data.client.sncf.model.StationStop;
import ai.tock.bot.open.data.story.ScoreboardDef;
import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u0016\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\t\u00a8\u0006\u0018"}, d2={"Lai/tock/bot/open/data/story/DeparturesDef;", "Lai/tock/bot/open/data/story/ScoreboardDef;", "bus", "Lai/tock/bot/engine/BotBus;", "<init>", "(Lai/tock/bot/engine/BotBus;)V", "headerMessage", "", "getHeaderMessage", "()Ljava/lang/String;", "noResultMessage", "getNoResultMessage", "nextMessage", "getNextMessage", "retrieveStops", "", "Lai/tock/bot/open/data/client/sncf/model/StationStop;", "timeFor", "Ljava/time/LocalDateTime;", "stop", "itemTitle", "", "itemSubtitleMessage", "getItemSubtitleMessage", "tock-bot-open-data"})
public final class DeparturesDef
extends ScoreboardDef {
    @NotNull
    private final String headerMessage;
    @NotNull
    private final String noResultMessage;
    @NotNull
    private final String nextMessage;
    @NotNull
    private final String itemSubtitleMessage;

    public DeparturesDef(@NotNull BotBus bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        super(bus);
        this.headerMessage = "Departures from: {0}";
        this.noResultMessage = "Oops, no departure currently found, sorry :(";
        this.nextMessage = "Next departures";
        this.itemSubtitleMessage = "Departure {0}";
    }

    @Override
    @NotNull
    public String getHeaderMessage() {
        return this.headerMessage;
    }

    @Override
    @NotNull
    public String getNoResultMessage() {
        return this.noResultMessage;
    }

    @Override
    @NotNull
    public String getNextMessage() {
        return this.nextMessage;
    }

    @Override
    @NotNull
    public List<StationStop> retrieveStops() {
        return SncfOpenDataClient.INSTANCE.departures(this.getO(), this.getCurrentDate());
    }

    @Override
    @NotNull
    public LocalDateTime timeFor(@NotNull StationStop stop) {
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        return stop.getStopDateTime().getDepartureDateTime();
    }

    @Override
    @NotNull
    public CharSequence itemTitle(@NotNull StationStop stop) {
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        Object[] objectArray = new Object[]{stop.getDisplayInformations().getDirection()};
        return (CharSequence)this.i18n("Direction {0}", objectArray);
    }

    @Override
    @NotNull
    public String getItemSubtitleMessage() {
        return this.itemSubtitleMessage;
    }
}

