/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.build;

import ai.tock.nlp.front.client.FrontClient;
import ai.tock.nlp.front.shared.ApplicationConfiguration;
import ai.tock.nlp.front.shared.build.ModelBuildTrigger;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.EntityTypeDefinition;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.StringsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00052\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lai/tock/nlp/build/BuildModelWorker;", "", "<init>", "()V", "ModelRefreshKey", "Companion", "tock-nlp-build-model-worker"})
public final class BuildModelWorker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(BuildModelWorker::logger$lambda$0);
    private static final boolean testModelEnabled = PropertiesKt.booleanProperty((String)"tock_test_model_enabled", (boolean)true);
    private static final boolean cleanupModelEnabled = PropertiesKt.booleanProperty((String)"tock_cleanup_model_enabled", (boolean)true);
    @NotNull
    private static final FrontClient front = FrontClient.INSTANCE;

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0007H\u0002J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0007H\u0002J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0007H\u0002J\u0006\u0010\u001c\u001a\u00020\u0007J\u0006\u0010\u001d\u001a\u00020\u0007J\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u000eJ\u0006\u0010!\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lai/tock/nlp/build/BuildModelWorker$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "testModelEnabled", "", "cleanupModelEnabled", "getCleanupModelEnabled$tock_nlp_build_model_worker", "()Z", "front", "Lai/tock/nlp/front/client/FrontClient;", "updateAllModels", "", "updateApplicationModels", "app", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "onlyIfNotExists", "updateModel", "key", "Lai/tock/nlp/build/BuildModelWorker$ModelRefreshKey;", "sentences", "", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "updateEntityModels", "locale", "Ljava/util/Locale;", "buildModelWithValidatedSentences", "buildModelWithDeletedSentences", "buildModelForTriggeredApplication", "testModels", "completeModel", "cleanupModel", "tock-nlp-build-model-worker"})
    @SourceDebugExtension(value={"SMAP\nBuildModelWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildModelWorker.kt\nai/tock/nlp/build/BuildModelWorker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,210:1\n1863#2,2:211\n1863#2:213\n1863#2,2:214\n1864#2:216\n1485#2:217\n1510#2,3:218\n1513#2,3:228\n774#2:233\n865#2,2:234\n774#2:236\n865#2,2:237\n1863#2:239\n774#2:240\n865#2,2:241\n1864#2:243\n1485#2:244\n1510#2,3:245\n1513#2,3:255\n1557#2:260\n1628#2,3:261\n1863#2,2:264\n1863#2,2:266\n1557#2:268\n1628#2,3:269\n1557#2:272\n1628#2,3:273\n1557#2:276\n1628#2,3:277\n381#3,7:221\n381#3,7:248\n216#4,2:231\n216#4,2:258\n*S KotlinDebug\n*F\n+ 1 BuildModelWorker.kt\nai/tock/nlp/build/BuildModelWorker$Companion\n*L\n48#1:211,2\n53#1:213\n55#1:214,2\n53#1:216\n85#1:217\n85#1:218,3\n85#1:228,3\n115#1:233\n115#1:234,2\n116#1:236\n116#1:237,2\n117#1:239\n118#1:240\n118#1:241,2\n117#1:243\n139#1:244\n139#1:245,3\n139#1:255,3\n156#1:260\n156#1:261,3\n158#1:264,2\n196#1:266,2\n82#1:268\n82#1:269,3\n136#1:272\n136#1:273,3\n153#1:276\n153#1:277,3\n85#1:221,7\n139#1:248,7\n85#1:231,2\n141#1:258,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getCleanupModelEnabled$tock_nlp_build_model_worker() {
            return cleanupModelEnabled;
        }

        public final void updateAllModels() {
            Iterable $this$forEach$iv = FrontClient.INSTANCE.getApplications();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApplicationDefinition it = (ApplicationDefinition)element$iv;
                boolean bl = false;
                ai.tock.nlp.build.BuildModelWorker$Companion.updateApplicationModels$default(Companion, it, false, 2, null);
            }
        }

        private final void updateApplicationModels(ApplicationDefinition app, boolean onlyIfNotExists) {
            logger.info(() -> Companion.updateApplicationModels$lambda$1(app));
            Iterable $this$forEach$iv = app.getSupportedLocales();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Locale locale = (Locale)element$iv;
                boolean bl = false;
                front.updateIntentsModelForApplication(CollectionsKt.emptyList(), app, locale, app.getNlpEngineType(), onlyIfNotExists);
                Iterable $this$forEach$iv2 = app.getIntents();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Id intentId = (Id)element$iv2;
                    boolean bl2 = false;
                    logger.info(() -> Companion.updateApplicationModels$lambda$4$lambda$3$lambda$2(app, intentId, locale));
                    front.updateEntityModelForIntent(CollectionsKt.emptyList(), app, intentId, locale, app.getNlpEngineType(), onlyIfNotExists);
                }
                Companion.updateEntityModels(app, locale, CollectionsKt.emptyList(), onlyIfNotExists);
            }
        }

        static /* synthetic */ void updateApplicationModels$default(Companion companion, ApplicationDefinition applicationDefinition, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.updateApplicationModels(applicationDefinition, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void updateModel(ModelRefreshKey key, List<ClassifiedSentence> sentences, boolean onlyIfNotExists) {
            try {
                void $this$forEach$iv;
                void $this$groupByTo$iv$iv;
                ApplicationDefinition app = front.getApplicationById(key.getApplicationId());
                if (app == null) {
                    logger.warn(() -> Companion.updateModel$lambda$5(key));
                    return;
                }
                logger.info(() -> Companion.updateModel$lambda$6(app, key));
                logger.trace(() -> Companion.updateModel$lambda$8(sentences));
                front.updateIntentsModelForApplication(sentences, app, key.getLanguage(), app.getNlpEngineType(), onlyIfNotExists);
                Object $this$groupBy$iv = sentences;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    ClassifiedSentence it = (ClassifiedSentence)element$iv$iv;
                    boolean bl = false;
                    Id key$iv$iv = it.getClassification().getIntentId();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    Id intentId = (Id)entry.getKey();
                    List intentSentences = (List)entry.getValue();
                    logger.info(() -> Companion.updateModel$lambda$11$lambda$10(app, intentId, key));
                    front.updateEntityModelForIntent(intentSentences, app, intentId, key.getLanguage(), app.getNlpEngineType(), onlyIfNotExists);
                }
                this.updateEntityModels(app, key.getLanguage(), sentences, onlyIfNotExists);
                logger.info(() -> Companion.updateModel$lambda$12(app, key));
            }
            catch (Throwable e) {
                LoggersKt.error((KLogger)logger, (Throwable)e);
            }
            finally {
                logger.info(() -> Companion.updateModel$lambda$13(key));
                front.switchSentencesStatus(sentences, ClassifiedSentenceStatus.model);
            }
        }

        static /* synthetic */ void updateModel$default(Companion companion, ModelRefreshKey modelRefreshKey, List list, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.updateModel(modelRefreshKey, list, bl);
        }

        /*
         * WARNING - void declaration
         */
        private final void updateEntityModels(ApplicationDefinition app, Locale locale, List<ClassifiedSentence> sentences, boolean onlyIfNotExists) {
            void $this$forEach$iv;
            EntityTypeDefinition it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = front.getEntityTypes();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (EntityTypeDefinition)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it.getSubEntities()).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (EntityTypeDefinition)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)StringsKt.namespace((String)it.getName()), (Object)app.getNamespace())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$filterTo$iv$iv2;
                EntityTypeDefinition entityType = (EntityTypeDefinition)element$iv;
                boolean bl = false;
                Iterable $this$filter$iv2 = sentences;
                boolean $i$f$filter2 = false;
                Iterable bl3 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    ClassifiedSentence s = (ClassifiedSentence)element$iv$iv;
                    boolean bl4 = false;
                    if (!s.getClassification().containsEntityOrSubEntity(entityType.getName())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List sentencesWithEntity = (List)destination$iv$iv2;
                if (!(!((Collection)sentencesWithEntity).isEmpty())) continue;
                logger.info(() -> Companion.updateEntityModels$lambda$18$lambda$17(app, entityType, locale));
                front.updateEntityModelForEntityType(sentencesWithEntity, app, entityType, locale, app.getNlpEngineType(), onlyIfNotExists);
            }
        }

        static /* synthetic */ void updateEntityModels$default(Companion companion, ApplicationDefinition applicationDefinition, Locale locale, List list, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.updateEntityModels(applicationDefinition, locale, list, bl);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean buildModelWithValidatedSentences() {
            List validatedSentences = ApplicationConfiguration.DefaultImpls.getSentences$default((ApplicationConfiguration)((ApplicationConfiguration)front), null, null, (ClassifiedSentenceStatus)ClassifiedSentenceStatus.validated, (int)3, null);
            if (!((Collection)validatedSentences).isEmpty()) {
                void $this$groupByTo$iv$iv;
                logger.debug(() -> Companion.buildModelWithValidatedSentences$lambda$20(validatedSentences));
                Iterable $this$groupBy$iv = validatedSentences;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    ClassifiedSentence it = (ClassifiedSentence)element$iv$iv;
                    boolean bl = false;
                    ModelRefreshKey key$iv$iv = new ModelRefreshKey((Id<ApplicationDefinition>)it.getApplicationId(), it.getLanguage());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map refreshKeyMap = destination$iv$iv;
                logger.info(() -> Companion.buildModelWithValidatedSentences$lambda$22(refreshKeyMap));
                Map $this$forEach$iv = refreshKeyMap;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    ai.tock.nlp.build.BuildModelWorker$Companion.updateModel$default(Companion, (ModelRefreshKey)it.getKey(), (List)it.getValue(), false, 4, null);
                }
                logger.info(Companion::buildModelWithValidatedSentences$lambda$24);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean buildModelWithDeletedSentences() {
            List deletedSentences = ApplicationConfiguration.DefaultImpls.getSentences$default((ApplicationConfiguration)((ApplicationConfiguration)front), null, null, (ClassifiedSentenceStatus)ClassifiedSentenceStatus.deleted, (int)3, null);
            if (!((Collection)deletedSentences).isEmpty()) {
                void $this$mapTo$iv$iv;
                logger.debug(() -> Companion.buildModelWithDeletedSentences$lambda$26(deletedSentences));
                Iterable $this$map$iv = deletedSentences;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new ModelRefreshKey((Id<ApplicationDefinition>)it.getApplicationId(), it.getLanguage()));
                }
                List refreshKeyMap = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                logger.info(() -> Companion.buildModelWithDeletedSentences$lambda$28(refreshKeyMap));
                Iterable $this$forEach$iv = refreshKeyMap;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ModelRefreshKey it = (ModelRefreshKey)element$iv;
                    boolean bl = false;
                    ai.tock.nlp.build.BuildModelWorker$Companion.updateModel$default(Companion, it, CollectionsKt.emptyList(), false, 4, null);
                }
                front.deleteSentencesByStatus(ClassifiedSentenceStatus.deleted);
                logger.info(Companion::buildModelWithDeletedSentences$lambda$30);
                return true;
            }
            return false;
        }

        public final boolean buildModelForTriggeredApplication() {
            List triggers = front.getTriggers();
            if (!((Collection)triggers).isEmpty()) {
                ModelBuildTrigger trigger = (ModelBuildTrigger)triggers.get(0);
                boolean bl = false;
                logger.info(() -> Companion.buildModelForTriggeredApplication$lambda$34$lambda$31(trigger));
                front.deleteTrigger(trigger);
                ApplicationDefinition applicationDefinition = front.getApplicationById(trigger.getApplicationId());
                if (applicationDefinition != null) {
                    ApplicationDefinition it = applicationDefinition;
                    boolean bl2 = false;
                    Companion.updateApplicationModels(it, trigger.getOnlyIfModelNotExists());
                } else {
                    logger.warn(() -> Companion.buildModelForTriggeredApplication$lambda$34$lambda$33(trigger));
                }
                return true;
            }
            return false;
        }

        public final boolean testModels() {
            if (testModelEnabled) {
                logger.info(Companion::testModels$lambda$35);
                front.testModels();
                return true;
            }
            return false;
        }

        public final void completeModel() {
            logger.info(Companion::completeModel$lambda$36);
            Iterable $this$forEach$iv = front.getApplications();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApplicationDefinition it = (ApplicationDefinition)element$iv;
                boolean bl = false;
                front.triggerBuild(new ModelBuildTrigger(it.get_id(), true, true));
            }
        }

        public final void cleanupModel() {
            if (this.getCleanupModelEnabled$tock_nlp_build_model_worker()) {
                logger.debug(Companion::cleanupModel$lambda$38);
                front.deleteOrphans();
                logger.debug(Companion::cleanupModel$lambda$39);
            }
        }

        private static final Object updateApplicationModels$lambda$1(ApplicationDefinition $app) {
            Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
            return "Rebuild all models for application " + $app.getName() + " and nlp engine " + $app.getNlpEngineType().getName();
        }

        private static final Object updateApplicationModels$lambda$4$lambda$3$lambda$2(ApplicationDefinition $app, Id $intentId, Locale $locale) {
            Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
            Intrinsics.checkNotNullParameter((Object)$intentId, (String)"$intentId");
            Intrinsics.checkNotNullParameter((Object)$locale, (String)"$locale");
            return "start model update for " + $app.getName() + ", intent " + $intentId + " and " + $locale;
        }

        private static final Object updateModel$lambda$5(ModelRefreshKey $key) {
            Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
            return "Unknown application : " + $key;
        }

        private static final Object updateModel$lambda$6(ApplicationDefinition $app, ModelRefreshKey $key) {
            Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
            return "Start model update for " + $app.getName() + " and " + $key.getLanguage();
        }

        /*
         * WARNING - void declaration
         */
        private static final Object updateModel$lambda$8(List $sentences) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$sentences, (String)"$sentences");
            Iterable $this$map$iv = $sentences;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            return "New sentences : " + (List)destination$iv$iv;
        }

        private static final Object updateModel$lambda$11$lambda$10(ApplicationDefinition $app, Id $intentId, ModelRefreshKey $key) {
            Intrinsics.checkNotNullParameter((Object)$intentId, (String)"$intentId");
            Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
            return "start model update for " + $app.getName() + ", intent " + $intentId + " and " + $key.getLanguage();
        }

        private static final Object updateModel$lambda$12(ApplicationDefinition $app, ModelRefreshKey $key) {
            Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
            return "Model updated for " + $app.getName() + " and " + $key.getLanguage();
        }

        private static final Object updateModel$lambda$13(ModelRefreshKey $key) {
            Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
            return "end model update for " + $key.getLanguage();
        }

        private static final Object updateEntityModels$lambda$18$lambda$17(ApplicationDefinition $app, EntityTypeDefinition $entityType, Locale $locale) {
            Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
            Intrinsics.checkNotNullParameter((Object)$entityType, (String)"$entityType");
            Intrinsics.checkNotNullParameter((Object)$locale, (String)"$locale");
            return "start model update for " + $app.getName() + ", entity type " + $entityType + " and " + $locale;
        }

        /*
         * WARNING - void declaration
         */
        private static final Object buildModelWithValidatedSentences$lambda$20(List $validatedSentences) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$validatedSentences, (String)"$validatedSentences");
            Iterable $this$map$iv = $validatedSentences;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            return "Sentences to update : " + (List)destination$iv$iv;
        }

        private static final Object buildModelWithValidatedSentences$lambda$22(Map $refreshKeyMap) {
            Intrinsics.checkNotNullParameter((Object)$refreshKeyMap, (String)"$refreshKeyMap");
            return "Model refresh keys : " + $refreshKeyMap.keySet();
        }

        private static final Object buildModelWithValidatedSentences$lambda$24() {
            return "end model update";
        }

        /*
         * WARNING - void declaration
         */
        private static final Object buildModelWithDeletedSentences$lambda$26(List $deletedSentences) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$deletedSentences, (String)"$deletedSentences");
            Iterable $this$map$iv = $deletedSentences;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            return "Sentences to remove from model : " + (List)destination$iv$iv;
        }

        private static final Object buildModelWithDeletedSentences$lambda$28(List $refreshKeyMap) {
            Intrinsics.checkNotNullParameter((Object)$refreshKeyMap, (String)"$refreshKeyMap");
            return "Model refresh keys : " + $refreshKeyMap;
        }

        private static final Object buildModelWithDeletedSentences$lambda$30() {
            return "end model update";
        }

        private static final Object buildModelForTriggeredApplication$lambda$34$lambda$31(ModelBuildTrigger $trigger) {
            Intrinsics.checkNotNullParameter((Object)$trigger, (String)"$trigger");
            return "use trigger " + $trigger;
        }

        private static final Object buildModelForTriggeredApplication$lambda$34$lambda$33(ModelBuildTrigger $trigger) {
            Intrinsics.checkNotNullParameter((Object)$trigger, (String)"$trigger");
            return "unknown application id trigger " + $trigger + " - skipped";
        }

        private static final Object testModels$lambda$35() {
            return "Start testing models";
        }

        private static final Object completeModel$lambda$36() {
            return "trigger build to check not existing models";
        }

        private static final Object cleanupModel$lambda$38() {
            return "remove orphan models...";
        }

        private static final Object cleanupModel$lambda$39() {
            return "end remove orphan models";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lai/tock/nlp/build/BuildModelWorker$ModelRefreshKey;", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "<init>", "(Lorg/litote/kmongo/Id;Ljava/util/Locale;)V", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getLanguage", "()Ljava/util/Locale;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-build-model-worker"})
    public static final class ModelRefreshKey {
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Locale language;

        public ModelRefreshKey(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language) {
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.applicationId = applicationId;
            this.language = language;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final Id<ApplicationDefinition> component1() {
            return this.applicationId;
        }

        @NotNull
        public final Locale component2() {
            return this.language;
        }

        @NotNull
        public final ModelRefreshKey copy(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language) {
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new ModelRefreshKey(applicationId, language);
        }

        public static /* synthetic */ ModelRefreshKey copy$default(ModelRefreshKey modelRefreshKey, Id id, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                id = modelRefreshKey.applicationId;
            }
            if ((n & 2) != 0) {
                locale = modelRefreshKey.language;
            }
            return modelRefreshKey.copy(id, locale);
        }

        @NotNull
        public String toString() {
            return "ModelRefreshKey(applicationId=" + this.applicationId + ", language=" + this.language + ")";
        }

        public int hashCode() {
            int result = this.applicationId.hashCode();
            result = result * 31 + this.language.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelRefreshKey)) {
                return false;
            }
            ModelRefreshKey modelRefreshKey = (ModelRefreshKey)other;
            if (!Intrinsics.areEqual(this.applicationId, modelRefreshKey.applicationId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)modelRefreshKey.language);
        }
    }
}

