/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.duckling.client;

import ai.tock.duckling.client.DatesMerge;
import ai.tock.duckling.client.DucklingClient;
import ai.tock.duckling.client.DucklingDimensions;
import ai.tock.duckling.client.DucklingParser;
import ai.tock.duckling.client.JSONValue;
import ai.tock.duckling.client.Parser;
import ai.tock.duckling.client.ValueWithRange;
import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.merge.ValueDescriptor;
import ai.tock.nlp.core.service.entity.EntityTypeClassifier;
import ai.tock.nlp.core.service.entity.EntityTypeEvaluator;
import ai.tock.nlp.core.service.entity.EntityTypeRecognition;
import ai.tock.nlp.core.service.entity.EntityTypeValue;
import ai.tock.nlp.core.service.entity.EvaluationResult;
import ai.tock.nlp.entity.DurationValue;
import ai.tock.nlp.entity.Value;
import ai.tock.nlp.entity.date.DateEntityGrain;
import ai.tock.nlp.entity.date.DateEntityValue;
import ai.tock.nlp.entity.date.DateIntervalEntityValue;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JH\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000f\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\rH\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&H\u0002J.\u0010)\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0012H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010,\u001a\u00020-H\u0002J2\u00100\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u00020\u00122\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020403H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lai/tock/duckling/client/DucklingParser;", "Lai/tock/nlp/core/service/entity/EntityTypeEvaluator;", "Lai/tock/nlp/core/service/entity/EntityTypeClassifier;", "Lai/tock/duckling/client/Parser;", "()V", "ducklingAveragePertinence", "", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "logger", "Lmu/KLogger;", "classify", "", "Lai/tock/nlp/core/service/entity/EntityTypeRecognition;", "context", "Lai/tock/nlp/model/EntityCallContext;", "text", "", "entityTypeMap", "", "Lai/tock/nlp/core/EntityType;", "language", "dimensions", "", "referenceDate", "Ljava/time/ZonedDateTime;", "textToParse", "classifyEntities", "classifyForIntent", "Lai/tock/nlp/model/EntityCallContextForIntent;", "evaluate", "Lai/tock/nlp/core/service/entity/EvaluationResult;", "Lai/tock/nlp/model/EntityCallContextForEntity;", "merge", "Lai/tock/nlp/core/merge/ValueDescriptor;", "values", "mergeDate", "Lai/tock/duckling/client/ValueWithRange;", "r1", "r2", "parse", "dimension", "parseDate", "parseResult", "Lai/tock/duckling/client/JSONValue;", "parseDimension", "parseDuration", "parseSimple", "dim", "parseFunction", "Lkotlin/Function1;", "Lai/tock/nlp/entity/Value;", "tock-nlp-duckling-client"})
@SourceDebugExtension(value={"SMAP\nDucklingParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DucklingParser.kt\nai/tock/duckling/client/DucklingParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n766#2:374\n857#2,2:375\n1477#2:377\n1502#2,3:378\n1505#2,3:388\n1238#2,4:397\n1360#2:401\n1446#2,5:402\n1549#2:407\n1620#2,3:408\n1603#2,9:411\n1855#2:420\n1856#2:422\n1612#2:423\n2661#2,7:425\n1603#2,9:432\n1855#2:441\n1856#2:443\n1612#2:444\n372#3,7:381\n453#3:395\n403#3:396\n125#4:391\n152#4,3:392\n1#5:421\n1#5:424\n1#5:442\n*S KotlinDebug\n*F\n+ 1 DucklingParser.kt\nai/tock/duckling/client/DucklingParser\n*L\n77#1:374\n77#1:375,2\n82#1:377\n82#1:378,3\n82#1:388,3\n87#1:397,4\n113#1:401\n113#1:402,5\n114#1:407\n114#1:408,3\n197#1:411,9\n197#1:420\n197#1:422\n197#1:423\n212#1:425,7\n224#1:432,9\n224#1:441\n224#1:443\n224#1:444\n82#1:381,7\n87#1:395\n87#1:396\n83#1:391\n83#1:392,3\n197#1:421\n224#1:442\n*E\n"})
public final class DucklingParser
implements EntityTypeEvaluator,
EntityTypeClassifier,
Parser {
    @NotNull
    public static final DucklingParser INSTANCE = new DucklingParser();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static final double ducklingAveragePertinence = 0.8;

    private DucklingParser() {
    }

    @NotNull
    public List<EntityTypeRecognition> classifyEntities(@NotNull EntityCallContext context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.classify(context, text);
    }

    private final List<EntityTypeRecognition> classify(EntityCallContext context, String text) {
        List list;
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classifyForIntent((EntityCallContextForIntent)context, text);
        } else if (entityCallContext instanceof EntityCallContextForEntity) {
            list = CollectionsKt.emptyList();
        } else if (entityCallContext instanceof EntityCallContextForSubEntities) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityTypeRecognition> classifyForIntent(EntityCallContextForIntent context, String text) {
        List<EntityTypeRecognition> list;
        boolean bl;
        Entity it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = context.getIntent().getEntities();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (Entity)t;
            bl = false;
            if (!DucklingDimensions.INSTANCE.getEntityTypes().contains(it.getEntityType().getName())) continue;
            destination$iv$iv.add(t);
        }
        List matchedEntities = (List)destination$iv$iv;
        if (matchedEntities.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapValues$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            Object answer$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            $this$filter$iv = matchedEntities;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                Object object;
                it = (Entity)t;
                bl = false;
                String key$iv$iv = DucklingDimensions.INSTANCE.tockTypeToDucklingType(it.getEntityType());
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(t);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                list$iv$iv = entry;
                Object object = destination$iv$iv;
                bl = false;
                object.add(TuplesKt.to(it.getKey(), (Object)CollectionsKt.first((List)((List)it.getValue()))));
            }
            Map it2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            boolean bl2 = false;
            destination$iv$iv = it2;
            DucklingParser ducklingParser = INSTANCE;
            boolean $i$f$mapValues = false;
            void var10_18 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = var10_18.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it3;
                void it$iv$iv;
                answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl3 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl4 = false;
                EntityType entityType = ((Entity)it3.getValue()).getEntityType();
                map2.put(k, entityType);
            }
            String string = context.getLanguage().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
            list = ducklingParser.classify(destination$iv$iv2, string, it2.keySet(), context.getReferenceDate(), text);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityTypeRecognition> classify(Map<String, EntityType> entityTypeMap, String language, Set<String> dimensions, ZonedDateTime referenceDate, String textToParse) {
        List list;
        List list2 = CollectionsKt.toList((Iterable)dimensions);
        ZoneId zoneId = referenceDate.getZone();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"getZone(...)");
        JSONValue parseResult = DucklingClient.INSTANCE.parse(language, list2, referenceDate, zoneId, textToParse);
        if (parseResult == null) {
            logger.warn((Function0)new Function0<Object>(language, dimensions, textToParse){
                final /* synthetic */ String $language;
                final /* synthetic */ Set<String> $dimensions;
                final /* synthetic */ String $textToParse;
                {
                    this.$language = $language;
                    this.$dimensions = $dimensions;
                    this.$textToParse = $textToParse;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "parsing error for " + this.$language + " " + this.$dimensions + " " + this.$textToParse;
                }
            });
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            String it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Iterable iterable = dimensions;
            boolean $i$f$flatMap = false;
            void var9_9 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                list$iv$iv = INSTANCE.parseDimension(parseResult, it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (ValueWithRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EntityTypeRecognition(new EntityTypeValue(((ValueWithRange)((Object)it)).getStart(), ((ValueWithRange)((Object)it)).getEnd(), (EntityType)MapsKt.getValue(entityTypeMap, (Object)((ValueWithRange)((Object)it)).getType()), (Object)((ValueWithRange)((Object)it)).getValue(), true), 0.8));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public EvaluationResult evaluate(@NotNull EntityCallContextForEntity context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = context.getLanguage().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        List<ValueWithRange> values = this.parse(string, DucklingDimensions.INSTANCE.tockTypeToDucklingType(context.getEntityType()), context.getReferenceDate(), text);
        ValueWithRange v = (ValueWithRange)CollectionsKt.firstOrNull(values);
        return v == null ? new EvaluationResult(false, null, 0.0, 6, null) : new EvaluationResult(true, (Object)v.getValue(), v.getStart() == 0 && v.getEnd() == text.length() ? 1.0 : 0.5);
    }

    @Override
    @NotNull
    public List<ValueWithRange> parse(@NotNull String language, @NotNull String dimension, @NotNull ZonedDateTime referenceDate, @NotNull String textToParse) {
        List list;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
        Intrinsics.checkNotNullParameter((Object)textToParse, (String)"textToParse");
        List list2 = CollectionsKt.listOf((Object)dimension);
        ZoneId zoneId = referenceDate.getZone();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"getZone(...)");
        JSONValue parseResult = DucklingClient.INSTANCE.parse(language, list2, referenceDate, zoneId, textToParse);
        if (parseResult == null) {
            logger.warn((Function0)new Function0<Object>(language, dimension, textToParse){
                final /* synthetic */ String $language;
                final /* synthetic */ String $dimension;
                final /* synthetic */ String $textToParse;
                {
                    this.$language = $language;
                    this.$dimension = $dimension;
                    this.$textToParse = $textToParse;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "parse error for " + this.$language + " " + this.$dimension + " " + this.$textToParse;
                }
            });
            list = CollectionsKt.emptyList();
        } else {
            list = this.parseDimension(parseResult, dimension);
        }
        return list;
    }

    private final List<ValueWithRange> parseDimension(JSONValue parseResult, String dimension) {
        List<ValueWithRange> list;
        switch (dimension) {
            case "time": {
                list = this.parseDate(parseResult);
                break;
            }
            case "number": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.1.INSTANCE));
                break;
            }
            case "ordinal": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.2.INSTANCE));
                break;
            }
            case "distance": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.3.INSTANCE));
                break;
            }
            case "temperature": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.4.INSTANCE));
                break;
            }
            case "volume": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.5.INSTANCE));
                break;
            }
            case "amount-of-money": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.6.INSTANCE));
                break;
            }
            case "url": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.7.INSTANCE));
                break;
            }
            case "email": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.8.INSTANCE));
                break;
            }
            case "phone-number": {
                list = this.parseSimple(parseResult, dimension, (Function1<? super JSONValue, ? extends Value>)((Function1)parseDimension.9.INSTANCE));
                break;
            }
            case "duration": {
                list = this.parseDuration(parseResult);
                break;
            }
            default: {
                throw new IllegalStateException(("Not yet supported yet : " + dimension).toString());
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<ValueWithRange> parseDuration(JSONValue parseResult) {
        List list;
        List list2;
        void $this$mapNotNullTo$iv$iv;
        int start = 0;
        start = Integer.MAX_VALUE;
        int end = 0;
        end = Integer.MIN_VALUE;
        Iterable<JSONValue> $this$mapNotNull$iv = parseResult.iterable();
        boolean bl = false;
        Iterable<JSONValue> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl2 = false;
        Duration $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Duration duration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            JSONValue it = (JSONValue)element$iv$iv;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)it.get(":dim").string(), (Object)"duration")) {
                JSONValue n = it.get(":value").get(":normalized");
                long v = n.get(":value").number().longValue();
                if (!Intrinsics.areEqual((Object)n.get(":unit").string(), (Object)"second")) throw new IllegalStateException(("unknown unit: " + n.get(":unit")).toString());
                ChronoUnit u = ChronoUnit.SECONDS;
                start = Math.min(start, it.get(":start").int());
                end = Math.max(end, it.get(":end").int());
                duration = Duration.of(v, u);
            } else {
                duration = null;
            }
            if (duration == null) continue;
            Duration it$iv$iv = duration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        List list3 = object;
        boolean bl6 = false;
        List list4 = list2 = !list3.isEmpty() ? object : null;
        if (list2 != null) {
            void var9_14;
            Iterable iterable2 = list2;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = iterable2.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object t = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                $this$forEach$iv$iv$iv = (Duration)iterator$iv.next();
                Duration a = (Duration)var9_14;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)a.plus((Duration)b), (String)"plus(...)");
            }
            object = (Duration)var9_14;
            if (object != null) {
                Object it = object;
                boolean bl8 = false;
                List list5 = CollectionsKt.listOf((Object)new ValueWithRange(start, end, (Value)new DurationValue((Duration)it), "duration"));
                if (list5 != null) {
                    list = list5;
                    return list;
                }
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueWithRange> parseSimple(JSONValue parseResult, String dim, Function1<? super JSONValue, ? extends Value> parseFunction) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<JSONValue> $this$mapNotNull$iv = parseResult.iterable();
        boolean $i$f$mapNotNull = false;
        Iterable<JSONValue> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValueWithRange valueWithRange;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JSONValue it = (JSONValue)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.get(":dim").string(), (Object)dim)) {
                Value value = (Value)parseFunction.invoke((Object)it.get(":value"));
                int start = it.get(":start").int();
                int end = it.get(":end").int();
                valueWithRange = new ValueWithRange(start, end, value, dim);
            } else {
                valueWithRange = null;
            }
            if (valueWithRange == null) continue;
            ValueWithRange it$iv$iv = valueWithRange;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ValueWithRange> parseDate(JSONValue parseResult) {
        List result = new ArrayList();
        try {
            if (!parseResult.isEmpty()) {
                for (JSONValue a : parseResult.iterable()) {
                    JSONValue toGrain;
                    if (!Intrinsics.areEqual((Object)a.get(":dim").string(), (Object)"time")) continue;
                    int start = a.get(":start").int();
                    int end = a.get(":end").int();
                    JSONValue valueMap = a.get(":value");
                    JSONValue grain = valueMap.get(":grain");
                    if (grain.isNotNull()) {
                        ZonedDateTime zonedDateTime = ZonedDateTime.parse(valueMap.get(":value").string(), formatter);
                        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(...)");
                        result.add(new ValueWithRange(start, end, (Value)new DateEntityValue(zonedDateTime, DateEntityGrain.valueOf((String)grain.string())), "time"));
                        continue;
                    }
                    JSONValue fromMap = valueMap.get(":from");
                    JSONValue toMap = valueMap.get(":to");
                    ValueWithRange entityValue = null;
                    if (toMap.isNotNull() && fromMap.isNotNull() && (toGrain = toMap.get(":grain")).isNotNull()) {
                        ZonedDateTime zonedDateTime = ZonedDateTime.parse(fromMap.get(":value").string(), formatter);
                        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(...)");
                        DateEntityValue dateEntityValue = new DateEntityValue(zonedDateTime, DateEntityGrain.valueOf((String)fromMap.get(":grain").string()));
                        ZonedDateTime zonedDateTime2 = ZonedDateTime.parse(toMap.get(":value").string(), formatter);
                        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"parse(...)");
                        entityValue = new ValueWithRange(start, end, (Value)new DateIntervalEntityValue(dateEntityValue, new DateEntityValue(zonedDateTime2, DateEntityGrain.valueOf((String)toMap.get(":grain").string()))), "time");
                    }
                    if (entityValue == null) {
                        JSONValue vMap;
                        JSONValue jSONValue = vMap = fromMap.isNotNull() ? fromMap : toMap;
                        if (vMap.isNotNull()) {
                            ZonedDateTime zonedDateTime = ZonedDateTime.parse(vMap.get(":value").string(), formatter);
                            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(...)");
                            entityValue = new ValueWithRange(start, end, (Value)new DateEntityValue(zonedDateTime, DateEntityGrain.valueOf((String)vMap.get(":grain").string())), "time");
                        }
                    }
                    if (entityValue == null) continue;
                    result.add(entityValue);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Function0)new Function0<Object>(e){
                final /* synthetic */ Exception $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$e.getMessage();
                }
            });
        }
        CollectionsKt.sort((List)result);
        if (result.size() > 1) {
            boolean skipNext = false;
            List result2 = new ArrayList();
            int n = result.size();
            for (int i = 0; i < n; ++i) {
                if (!skipNext) {
                    if (i < result.size() - 1) {
                        if (((ValueWithRange)result.get(i)).getEnd() > ((ValueWithRange)result.get(i + 1)).getStart()) {
                            result2.add(this.mergeDate((ValueWithRange)result.get(i), (ValueWithRange)result.get(i + 1)));
                            skipNext = true;
                            continue;
                        }
                        result2.add(result.get(i));
                        continue;
                    }
                    result2.add(result.get(i));
                    continue;
                }
                skipNext = false;
            }
            result = result2;
        }
        return result;
    }

    private final ValueWithRange mergeDate(ValueWithRange r1, ValueWithRange r2) {
        if (r1.getValue() instanceof DateEntityValue && r2.getValue() instanceof DateEntityValue) {
            if (((DateEntityValue)r1.getValue()).getGrain() == ((DateEntityValue)r2.getValue()).getGrain()) {
                return new ValueWithRange(r1.getStart(), r2.getEnd(), (Value)new DateIntervalEntityValue((DateEntityValue)r1.getValue(), (DateEntityValue)r2.getValue()), "time");
            }
            DateEntityValue dateGrain = ((DateEntityValue)r1.getValue()).getGrain().getTime() ? (DateEntityValue)r2.getValue() : (DateEntityValue)r1.getValue();
            DateEntityValue timeGrain = ((DateEntityValue)r1.getValue()).getGrain().getTime() ? (DateEntityValue)r2.getValue() : (DateEntityValue)r1.getValue();
            int n = r1.getStart();
            int n2 = r2.getEnd();
            ZonedDateTime zonedDateTime = dateGrain.getDate().plus(Duration.ofSeconds(timeGrain.getDate().toLocalTime().toSecondOfDay()));
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"plus(...)");
            return new ValueWithRange(n, n2, (Value)new DateEntityValue(zonedDateTime, timeGrain.getGrain()), "time");
        }
        return r1;
    }

    @Nullable
    public ValueDescriptor merge(@NotNull EntityCallContextForEntity context, @NotNull List<ValueDescriptor> values) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return DatesMerge.INSTANCE.merge(context, values);
    }
}

