/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.service;

import ai.tock.nlp.core.NlpCore;
import ai.tock.nlp.front.service.ApplicationCodecService;
import ai.tock.nlp.front.service.ConfigurationRepository;
import ai.tock.nlp.front.service.ModelUpdaterService;
import ai.tock.nlp.front.shared.ApplicationCodec;
import ai.tock.nlp.front.shared.ApplicationConfiguration;
import ai.tock.nlp.front.shared.build.ModelBuildTrigger;
import ai.tock.nlp.front.shared.codec.ApplicationDump;
import ai.tock.nlp.front.shared.codec.ApplicationImportConfiguration;
import ai.tock.nlp.front.shared.codec.DumpType;
import ai.tock.nlp.front.shared.codec.ImportReport;
import ai.tock.nlp.front.shared.codec.SentenceDump;
import ai.tock.nlp.front.shared.codec.SentenceEntityDump;
import ai.tock.nlp.front.shared.codec.SentencesDump;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.Classification;
import ai.tock.nlp.front.shared.config.ClassifiedEntity;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.EntityDefinition;
import ai.tock.nlp.front.shared.config.EntityTypeDefinition;
import ai.tock.nlp.front.shared.config.FaqDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.config.SentencesQuery;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.security.TockObfuscatorService;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00152\u0006\u0010#\u001a\u00020$H\u0016J2\u0010%\u001a\u00020&2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010\u00052\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J \u0010,\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010-\u001a\u00020&H\u0016J\u0010\u00101\u001a\u00020/2\u0006\u0010-\u001a\u00020\u001fH\u0016J \u0010\u0019\u001a\u000202*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0014\u00103\u001a\u00020\u0005*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0014\u00103\u001a\u00020\u0005*\u0002042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0014\u00103\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J*\u00105\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0014\u00105\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lai/tock/nlp/front/service/ApplicationCodecService;", "Lai/tock/nlp/front/shared/ApplicationCodec;", "()V", "builtInNamespaces", "", "", "getBuiltInNamespaces", "()Ljava/util/Set;", "builtInNamespaces$delegate", "Lkotlin/Lazy;", "config", "Lai/tock/nlp/front/shared/ApplicationConfiguration;", "getConfig", "()Lai/tock/nlp/front/shared/ApplicationConfiguration;", "core", "Lai/tock/nlp/core/NlpCore;", "getCore", "()Lai/tock/nlp/core/NlpCore;", "logger", "Lmu/KLogger;", "changeEntityNames", "", "Lai/tock/nlp/front/shared/config/ClassifiedEntity;", "entities", "namespace", "createEntityTypeIfNotExist", "", "report", "Lai/tock/nlp/front/shared/codec/ImportReport;", "Lai/tock/nlp/front/shared/config/EntityDefinition;", "export", "Lai/tock/nlp/front/shared/codec/ApplicationDump;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "dumpType", "Lai/tock/nlp/front/shared/codec/DumpType;", "exportSentences", "Lai/tock/nlp/front/shared/codec/SentencesDump;", "queries", "Lai/tock/nlp/front/shared/config/SentencesQuery;", "intent", "locale", "Ljava/util/Locale;", "import", "dump", "configuration", "Lai/tock/nlp/front/shared/codec/ApplicationImportConfiguration;", "importSentences", "prepareImport", "", "newName", "Lai/tock/nlp/front/shared/config/EntityTypeDefinition;", "withNewName", "tock-nlp-front-service"})
public final class ApplicationCodecService
implements ApplicationCodec {
    @NotNull
    public static final ApplicationCodecService INSTANCE = new ApplicationCodecService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final Lazy builtInNamespaces$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)builtInNamespaces.2.INSTANCE);

    private ApplicationCodecService() {
    }

    @NotNull
    public final ApplicationConfiguration getConfig() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (ApplicationConfiguration)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<ApplicationConfiguration>(){}, tag$iv).getValue()).invoke();
    }

    private final NlpCore getCore() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (NlpCore)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<NlpCore>(){}, tag$iv).getValue()).invoke();
    }

    private final Set<String> getBuiltInNamespaces() {
        Lazy lazy = builtInNamespaces$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApplicationDump export(@NotNull Id<ApplicationDefinition> applicationId, @NotNull DumpType dumpType) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)dumpType, (String)"dumpType");
        ApplicationDefinition applicationDefinition = this.getConfig().getApplicationById(applicationId);
        Intrinsics.checkNotNull((Object)applicationDefinition);
        ApplicationDefinition app2 = applicationDefinition;
        List entities2 = this.getConfig().getEntityTypesByNamespaceAndSharedEntityTypes(app2.getNamespace());
        List intents = this.getConfig().getIntentsByApplicationId(applicationId);
        Iterable iterable = intents;
        ApplicationConfiguration applicationConfiguration = this.getConfig();
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntentDefinition intentDefinition = (IntentDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.get_id());
        }
        Iterable $this$sortedBy$iv = ApplicationConfiguration.DefaultImpls.getSentences$default((ApplicationConfiguration)applicationConfiguration, (Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), null, null, (int)6, null);
        boolean $i$f$sortedBy = false;
        List sentences = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ClassifiedSentence it = (ClassifiedSentence)a;
                boolean bl = false;
                Comparable comparable = it.getUpdateDate();
                it = (ClassifiedSentence)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getUpdateDate());
            }
        });
        List faqs = this.getConfig().getFaqsDefinitionByApplicationId(applicationId);
        return new ApplicationDump(app2, entities2, intents, sentences, faqs, null, null, 96, null);
    }

    @NotNull
    public ApplicationImportConfiguration prepareImport(@NotNull ApplicationDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return new ApplicationImportConfiguration(dump.getApplication().getName(), false, 2, null);
    }

    private final String newName(EntityTypeDefinition $this$newName, String namespace) {
        return this.newName($this$newName.getName(), namespace);
    }

    private final String newName(EntityDefinition $this$newName, String namespace) {
        return this.newName($this$newName.getEntityTypeName(), namespace);
    }

    private final String newName(String $this$newName, String namespace) {
        String n = ai.tock.shared.StringsKt.namespace((String)$this$newName);
        return Intrinsics.areEqual((Object)n, (Object)namespace) || this.getBuiltInNamespaces().contains(n) ? $this$newName : namespace + ":" + ai.tock.shared.StringsKt.name((String)$this$newName);
    }

    private final EntityDefinition withNewName(EntityDefinition $this$withNewName, String namespace) {
        return EntityDefinition.copy$default((EntityDefinition)$this$withNewName, (String)this.newName($this$withNewName, namespace), null, null, (int)6, null);
    }

    private final Set<EntityDefinition> changeEntityNames(Set<EntityDefinition> entities2, String namespace) {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)entities2), (Function1)((Function1)new Function1<EntityDefinition, EntityDefinition>(namespace){
            final /* synthetic */ String $namespace;
            {
                this.$namespace = $namespace;
                super(1);
            }

            @NotNull
            public final EntityDefinition invoke(@NotNull EntityDefinition it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ApplicationCodecService.access$withNewName(ApplicationCodecService.INSTANCE, it, this.$namespace);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final void createEntityTypeIfNotExist(ClassifiedEntity $this$createEntityTypeIfNotExist, String namespace, ImportReport report2) {
        EntityTypeDefinition entityTypeDefinition;
        String newName = this.newName($this$createEntityTypeIfNotExist.getType(), namespace);
        if (!ConfigurationRepository.INSTANCE.entityTypeExists(newName)) {
            EntityTypeDefinition newEntity = new EntityTypeDefinition(newName, "", null, false, false, null, 60, null);
            this.getConfig().save(newEntity);
            ImportReport importReport = report2;
            if (importReport != null) {
                importReport.add(newEntity);
            }
            entityTypeDefinition = newEntity;
        } else {
            EntityTypeDefinition entityTypeDefinition2 = this.getConfig().getEntityTypeByName(newName);
            entityTypeDefinition = entityTypeDefinition2;
            Intrinsics.checkNotNull((Object)entityTypeDefinition2);
        }
        EntityTypeDefinition entityTypeDef = entityTypeDefinition;
        if (!((Collection)$this$createEntityTypeIfNotExist.getSubEntities()).isEmpty()) {
            void $this$distinctBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = $this$createEntityTypeIfNotExist.getSubEntities();
            Collection collection = entityTypeDef.getSubEntities();
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ClassifiedEntity classifiedEntity = (ClassifiedEntity)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                ClassifiedEntity e = INSTANCE.withNewName((ClassifiedEntity)it, namespace, true, report2);
                boolean bl2 = false;
                collection2.add(new EntityDefinition(e.getType(), e.getRole(), null, 4, null));
            }
            $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                EntityDefinition it = (EntityDefinition)e$iv;
                boolean bl = false;
                String key$iv = it.getRole();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List newEntities = list$iv;
            if (newEntities.size() != entityTypeDef.getSubEntities().size()) {
                this.getConfig().save(EntityTypeDefinition.copy$default((EntityTypeDefinition)entityTypeDef, null, null, (List)newEntities, (boolean)false, (boolean)false, null, (int)59, null));
            }
        }
    }

    static /* synthetic */ void createEntityTypeIfNotExist$default(ApplicationCodecService applicationCodecService, ClassifiedEntity classifiedEntity, String string, ImportReport importReport, int n, Object object) {
        if ((n & 2) != 0) {
            importReport = null;
        }
        applicationCodecService.createEntityTypeIfNotExist(classifiedEntity, string, importReport);
    }

    private final ClassifiedEntity withNewName(ClassifiedEntity $this$withNewName, String namespace, boolean createEntityTypeIfNotExist, ImportReport report2) {
        if (createEntityTypeIfNotExist) {
            this.createEntityTypeIfNotExist($this$withNewName, namespace, report2);
        }
        return ClassifiedEntity.copy$default((ClassifiedEntity)$this$withNewName, (String)this.newName($this$withNewName.getType(), namespace), null, (int)0, (int)0, (List)ApplicationCodecService.changeEntityNames$default(this, $this$withNewName.getSubEntities(), namespace, false, null, 12, null), (int)14, null);
    }

    static /* synthetic */ ClassifiedEntity withNewName$default(ApplicationCodecService applicationCodecService, ClassifiedEntity classifiedEntity, String string, boolean bl, ImportReport importReport, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            importReport = null;
        }
        return applicationCodecService.withNewName(classifiedEntity, string, bl, importReport);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassifiedEntity> changeEntityNames(List<ClassifiedEntity> entities2, String namespace, boolean createEntityTypeIfNotExist, ImportReport report2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassifiedEntity classifiedEntity = (ClassifiedEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.withNewName((ClassifiedEntity)it, namespace, createEntityTypeIfNotExist, report2));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List changeEntityNames$default(ApplicationCodecService applicationCodecService, List list, String string, boolean bl, ImportReport importReport, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            importReport = null;
        }
        return applicationCodecService.changeEntityNames(list, string, bl, importReport);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ImportReport import(@NotNull String namespace, @NotNull ApplicationDump dump, @NotNull ApplicationImportConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        logger.info((Function0)import.1.INSTANCE);
        ImportReport report2 = new ImportReport(null, null, null, 0L, 0L, false, false, null, 255, null);
        try {
            Map map;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Collection collection;
            Map $this$mapTo$iv$iv;
            ApplicationDefinition applicationDefinition;
            String string;
            Object e$iv2;
            Id $this$distinctBy$iv;
            Object list$iv;
            Object set$iv;
            EntityTypeDefinition entityTypeDefinition;
            Iterator iterator;
            Object $this$import_u24lambda_u2410_u24lambda_u249;
            EntityTypeDefinition e;
            Iterable $this$forEach$iv = dump.getEntityTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                e = (EntityTypeDefinition)element$iv;
                boolean bl = false;
                if (ConfigurationRepository.INSTANCE.entityTypeExists(INSTANCE.newName(e, namespace))) continue;
                Id id = IdsKt.newId();
                EntityTypeDefinition newEntity = EntityTypeDefinition.copy$default((EntityTypeDefinition)e, (String)INSTANCE.newName(e, namespace), null, null, (boolean)false, (boolean)false, (Id)id, (int)30, null);
                INSTANCE.getConfig().save(newEntity);
                report2.add(newEntity);
                logger.debug((Function0)new Function0<Object>(newEntity){
                    final /* synthetic */ EntityTypeDefinition $newEntity;
                    {
                        this.$newEntity = $newEntity;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Import entity type " + this.$newEntity;
                    }
                });
            }
            $this$forEach$iv = dump.getEntityTypes();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Unit unit;
                e = (EntityTypeDefinition)element$iv;
                boolean bl5 = false;
                if (!(!((Collection)e.getSubEntities()).isEmpty())) continue;
                if (INSTANCE.getConfig().getEntityTypeByName(INSTANCE.newName(e, namespace)) != null) {
                    Collection<EntityDefinition> collection2;
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv;
                    boolean bl2 = false;
                    Iterable iterable = e.getSubEntities();
                    Collection collection3 = $this$import_u24lambda_u2410_u24lambda_u249.getSubEntities();
                    iterator = null;
                    String string2 = null;
                    entityTypeDefinition = $this$import_u24lambda_u2410_u24lambda_u249;
                    ApplicationConfiguration applicationConfiguration = INSTANCE.getConfig();
                    boolean $i$f$map = false;
                    void var20_62 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        EntityDefinition entityDefinition = (EntityDefinition)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl3 = false;
                        collection2.add(new EntityDefinition(INSTANCE.newName((EntityDefinition)it, namespace), it.getRole(), null, 4, null));
                    }
                    collection2 = (List)destination$iv$iv;
                    $this$map$iv = CollectionsKt.plus((Collection)collection3, (Iterable)collection2);
                    boolean $i$f$distinctBy = false;
                    set$iv = new HashSet();
                    list$iv = new ArrayList();
                    for (Object e$iv2 : $this$distinctBy$iv) {
                        EntityDefinition it = (EntityDefinition)e$iv2;
                        boolean bl4 = false;
                        String key$iv = it.getRole();
                        if (!((HashSet)set$iv).add(key$iv)) continue;
                        ((ArrayList)list$iv).add(e$iv2);
                    }
                    collection3 = (List)list$iv;
                    applicationConfiguration.save(EntityTypeDefinition.copy$default((EntityTypeDefinition)entityTypeDefinition, string2, iterator, (List)collection3, (boolean)false, (boolean)false, null, (int)59, null));
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            CharSequence $i$f$forEach2 = configuration.getNewApplicationName();
            if ($i$f$forEach2 == null || StringsKt.isBlank((CharSequence)$i$f$forEach2)) {
                string = dump.getApplication().getName();
            } else {
                String string3 = configuration.getNewApplicationName();
                Intrinsics.checkNotNull((Object)string3);
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            }
            String appName = string;
            ApplicationDefinition app2 = this.getConfig().getApplicationByNamespaceAndName(namespace, appName);
            boolean bl = false;
            if (app2 == null) {
                ApplicationDefinition bl5 = dump.getApplication();
                $this$import_u24lambda_u2410_u24lambda_u249 = SetsKt.emptySet();
                Map bl2 = MapsKt.emptyMap();
                $this$distinctBy$iv = IdsKt.newId();
                ApplicationDefinition appToSave = ApplicationDefinition.copy$default((ApplicationDefinition)bl5, (String)appName, null, (String)namespace, (Set)$this$import_u24lambda_u2410_u24lambda_u249, null, (Map)bl2, null, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (boolean)false, (Id)$this$distinctBy$iv, (int)4050, null);
                report2.add(appToSave);
                logger.debug((Function0)new Function0<Object>(appToSave){
                    final /* synthetic */ ApplicationDefinition $appToSave;
                    {
                        this.$appToSave = $appToSave;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Import application " + this.$appToSave;
                    }
                });
                applicationDefinition = INSTANCE.getConfig().save(appToSave);
            } else {
                applicationDefinition = configuration.getDefaultModelMayExist() && app2.getSupportedLocales().size() == 1 && app2.getSupportedLocales().contains(LocalesKt.getDefaultLocale()) && app2.getIntents().isEmpty() ? ApplicationDefinition.copy$default((ApplicationDefinition)app2, null, null, null, null, (Set)SetsKt.emptySet(), null, null, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (boolean)false, null, (int)8175, null) : app2;
            }
            ApplicationDefinition app3 = applicationDefinition;
            Id appId = app3.get_id();
            List intentsToCreate = new ArrayList();
            Iterable $this$map$iv = dump.getIntents();
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                Object item$iv$iv = iterator.next();
                entityTypeDefinition = (IntentDefinition)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                IntentDefinition intent = INSTANCE.getConfig().getIntentByNamespaceAndName(namespace, i.getName());
                if (intent == null) {
                    set$iv = IdsKt.newId();
                    list$iv = INSTANCE.changeEntityNames(i.getEntities(), namespace);
                    Set $i$f$mapTo2 = SetsKt.setOf((Object)appId);
                    String string4 = i.getDescription();
                    e$iv2 = string4 != null && (string4 = StringsKt.replace$default((String)string4, (String)"<br>", (String)"\n", (boolean)false, (int)4, null)) != null ? StringsKt.replace$default((String)string4, (String)"</br>", (String)"\n", (boolean)false, (int)4, null) : null;
                    intent = IntentDefinition.copy$default((IntentDefinition)i, null, (String)namespace, (Set)$i$f$mapTo2, list$iv, null, null, null, null, e$iv2, null, (Id)set$iv, (int)753, null);
                    intentsToCreate.add(intent);
                } else {
                    INSTANCE.getConfig().save(IntentDefinition.copy$default((IntentDefinition)intent, null, (String)namespace, (Set)SetsKt.plus((Set)intent.getApplications(), (Object)appId), null, null, null, null, null, null, null, null, (int)2041, null));
                }
                collection.add(TuplesKt.to((Object)i.get_id(), (Object)intent.get_id()));
            }
            Map intentsIdsMap = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
            Iterable $this$forEach$iv2 = intentsToCreate;
            boolean $i$f$forEach32 = false;
            for (Object element$iv : $this$forEach$iv2) {
                IntentDefinition intent = (IntentDefinition)element$iv;
                boolean bl7 = false;
                IntentDefinition newIntent2 = IntentDefinition.copy$default((IntentDefinition)intent, null, null, null, null, null, null, (Set)SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)intent.getSharedIntents()), (Function1)((Function1)new Function1<Id<IntentDefinition>, Id<IntentDefinition>>((Map<Id<IntentDefinition>, Id<IntentDefinition>>)intentsIdsMap){
                    final /* synthetic */ Map<Id<IntentDefinition>, Id<IntentDefinition>> $intentsIdsMap;
                    {
                        this.$intentsIdsMap = $intentsIdsMap;
                        super(1);
                    }

                    @Nullable
                    public final Id<IntentDefinition> invoke(@NotNull Id<IntentDefinition> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return this.$intentsIdsMap.get(it);
                    }
                }))), null, null, null, null, (int)1983, null);
                INSTANCE.getConfig().save(newIntent2);
                report2.add(newIntent2);
                logger.debug((Function0)new Function0<Object>(newIntent2){
                    final /* synthetic */ IntentDefinition $newIntent;
                    {
                        this.$newIntent = $newIntent;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Import intent " + this.$newIntent;
                    }
                });
            }
            $this$forEach$iv2 = SetsKt.plus((Set)app3.getIntents(), (Iterable)CollectionsKt.toSet((Iterable)intentsIdsMap.values()));
            $this$mapTo$iv$iv = dump.getApplication().getIntentStatesMap();
            Map map2 = app3.getIntentStatesMap();
            collection = this.getConfig();
            boolean $i$f$mapKeys = false;
            void intent = $this$mapKeys$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                list$iv = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv2;
                boolean bl8 = false;
                Object v = intentsIdsMap.get(it.getKey());
                Intrinsics.checkNotNull(v);
                e$iv2 = (Map.Entry)element$iv$iv$iv;
                Id id = (Id)v;
                Map map3 = map;
                boolean bl9 = false;
                Object v2 = it$iv$iv.getValue();
                map3.put(id, v2);
            }
            map = destination$iv$iv2;
            Map $i$f$forEach32 = MapsKt.plus((Map)map2, (Map)map);
            Iterator iterator2 = SetsKt.plus((Set)app3.getSupportedLocales(), (Iterable)dump.getApplication().getSupportedLocales());
            collection.save(ApplicationDefinition.copy$default((ApplicationDefinition)app3, null, null, null, (Set)$this$forEach$iv2, (Set)((Object)iterator2), (Map)$i$f$forEach32, null, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (boolean)false, null, (int)8135, null));
            report2.setLocaleAdded(!app3.getSupportedLocales().containsAll(dump.getApplication().getSupportedLocales()));
            intentsIdsMap.put(IdsKt.toId((String)"tock:unknown"), IdsKt.toId((String)"tock:unknown"));
            $this$forEach$iv2 = dump.getSentences();
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ClassifiedSentence s = (ClassifiedSentence)element$iv;
                boolean bl10 = false;
                if (INSTANCE.getConfig().search(new SentencesQuery(appId, s.getLanguage(), 0L, null, s.getText(), null, null, null, true, null, null, null, null, null, null, false, null, false, false, null, null, 0.0f, 0.0f, false, 0xFFFEEC, null)).getTotal() != 0L) continue;
                logger.debug((Function0)new Function0<Object>(s){
                    final /* synthetic */ ClassifiedSentence $s;
                    {
                        this.$s = $s;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Import sentence " + this.$s.getText();
                    }
                });
                Classification classification = s.getClassification();
                Object v = intentsIdsMap.get(s.getClassification().getIntentId());
                Intrinsics.checkNotNull(v);
                Iterable $this$sortedBy$iv = ApplicationCodecService.changeEntityNames$default(INSTANCE, s.getClassification().getEntities(), namespace, false, null, 12, null);
                boolean $i$f$sortedBy = false;
                ClassifiedSentence sentence = ClassifiedSentence.copy$default((ClassifiedSentence)s, null, null, (Id)appId, null, null, null, (Classification)classification.copy((Id)v, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ClassifiedEntity it = (ClassifiedEntity)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStart());
                        it = (ClassifiedEntity)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                    }
                })), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65467, null);
                report2.add(sentence);
                ApplicationConfiguration.DefaultImpls.save$default((ApplicationConfiguration)INSTANCE.getConfig(), (ClassifiedSentence)sentence, null, (int)2, null);
            }
            $this$forEach$iv2 = dump.getFaqs();
            $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv2) {
                IntentDefinition intentDB;
                Object element$iv22;
                FaqDefinition it;
                block22: {
                    it = (FaqDefinition)element$iv;
                    boolean bl11 = false;
                    Iterable $this$first$iv = dump.getIntents();
                    boolean $i$f$first = false;
                    for (Object element$iv22 : $this$first$iv) {
                        IntentDefinition intent2 = (IntentDefinition)element$iv22;
                        boolean bl12 = false;
                        if (!Intrinsics.areEqual((Object)intent2.get_id(), (Object)it.getIntentId())) continue;
                        break block22;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                IntentDefinition intentDump = (IntentDefinition)element$iv22;
                Intrinsics.checkNotNull((Object)INSTANCE.getConfig().getIntentByNamespaceAndName(namespace, intentDump.getName()));
                FaqDefinition faq = INSTANCE.getConfig().getFaqDefinitionByIntentId(intentDB.get_id());
                if (faq == null) {
                    FaqDefinition newFaq = FaqDefinition.copy$default((FaqDefinition)it, (Id)IdsKt.newId(), (Id)appId, (Id)intentDB.get_id(), null, null, (boolean)false, null, null, (int)248, null);
                    report2.add(newFaq);
                    INSTANCE.getConfig().save(newFaq);
                    logger.debug((Function0)new Function0<Object>(newFaq){
                        final /* synthetic */ FaqDefinition $newFaq;
                        {
                            this.$newFaq = $newFaq;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Import faq " + this.$newFaq;
                        }
                    });
                    continue;
                }
                boolean bl13 = it.getEnabled();
                List list = it.getTags();
                INSTANCE.getConfig().save(FaqDefinition.copy$default((FaqDefinition)faq, null, null, null, null, (List)list, (boolean)bl13, null, null, (int)207, null));
            }
            logger.info((Function0)new Function0<Object>(report2){
                final /* synthetic */ ImportReport $report;
                {
                    this.$report = $report;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Dump imported! Result : " + this.$report;
                }
            });
            if (report2.getModified()) {
                ModelUpdaterService.INSTANCE.triggerBuild(new ModelBuildTrigger(appId, true, false, 4, null));
            }
        }
        catch (Throwable t) {
            LoggersKt.error((KLogger)logger, (Throwable)t);
            report2.setSuccess(false);
            String string = t.getMessage();
            if (string == null) {
                string = "exception without message";
            }
            report2.addError(string);
        }
        return report2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ImportReport importSentences(@NotNull String namespace, @NotNull SentencesDump dump) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        logger.info((Function0)importSentences.1.INSTANCE);
        ImportReport report2 = new ImportReport(null, null, null, 0L, 0L, false, false, null, 255, null);
        try {
            Object object;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Locale locale;
            IntentDefinition intentDefinition;
            Map map;
            Object object2;
            Iterator $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object value$iv$iv$iv;
            Map $this$getOrPut$iv$iv$iv;
            Object key$iv$iv;
            IntentDefinition it;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            ApplicationDefinition applicationDefinition;
            String appName = ai.tock.shared.StringsKt.withoutNamespace$default((String)dump.getApplicationName(), null, (int)1, null);
            ApplicationDefinition app2 = null;
            ApplicationDefinition app3 = this.getConfig().getApplicationByNamespaceAndName(namespace, appName);
            boolean $i$a$-let-ApplicationCodecService$importSentences$app$22 = false;
            if (app3 == null) {
                ApplicationDefinition appToSave = new ApplicationDefinition(appName, appName, namespace, null, null, null, null, false, false, false, 0.0, false, null, 8184, null);
                report2.add(appToSave);
                logger.debug((Function0)new Function0<Object>(appToSave){
                    final /* synthetic */ ApplicationDefinition $appToSave;
                    {
                        this.$appToSave = $appToSave;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Import application " + this.$appToSave;
                    }
                });
                applicationDefinition = INSTANCE.getConfig().save(appToSave);
            } else {
                applicationDefinition = app3;
            }
            app2 = applicationDefinition;
            Id appId = app2.get_id();
            Iterable $i$a$-let-ApplicationCodecService$importSentences$app$22 = this.getConfig().getIntentsByApplicationId(appId);
            boolean $i$f$groupBy = false;
            void var10_13 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object3;
                it = (IntentDefinition)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getQualifiedName();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it2;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                object2 = it$iv$iv.getKey();
                map = $this$getOrPut$iv$iv$iv;
                boolean bl3 = false;
                intentDefinition = (IntentDefinition)CollectionsKt.first((List)((List)it2.getValue()));
                map.put(object2, intentDefinition);
            }
            Map intentsByNameMap = MapsKt.toMutableMap((Map)destination$iv$iv);
            Iterable $this$forEach$iv = dump.getSentences();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$sortedBy$iv;
                Collection<ClassifiedEntity> collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                IntentDefinition intentDefinition2;
                void it3;
                Iterable $this$forEach$iv2;
                IntentDefinition newIntent2;
                Object sentenceIntent;
                IntentDefinition intentDefinition3;
                String language;
                SentenceDump s = (SentenceDump)element$iv;
                boolean bl = false;
                Locale locale2 = s.getLanguage();
                if (locale2 == null) {
                    locale2 = dump.getLanguage();
                }
                String string = language = locale2 != null ? locale2.getLanguage() : null;
                if (language == null) {
                    report2.addError("please specify a language for : " + s.getText());
                    continue;
                }
                if (!LocalesKt.getSupportedLanguages().containsKey(language)) {
                    report2.addError("unknown language : " + language);
                    continue;
                }
                locale = new Locale(language);
                if (!app2.getSupportedLocales().contains(locale)) {
                    app2 = INSTANCE.getConfig().save(ApplicationDefinition.copy$default((ApplicationDefinition)app2, null, null, null, null, (Set)SetsKt.plus((Set)app2.getSupportedLocales(), (Object)locale), null, null, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (boolean)false, null, (int)8175, null));
                }
                if (Intrinsics.areEqual((Object)s.getIntent(), (Object)"tock:unknown")) {
                    intentDefinition3 = null;
                } else {
                    IntentDefinition intentDefinition4;
                    sentenceIntent = ai.tock.shared.StringsKt.changeNamespace((String)s.getIntent(), (String)namespace);
                    IntentDefinition newIntent3 = (IntentDefinition)intentsByNameMap.get(sentenceIntent);
                    boolean bl4 = false;
                    if (newIntent3 == null) {
                        IntentDefinition intent = INSTANCE.getConfig().getIntentByNamespaceAndName(namespace, ai.tock.shared.StringsKt.name((String)sentenceIntent));
                        if (intent != null) {
                            IntentDefinition i = IntentDefinition.copy$default((IntentDefinition)intent, null, null, (Set)SetsKt.plus((Set)intent.getApplications(), (Object)appId), null, null, null, null, null, null, null, null, (int)2043, null);
                            INSTANCE.getConfig().save(i);
                            intentsByNameMap.put(intent.getQualifiedName(), i);
                            intentDefinition4 = i;
                        } else {
                            IntentDefinition $this$importSentences_u24lambda_u2429_u24lambda_u2423_u24lambda_u2422 = new IntentDefinition(ai.tock.shared.StringsKt.name((String)sentenceIntent), namespace, SetsKt.setOf((Object)appId), SetsKt.emptySet(), null, null, null, null, null, null, null, 2032, null);
                            boolean bl5 = false;
                            INSTANCE.getConfig().save($this$importSentences_u24lambda_u2429_u24lambda_u2423_u24lambda_u2422);
                            intentsByNameMap.put($this$importSentences_u24lambda_u2429_u24lambda_u2423_u24lambda_u2422.getQualifiedName(), $this$importSentences_u24lambda_u2429_u24lambda_u2423_u24lambda_u2422);
                            report2.add($this$importSentences_u24lambda_u2429_u24lambda_u2423_u24lambda_u2422);
                            intentDefinition4 = $this$importSentences_u24lambda_u2429_u24lambda_u2423_u24lambda_u2422;
                        }
                    } else {
                        intentDefinition4 = newIntent3;
                    }
                    newIntent2 = intentDefinition4;
                    $this$forEach$iv2 = s.getEntities();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        boolean bl6;
                        String newName;
                        SentenceEntityDump e;
                        block29: {
                            e = (SentenceEntityDump)element$iv2;
                            boolean bl7 = false;
                            newName = INSTANCE.newName(e.getEntity(), namespace);
                            Iterable $this$none$iv = newIntent2.getEntities();
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl6 = true;
                            } else {
                                for (Object element$iv3 : $this$none$iv) {
                                    EntityDefinition it4 = (EntityDefinition)element$iv3;
                                    boolean bl8 = false;
                                    if (!(Intrinsics.areEqual((Object)it4.getEntityTypeName(), (Object)newName) && Intrinsics.areEqual((Object)it4.getRole(), (Object)e.getRole()))) continue;
                                    bl6 = false;
                                    break block29;
                                }
                                bl6 = true;
                            }
                        }
                        if (!bl6) continue;
                        IntentDefinition intentWithEntities = IntentDefinition.copy$default((IntentDefinition)newIntent2, null, null, null, (Set)SetsKt.plus((Set)newIntent2.getEntities(), (Object)new EntityDefinition(newName, e.getRole(), null, 4, null)), null, null, null, null, null, null, null, (int)2039, null);
                        INSTANCE.getConfig().save(intentWithEntities);
                        intentsByNameMap.put(intentWithEntities.getQualifiedName(), intentWithEntities);
                    }
                    intentDefinition3 = newIntent2;
                }
                IntentDefinition intent = intentDefinition3;
                ApplicationConfiguration applicationConfiguration = INSTANCE.getConfig();
                String string2 = s.getText();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
                newIntent2 = s.getStatus();
                $this$forEach$iv2 = newIntent2;
                Instant instant3 = instant2;
                Instant instant4 = instant;
                Id id = appId;
                Locale locale3 = locale;
                String string3 = string2;
                ApplicationConfiguration applicationConfiguration2 = applicationConfiguration;
                boolean bl9 = false;
                boolean bl10 = it3 == ClassifiedSentenceStatus.model;
                Object object4 = !bl10 ? newIntent2 : null;
                if (object4 == null) {
                    object4 = ClassifiedSentenceStatus.validated;
                }
                if ((intentDefinition2 = intent) == null || (intentDefinition2 = intentDefinition2.get_id()) == null) {
                    intentDefinition2 = IdsKt.toId((String)"tock:unknown");
                }
                sentenceIntent = s.getEntities();
                ApplicationCodecService applicationCodecService = INSTANCE;
                IntentDefinition intentDefinition5 = intentDefinition2;
                IntentDefinition intentDefinition6 = object4;
                boolean $i$f$map = false;
                it3 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it5;
                    SentenceEntityDump bl7 = (SentenceEntityDump)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl11 = false;
                    collection.add(it5.toClassifiedEntity());
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv2 = collection;
                boolean $i$f$sortedBy = false;
                List<ClassifiedEntity> list = applicationCodecService.changeEntityNames(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ClassifiedEntity it = (ClassifiedEntity)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStart());
                        it = (ClassifiedEntity)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                    }
                }), namespace, true, report2);
                IntentDefinition intentDefinition7 = intentDefinition5;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 52736;
                Map map2 = null;
                String string4 = null;
                String string5 = s.getReviewComment();
                boolean bl12 = s.getForReview();
                long l = 0L;
                long l2 = 0L;
                Instant instant5 = null;
                Double d = 1.0;
                Double d2 = 1.0;
                Classification classification = new Classification((Id)intentDefinition7, list);
                IntentDefinition intentDefinition8 = intentDefinition6;
                Instant instant6 = instant3;
                Instant instant7 = instant4;
                Id id2 = id;
                Locale locale4 = locale3;
                String string6 = string3;
                ApplicationConfiguration.DefaultImpls.save$default((ApplicationConfiguration)applicationConfiguration2, (ClassifiedSentence)new ClassifiedSentence(string6, locale4, id2, instant7, instant6, (ClassifiedSentenceStatus)intentDefinition8, classification, d2, d, instant5, l2, l, bl12, string5, string4, map2, n, defaultConstructorMarker), null, (int)2, null);
                long l3 = report2.getSentencesImported();
                report2.setSentencesImported(l3 + 1L);
            }
            $this$forEach$iv = intentsByNameMap.values();
            Set set = app2.getIntents();
            String string = null;
            String string7 = null;
            intentDefinition = null;
            object2 = app2;
            map = this.getConfig();
            boolean $i$f$map = false;
            $this$mapValuesTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                locale = (IntentDefinition)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.get_id());
            }
            object = (List)destination$iv$iv;
            map.save(ApplicationDefinition.copy$default(object2, (String)intentDefinition, string7, string, (Set)SetsKt.plus((Set)set, (Iterable)((Iterable)object)), null, null, null, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (boolean)false, null, (int)8183, null));
            if (report2.getModified()) {
                ModelUpdaterService.INSTANCE.triggerBuild(new ModelBuildTrigger(appId, true, false, 4, null));
            }
            logger.info((Function0)new Function0<Object>(report2){
                final /* synthetic */ ImportReport $report;
                {
                    this.$report = $report;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sentences Dump imported! Result : " + this.$report;
                }
            });
        }
        catch (Throwable t) {
            LoggersKt.error((KLogger)logger, (Throwable)t);
            report2.setSuccess(false);
            String string = t.getMessage();
            if (string == null) {
                string = "exception without message";
            }
            report2.addError(string);
        }
        return report2;
    }

    @NotNull
    public SentencesDump exportSentences(@NotNull Id<ApplicationDefinition> applicationId, @NotNull DumpType dumpType, @Nullable String intent, @Nullable Locale locale) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)dumpType, (String)"dumpType");
        Id filteredIntentId = intent == null ? null : this.getConfig().getIntentIdByQualifiedName(intent);
        return this.exportSentences(new SentencesQuery(applicationId, locale, 0L, null, null, filteredIntentId, null, null, false, null, null, null, null, null, null, false, null, false, false, null, null, 0.0f, 0.0f, false, 0xFFFFDC, null), dumpType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SentencesDump exportSentences(@NotNull List<SentencesQuery> queries, @NotNull DumpType dumpType) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$sortedBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        IntentDefinition it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        Intrinsics.checkNotNullParameter((Object)dumpType, (String)"dumpType");
        SentencesQuery query = (SentencesQuery)CollectionsKt.first(queries);
        Id applicationId = query.getApplicationId();
        ApplicationDefinition applicationDefinition = this.getConfig().getApplicationById(applicationId);
        Intrinsics.checkNotNull((Object)applicationDefinition);
        ApplicationDefinition app2 = applicationDefinition;
        Id filteredIntentId = query.getIntentId();
        Iterable iterable = this.getConfig().getIntentsByApplicationId(applicationId);
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IntentDefinition)element$iv$iv;
            boolean bl = false;
            if (!(filteredIntentId == null || Intrinsics.areEqual((Object)filteredIntentId, (Object)it.get_id()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (IntentDefinition)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.get_id();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues22 = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object3 = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            object = (IntentDefinition)CollectionsKt.first((List)((List)it2.getValue()));
            object3.put(k, object);
        }
        Object intents = destination$iv$iv;
        Iterable $i$f$mapValues22 = queries;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SentencesQuery it3 = (SentencesQuery)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.getConfig().search(SentencesQuery.copy$default((SentencesQuery)it3, null, null, (long)0L, (Integer)Integer.MAX_VALUE, null, null, null, null, (boolean)false, null, null, null, null, null, null, (boolean)false, null, (boolean)false, (boolean)false, null, null, (float)0.0f, (float)0.0f, (boolean)false, (int)0xFFBFF3, null)).getSentences();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        List sentences = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ClassifiedSentence it = (ClassifiedSentence)a;
                boolean bl = false;
                Comparable comparable = it.getUpdateDate();
                it = (ClassifiedSentence)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getUpdateDate());
            }
        });
        $this$sortedBy$iv = sentences;
        Locale locale = null;
        object = app2.getQualifiedName();
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SentenceDump sentenceDump;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ClassifiedSentence s = (ClassifiedSentence)element$iv$iv;
            boolean bl4 = false;
            IntentDefinition sentenceIntent = (IntentDefinition)intents.get(s.getClassification().getIntentId());
            if (sentenceIntent == null && !Intrinsics.areEqual((Object)s.getClassification().getIntentId(), (Object)IdsKt.toId((String)"tock:unknown"))) {
                logger.warn((Function0)new Function0<Object>(s){
                    final /* synthetic */ ClassifiedSentence $s;
                    {
                        this.$s = $s;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "unknown intent " + this.$s.getClassification().getIntentId();
                    }
                });
                sentenceDump = null;
            } else if (dumpType == DumpType.obfuscated && !Intrinsics.areEqual((Object)TockObfuscatorService.obfuscate$default((TockObfuscatorService)TockObfuscatorService.INSTANCE, (String)s.getText(), null, (int)2, null), (Object)s.getText())) {
                sentenceDump = null;
            } else {
                Collection<SentenceEntityDump> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String string = s.getText();
                Object object4 = sentenceIntent;
                if (object4 == null || (object4 = object4.getQualifiedName()) == null) {
                    object4 = "tock:unknown";
                }
                Iterable iterable2 = s.getClassification().getEntities();
                Object object5 = object4;
                String string2 = string;
                boolean $i$f$map = false;
                void var27_46 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it4;
                    ClassifiedEntity classifiedEntity = (ClassifiedEntity)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl5 = false;
                    collection.add(new SentenceEntityDump((ClassifiedEntity)it4));
                }
                collection = (List)destination$iv$iv3;
                String string3 = s.getReviewComment();
                boolean bl6 = s.getForReview();
                ClassifiedSentenceStatus classifiedSentenceStatus = s.getStatus();
                Locale locale2 = s.getLanguage();
                List list = collection;
                Object object6 = object5;
                String string4 = string2;
                sentenceDump = new SentenceDump(string4, (String)object6, list, locale2, classifiedSentenceStatus, bl6, string3);
            }
            if (sentenceDump == null) continue;
            SentenceDump it$iv$iv = sentenceDump;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        List list2 = list;
        Locale locale3 = locale;
        Object object7 = object;
        return new SentencesDump((String)object7, locale3, list2, n, defaultConstructorMarker);
    }

    @NotNull
    public SentencesDump exportSentences(@NotNull SentencesQuery query, @NotNull DumpType dumpType) {
        return ApplicationCodec.DefaultImpls.exportSentences((ApplicationCodec)this, (SentencesQuery)query, (DumpType)dumpType);
    }

    public static final /* synthetic */ EntityDefinition access$withNewName(ApplicationCodecService $this, EntityDefinition $receiver, String namespace) {
        return $this.withNewName($receiver, namespace);
    }

    public static final /* synthetic */ NlpCore access$getCore(ApplicationCodecService $this) {
        return $this.getCore();
    }
}

