/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.service;

import ai.tock.nlp.core.Intent;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.parser.IntentQualifier;
import ai.tock.nlp.front.shared.parser.ParseQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0080\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003JI\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0015\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0018\u0010.\u001a\u00020%2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0017H\u0002J\u0016\u00100\u001a\u00020%2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0017J\u000e\u00101\u001a\u00020%2\u0006\u0010)\u001a\u00020*J\t\u00102\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0017\u0012\u0004\u0012\u00020\r0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\r0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00063"}, d2={"Lai/tock/nlp/front/service/ParserRequestData;", "", "application", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "query", "Lai/tock/nlp/front/shared/parser/ParseQuery;", "classifiedSentence", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "intentsQualifiers", "", "Lai/tock/nlp/front/shared/parser/IntentQualifier;", "intents", "", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "(Lai/tock/nlp/front/shared/config/ApplicationDefinition;Lai/tock/nlp/front/shared/parser/ParseQuery;Lai/tock/nlp/front/shared/config/ClassifiedSentence;Ljava/util/Set;Ljava/util/List;)V", "getApplication", "()Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "getClassifiedSentence", "()Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "getIntents", "()Ljava/util/List;", "intentsById", "", "Lorg/litote/kmongo/Id;", "intentsByName", "", "getIntentsQualifiers", "()Ljava/util/Set;", "getQuery", "()Lai/tock/nlp/front/shared/parser/ParseQuery;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "getModifierForIntent", "", "intent", "Lai/tock/nlp/core/Intent;", "(Lai/tock/nlp/core/Intent;)Ljava/lang/Double;", "hashCode", "", "isIntentEnabled", "intentId", "isStateEnabledForIntentId", "isStateSupportedByIntent", "toString", "tock-nlp-front-service"})
public final class ParserRequestData {
    @NotNull
    private final ApplicationDefinition application;
    @NotNull
    private final ParseQuery query;
    @Nullable
    private final ClassifiedSentence classifiedSentence;
    @NotNull
    private final Set<IntentQualifier> intentsQualifiers;
    @NotNull
    private final List<IntentDefinition> intents;
    @NotNull
    private final Map<Id<IntentDefinition>, IntentDefinition> intentsById;
    @NotNull
    private final Map<String, IntentDefinition> intentsByName;

    public ParserRequestData(@NotNull ApplicationDefinition application, @NotNull ParseQuery query, @Nullable ClassifiedSentence classifiedSentence, @NotNull Set<IntentQualifier> intentsQualifiers, @NotNull List<IntentDefinition> intents) {
        IntentDefinition it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(intentsQualifiers, (String)"intentsQualifiers");
        Intrinsics.checkNotNullParameter(intents, (String)"intents");
        this.application = application;
        this.query = query;
        this.classifiedSentence = classifiedSentence;
        this.intentsQualifiers = intentsQualifiers;
        this.intents = intents;
        Iterable iterable = this.intents;
        ParserRequestData parserRequestData = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IntentDefinition intentDefinition = (IntentDefinition)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.get_id(), (Object)it));
        }
        parserRequestData.intentsById = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$map$iv = this.intents;
        parserRequestData = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IntentDefinition)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getQualifiedName(), (Object)it));
        }
        parserRequestData.intentsByName = MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final ApplicationDefinition getApplication() {
        return this.application;
    }

    @NotNull
    public final ParseQuery getQuery() {
        return this.query;
    }

    @Nullable
    public final ClassifiedSentence getClassifiedSentence() {
        return this.classifiedSentence;
    }

    @NotNull
    public final Set<IntentQualifier> getIntentsQualifiers() {
        return this.intentsQualifiers;
    }

    @NotNull
    public final List<IntentDefinition> getIntents() {
        return this.intents;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIntentEnabled(Id<IntentDefinition> intentId) {
        IntentDefinition intentDefinition;
        IntentQualifier it;
        if (this.intentsQualifiers.isEmpty()) return true;
        Iterable $this$any$iv = this.intentsQualifiers;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (IntentQualifier)element$iv;
            boolean bl = false;
            intentDefinition = this.intentsById.get(intentId);
        } while (!Intrinsics.areEqual((Object)it.getIntent(), (Object)(intentDefinition != null ? intentDefinition.getQualifiedName() : null)));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isStateEnabledForIntentId(@Nullable Id<IntentDefinition> intentId) {
        if (!this.isIntentEnabled(intentId)) return false;
        IntentDefinition intentDefinition = this.intentsById.get(intentId);
        if (intentDefinition == null) return true;
        boolean bl = intentDefinition.supportStates(this.query.getState().getStates());
        if (!bl) return false;
        return true;
    }

    public final boolean isStateSupportedByIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        IntentDefinition intentDefinition = this.intentsByName.get(intent.getName());
        return intentDefinition != null ? intentDefinition.supportStates(this.query.getState().getStates()) : true;
    }

    @Nullable
    public final Double getModifierForIntent(@NotNull Intent intent) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            Iterable $this$firstOrNull$iv = this.intentsQualifiers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IntentQualifier it = (IntentQualifier)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIntent(), (Object)intent.getName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        IntentQualifier intentQualifier = v0;
        return intentQualifier != null ? Double.valueOf(intentQualifier.getModifier()) : null;
    }

    @NotNull
    public final ApplicationDefinition component1() {
        return this.application;
    }

    @NotNull
    public final ParseQuery component2() {
        return this.query;
    }

    @Nullable
    public final ClassifiedSentence component3() {
        return this.classifiedSentence;
    }

    @NotNull
    public final Set<IntentQualifier> component4() {
        return this.intentsQualifiers;
    }

    @NotNull
    public final List<IntentDefinition> component5() {
        return this.intents;
    }

    @NotNull
    public final ParserRequestData copy(@NotNull ApplicationDefinition application, @NotNull ParseQuery query, @Nullable ClassifiedSentence classifiedSentence, @NotNull Set<IntentQualifier> intentsQualifiers, @NotNull List<IntentDefinition> intents) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(intentsQualifiers, (String)"intentsQualifiers");
        Intrinsics.checkNotNullParameter(intents, (String)"intents");
        return new ParserRequestData(application, query, classifiedSentence, intentsQualifiers, intents);
    }

    public static /* synthetic */ ParserRequestData copy$default(ParserRequestData parserRequestData, ApplicationDefinition applicationDefinition, ParseQuery parseQuery, ClassifiedSentence classifiedSentence, Set set, List list, int n, Object object) {
        if ((n & 1) != 0) {
            applicationDefinition = parserRequestData.application;
        }
        if ((n & 2) != 0) {
            parseQuery = parserRequestData.query;
        }
        if ((n & 4) != 0) {
            classifiedSentence = parserRequestData.classifiedSentence;
        }
        if ((n & 8) != 0) {
            set = parserRequestData.intentsQualifiers;
        }
        if ((n & 0x10) != 0) {
            list = parserRequestData.intents;
        }
        return parserRequestData.copy(applicationDefinition, parseQuery, classifiedSentence, set, list);
    }

    @NotNull
    public String toString() {
        return "ParserRequestData(application=" + this.application + ", query=" + this.query + ", classifiedSentence=" + this.classifiedSentence + ", intentsQualifiers=" + this.intentsQualifiers + ", intents=" + this.intents + ")";
    }

    public int hashCode() {
        int result = this.application.hashCode();
        result = result * 31 + this.query.hashCode();
        result = result * 31 + (this.classifiedSentence == null ? 0 : this.classifiedSentence.hashCode());
        result = result * 31 + ((Object)this.intentsQualifiers).hashCode();
        result = result * 31 + ((Object)this.intents).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParserRequestData)) {
            return false;
        }
        ParserRequestData parserRequestData = (ParserRequestData)other;
        if (!Intrinsics.areEqual((Object)this.application, (Object)parserRequestData.application)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.query, (Object)parserRequestData.query)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classifiedSentence, (Object)parserRequestData.classifiedSentence)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.intentsQualifiers, parserRequestData.intentsQualifiers)) {
            return false;
        }
        return Intrinsics.areEqual(this.intents, parserRequestData.intents);
    }
}

