/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.service;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.BuildContext;
import ai.tock.nlp.core.CallContext;
import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityEvaluationContext;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.IntentSelector;
import ai.tock.nlp.core.ModelCore;
import ai.tock.nlp.core.NlpCore;
import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.core.ParsingResult;
import ai.tock.nlp.core.merge.ValueDescriptor;
import ai.tock.nlp.front.service.ApplicationConfigurationServiceKt;
import ai.tock.nlp.front.service.ConfigurationRepository;
import ai.tock.nlp.front.service.ParserRequestData;
import ai.tock.nlp.front.service.ParserService;
import ai.tock.nlp.front.service.UnknownApplicationException;
import ai.tock.nlp.front.service.selector.IntentSelectorService;
import ai.tock.nlp.front.service.selector.SelectorBase;
import ai.tock.nlp.front.service.storage.ParseRequestLogDAO;
import ai.tock.nlp.front.shared.ApplicationConfiguration;
import ai.tock.nlp.front.shared.Parser;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.Classification;
import ai.tock.nlp.front.shared.config.ClassifiedEntity;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.config.SentencesQuery;
import ai.tock.nlp.front.shared.evaluation.EntityEvaluationQuery;
import ai.tock.nlp.front.shared.evaluation.EntityEvaluationResult;
import ai.tock.nlp.front.shared.evaluation.EntityToEvaluate;
import ai.tock.nlp.front.shared.merge.ValueToMerge;
import ai.tock.nlp.front.shared.merge.ValuesMergeQuery;
import ai.tock.nlp.front.shared.merge.ValuesMergeResult;
import ai.tock.nlp.front.shared.monitoring.MarkAsUnknownQuery;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLog;
import ai.tock.nlp.front.shared.parser.IntentQualifier;
import ai.tock.nlp.front.shared.parser.ParseQuery;
import ai.tock.nlp.front.shared.parser.ParseResult;
import ai.tock.nlp.front.shared.parser.ParsedEntityValue;
import ai.tock.nlp.front.shared.value.ValueTransformer;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001IB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001d\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J,\u0010*\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-\u0018\u00010+2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u00020-H\u0002J\b\u00102\u001a\u00020\u001cH\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010\u001f\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020(H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010\u001f\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u001f\u001a\u00020>H\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u0010\u001f\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J'\u0010A\u001a\u0002042\u0006\u0010#\u001a\u00020$2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010CH\u0000\u00a2\u0006\u0002\bEJ\u001e\u0010F\u001a\u00020\u001c*\u00020C2\u0006\u0010G\u001a\u00020$2\b\u0010H\u001a\u0004\u0018\u00010CH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lai/tock/nlp/front/service/ParserService;", "Lai/tock/nlp/front/shared/Parser;", "()V", "config", "Lai/tock/nlp/front/shared/ApplicationConfiguration;", "getConfig", "()Lai/tock/nlp/front/shared/ApplicationConfiguration;", "core", "Lai/tock/nlp/core/NlpCore;", "getCore", "()Lai/tock/nlp/core/NlpCore;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "logDAO", "Lai/tock/nlp/front/service/storage/ParseRequestLogDAO;", "getLogDAO", "()Lai/tock/nlp/front/service/storage/ParseRequestLogDAO;", "logger", "Lmu/KLogger;", "modelCore", "Lai/tock/nlp/core/ModelCore;", "getModelCore", "()Lai/tock/nlp/core/ModelCore;", "tabCarriageRegexp", "Lkotlin/text/Regex;", "validateSentenceTest", "", "evaluateEntities", "Lai/tock/nlp/front/shared/evaluation/EntityEvaluationResult;", "query", "Lai/tock/nlp/front/shared/evaluation/EntityEvaluationQuery;", "findLanguage", "Ljava/util/Locale;", "application", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "locale", "findLanguage$tock_nlp_front_service", "formatQuery", "", "formatQuery$tock_nlp_front_service", "getReferenceDateByEntityMap", "", "Lai/tock/nlp/core/Entity;", "Ljava/time/ZonedDateTime;", "intents", "", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "referenceDate", "healthcheck", "incrementUnknown", "", "Lai/tock/nlp/front/shared/monitoring/MarkAsUnknownQuery;", "loadApplication", "namespace", "applicationName", "mergeValues", "Lai/tock/nlp/front/shared/merge/ValuesMergeResult;", "Lai/tock/nlp/front/shared/merge/ValuesMergeQuery;", "parse", "Lai/tock/nlp/front/shared/parser/ParseResult;", "Lai/tock/nlp/front/shared/parser/ParseQuery;", "metadata", "Lai/tock/nlp/front/service/ParserService$CallMetadata;", "saveSentence", "newSentence", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "validatedSentence", "saveSentence$tock_nlp_front_service", "hasSameContent", "app", "sentence", "CallMetadata", "tock-nlp-front-service"})
public final class ParserService
implements Parser {
    @NotNull
    public static final ParserService INSTANCE = new ParserService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final Regex tabCarriageRegexp = new Regex("[\\n\\r\\t]+");
    private static final boolean validateSentenceTest = PropertiesKt.booleanProperty((String)"tock_parser_validate_sentence_test", (boolean)false);

    private ParserService() {
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    private final ParseRequestLogDAO getLogDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (ParseRequestLogDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<ParseRequestLogDAO>(){}, tag$iv).getValue()).invoke();
    }

    private final NlpCore getCore() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (NlpCore)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<NlpCore>(){}, tag$iv).getValue()).invoke();
    }

    private final ModelCore getModelCore() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (ModelCore)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<ModelCore>(){}, tag$iv).getValue()).invoke();
    }

    private final ApplicationConfiguration getConfig() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (ApplicationConfiguration)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<ApplicationConfiguration>(){}, tag$iv).getValue()).invoke();
    }

    @NotNull
    public final String formatQuery$tock_nlp_front_service(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        CharSequence charSequence = query;
        Regex regex = tabCarriageRegexp;
        String string = "";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    @NotNull
    public final Locale findLanguage$tock_nlp_front_service(@NotNull ApplicationDefinition application, @NotNull Locale locale) {
        Locale locale2;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Set locales = application.getSupportedLocales();
        boolean bl = false;
        if (locales.contains(locale)) {
            locale2 = locale;
        } else {
            Locale language = new Locale(locale.getLanguage());
            if (locales.contains(language)) {
                locale2 = language;
            } else if (locales.contains(LocalesKt.getDefaultLocale())) {
                logger.warn((Function0)new Function0<Object>(locale){
                    final /* synthetic */ Locale $locale;
                    {
                        this.$locale = $locale;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "locale not found - " + this.$locale + " - use default " + LocalesKt.getDefaultLocale();
                    }
                });
                locale2 = LocalesKt.getDefaultLocale();
            } else {
                Locale first = (Locale)CollectionsKt.first((Iterable)locales);
                logger.warn((Function0)new Function0<Object>(locale, first){
                    final /* synthetic */ Locale $locale;
                    final /* synthetic */ Locale $first;
                    {
                        this.$locale = $locale;
                        this.$first = $first;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "locale not found - " + this.$locale + " - use first found " + this.$first;
                    }
                });
                locale2 = first;
            }
        }
        return locale2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ParseResult parse(@NotNull ParseQuery query) {
        ParseResult parseResult;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        long time = System.currentTimeMillis();
        ParseQuery $this$parse_u24lambda_u243 = query;
        boolean bl = false;
        ApplicationDefinition application = INSTANCE.loadApplication($this$parse_u24lambda_u243.getNamespace(), $this$parse_u24lambda_u243.getApplicationName());
        Locale language = INSTANCE.findLanguage$tock_nlp_front_service(application, $this$parse_u24lambda_u243.getContext().getLanguage());
        ZonedDateTime referenceDate = $this$parse_u24lambda_u243.getContext().getReferenceDate().withZoneSameInstant($this$parse_u24lambda_u243.getContext().getReferenceTimezone());
        Intrinsics.checkNotNullExpressionValue((Object)referenceDate, (String)"referenceDate");
        CallMetadata metadata = new CallMetadata(application, language, referenceDate, query.getIntentsSubset());
        Ref.ObjectRef result = new Ref.ObjectRef();
        try {
            result.element = INSTANCE.parse(query, metadata);
            parseResult = (ParseResult)result.element;
        }
        catch (Throwable throwable) {
            INSTANCE.getExecutor().executeBlocking((Function0)new Function0<Unit>(application, query, (Ref.ObjectRef<ParseResult>)result, time){
                final /* synthetic */ ApplicationDefinition $application;
                final /* synthetic */ ParseQuery $query;
                final /* synthetic */ Ref.ObjectRef<ParseResult> $result;
                final /* synthetic */ long $time;
                {
                    this.$application = $application;
                    this.$query = $query;
                    this.$result = $result;
                    this.$time = $time;
                    super(0);
                }

                public final void invoke() {
                    ParserService.access$getLogDAO(ParserService.INSTANCE).save(new ParseRequestLog(this.$application.get_id(), this.$query, (ParseResult)this.$result.element, System.currentTimeMillis() - this.$time, false, null, 48, null));
                }
            });
            throw throwable;
        }
        INSTANCE.getExecutor().executeBlocking((Function0)new /* invalid duplicate definition of identical inner class */);
        return parseResult;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Entity, ZonedDateTime> getReferenceDateByEntityMap(List<IntentDefinition> intents, ZonedDateTime referenceDate) {
        Map map;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = intents;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IntentDefinition it = (IntentDefinition)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getEntities();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Map it = map = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv))), (Function1)getReferenceDateByEntityMap.2.INSTANCE), (Function1)getReferenceDateByEntityMap.3.INSTANCE), (Function1)((Function1)new Function1<Entity, Pair<? extends Entity, ? extends ZonedDateTime>>(referenceDate){
            final /* synthetic */ ZonedDateTime $referenceDate;
            {
                this.$referenceDate = $referenceDate;
                super(1);
            }

            @NotNull
            public final Pair<Entity, ZonedDateTime> invoke(@NotNull Entity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TuplesKt.to((Object)it, (Object)this.$referenceDate.truncatedTo(ChronoUnit.DAYS));
            }
        })));
        boolean bl = false;
        return !it.isEmpty() ? map : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ParseResult parse(ParseQuery query, CallMetadata metadata) {
        Collection<ParsedEntityValue> collection;
        EntityRecognition it;
        Collection<ParsedEntityValue> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ParseQuery $this$parse_u24lambda_u2411 = query;
        boolean bl = false;
        ApplicationDefinition application = metadata.component1();
        Locale language = metadata.component2();
        ZonedDateTime referenceDate = metadata.component3();
        Set<IntentQualifier> intentsQualifiers = metadata.component4();
        String q = INSTANCE.formatQuery$tock_nlp_front_service((String)CollectionsKt.first((List)$this$parse_u24lambda_u2411.getQueries()));
        if (((CharSequence)q).length() == 0) {
            logger.warn((Function0)new Function0<Object>(query){
                final /* synthetic */ ParseQuery $query;
                {
                    this.$query = $query;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "empty query after format - " + this.$query;
                }
            });
            return new ParseResult("tock:unknown", "tock", query.getContext().getLanguage(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), 0.0, 0.0, q, MapsKt.emptyMap());
        }
        Object[] objectArray = new ClassifiedSentenceStatus[]{ClassifiedSentenceStatus.validated, ClassifiedSentenceStatus.model};
        ClassifiedSentence validatedSentence = (ClassifiedSentence)CollectionsKt.firstOrNull((List)INSTANCE.getConfig().search(new SentencesQuery(application.get_id(), language, 0L, null, q, null, SetsKt.setOf((Object[])objectArray), null, true, null, null, null, null, null, null, false, null, false, false, null, null, 0.0f, 0.0f, application.getNormalizeText(), 8388268, null)).getSentences());
        List<IntentDefinition> intents = ConfigurationRepository.INSTANCE.getIntentsByApplicationId((Id<ApplicationDefinition>)application.get_id());
        CallContext callContext = new CallContext(ConfigurationRepository.INSTANCE.toApplication(application), language, application.getNlpEngineType(), new EntityEvaluationContext(referenceDate, application.getMergeEngineTypes(), application.getUseEntityModels(), INSTANCE.getReferenceDateByEntityMap(intents, referenceDate)));
        ParserRequestData data = new ParserRequestData(application, query, validatedSentence, intentsQualifiers, intents);
        if (IntentSelectorService.INSTANCE.isValidClassifiedSentence(data)) {
            Collection<ParsedEntityValue> collection3;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Object object;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            NlpCore nlpCore = INSTANCE.getCore();
            ClassifiedSentence classifiedSentence = validatedSentence;
            Intrinsics.checkNotNull((Object)classifiedSentence);
            Iterable iterable = classifiedSentence.getClassification().getEntities();
            String string = q;
            CallContext callContext2 = callContext;
            NlpCore nlpCore2 = nlpCore;
            boolean $i$f$mapNotNull22 = false;
            void var19_21 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                EntityRecognition it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                ClassifiedEntity it2 = (ClassifiedEntity)element$iv$iv;
                boolean bl3 = false;
                if (it2.toEntityRecognition((Function2)new Function2<String, String, Entity>((Object)ConfigurationRepository.INSTANCE){

                    @Nullable
                    public final Entity invoke(@NotNull String p0, @NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((ConfigurationRepository)this.receiver).toEntity(p0, p1);
                    }
                }) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            List entityValues2 = nlpCore2.evaluateEntities(callContext2, string, list);
            IntentDefinition intent = ConfigurationRepository.INSTANCE.getIntentById((Id<IntentDefinition>)validatedSentence.getClassification().getIntentId());
            Object object2 = intent;
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = ai.tock.shared.StringsKt.name((String)"tock:unknown");
            }
            if ((object = intent) == null || (object = object.getNamespace()) == null) {
                object = ai.tock.shared.StringsKt.namespace((String)"tock:unknown");
            }
            Iterable $i$f$mapNotNull22 = entityValues2;
            Locale locale = language;
            list = object;
            string = object2;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                element$iv$iv$iv = (EntityRecognition)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl5 = false;
                collection3.add(new ParsedEntityValue(it3.getValue(), 1.0, INSTANCE.getCore().supportValuesMerge(it3.getEntityType())));
            }
            collection3 = (List)destination$iv$iv2;
            Map map = MapsKt.emptyMap();
            String string2 = q;
            double d = 1.0;
            double d2 = 1.0;
            List list2 = CollectionsKt.emptyList();
            Collection<ParsedEntityValue> collection4 = collection3;
            Locale locale2 = locale;
            List list3 = list;
            String string3 = string;
            return new ParseResult(string3, (String)((Object)list3), locale2, collection4, list2, d2, d, string2, map);
        }
        SelectorBase intentSelector = IntentSelectorService.INSTANCE.selector(data);
        ParsingResult $this$parse_u24lambda_u2411_u24lambda_u2410 = INSTANCE.getCore().parse(callContext, q, (IntentSelector)intentSelector);
        boolean bl6 = false;
        String realIntent = intentsQualifiers.isEmpty() && $this$parse_u24lambda_u2411_u24lambda_u2410.getIntentProbability() < application.getUnknownIntentThreshold() ? "tock:unknown" : $this$parse_u24lambda_u2411_u24lambda_u2410.getIntent();
        Iterable $i$f$mapTo = $this$parse_u24lambda_u2411_u24lambda_u2410.getEntities();
        Locale locale = language;
        String string = ai.tock.shared.StringsKt.namespace((String)realIntent);
        String string4 = ai.tock.shared.StringsKt.withoutNamespace$default((String)realIntent, null, (int)1, null);
        boolean $i$f$map = false;
        void bl3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EntityRecognition entityRecognition = (EntityRecognition)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl7 = false;
            collection2.add(new ParsedEntityValue(it.getValue(), it.getProbability(), INSTANCE.getCore().supportValuesMerge(it.getEntityType())));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = $this$parse_u24lambda_u2411_u24lambda_u2410.getNotRetainedEntities();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EntityRecognition)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl8 = false;
            collection.add(new ParsedEntityValue(it.getValue(), it.getProbability(), INSTANCE.getCore().supportValuesMerge(it.getEntityType())));
        }
        collection = (List)destination$iv$iv;
        Map<String, Double> map = intentSelector.getOtherIntents();
        String string5 = q;
        double d = $this$parse_u24lambda_u2411_u24lambda_u2410.getEntitiesProbability();
        double d3 = $this$parse_u24lambda_u2411_u24lambda_u2410.getIntentProbability();
        Collection<ParsedEntityValue> collection5 = collection;
        Collection<ParsedEntityValue> collection6 = collection2;
        Locale locale3 = locale;
        String string6 = string;
        String string7 = string4;
        ParseResult result = new ParseResult(string7, string6, locale3, collection6, collection5, d3, d, string5, map);
        if ($this$parse_u24lambda_u2411.getContext().getRegisterQuery()) {
            INSTANCE.getExecutor().executeBlocking((Function0)new Function0<Unit>(application, validatedSentence, result, language){
                final /* synthetic */ ApplicationDefinition $application;
                final /* synthetic */ ClassifiedSentence $validatedSentence;
                final /* synthetic */ ParseResult $result;
                final /* synthetic */ Locale $language;
                {
                    this.$application = $application;
                    this.$validatedSentence = $validatedSentence;
                    this.$result = $result;
                    this.$language = $language;
                    super(0);
                }

                public final void invoke() {
                    ParserService.INSTANCE.saveSentence$tock_nlp_front_service(this.$application, ParserService.access$parse$lambda$11$toClassifiedSentence(this.$result, this.$language, this.$application), this.$validatedSentence);
                }
            });
        }
        if (validateSentenceTest && $this$parse_u24lambda_u2411.getContext().getTest() && validatedSentence != null && !INSTANCE.hasSameContent(validatedSentence, application, ParserService.parse$lambda$11$toClassifiedSentence(result, language, application))) {
            throw new IllegalStateException(("[TEST MODE] nlp model does not produce same output than validated sentence for query " + q).toString());
        }
        return result;
    }

    public final void saveSentence$tock_nlp_front_service(@NotNull ApplicationDefinition application, @NotNull ClassifiedSentence newSentence, @Nullable ClassifiedSentence validatedSentence) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)newSentence, (String)"newSentence");
        ClassifiedSentence $this$saveSentence_u24lambda_u2412 = newSentence;
        boolean bl = false;
        ClassifiedSentence classifiedSentence = validatedSentence;
        if ((classifiedSentence != null ? classifiedSentence.getStatus() : null) != ClassifiedSentenceStatus.validated) {
            ClassifiedSentence classifiedSentence2 = validatedSentence;
            if ((classifiedSentence2 != null ? classifiedSentence2.getStatus() : null) != ClassifiedSentenceStatus.model && !INSTANCE.hasSameContent($this$saveSentence_u24lambda_u2412, application, validatedSentence)) {
                Double d = $this$saveSentence_u24lambda_u2412.getLastIntentProbability();
                ClassifiedSentence sentence = (d != null ? d : 0.0) > 0.1 ? $this$saveSentence_u24lambda_u2412 : ClassifiedSentence.copy$default((ClassifiedSentence)$this$saveSentence_u24lambda_u2412, null, null, null, null, null, null, (Classification)$this$saveSentence_u24lambda_u2412.getClassification().copy(IdsKt.toId((String)"tock:unknown"), CollectionsKt.emptyList()), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65471, null);
                ApplicationConfiguration.DefaultImpls.save$default((ApplicationConfiguration)INSTANCE.getConfig(), (ClassifiedSentence)sentence, null, (int)2, null);
            }
        }
    }

    private final boolean hasSameContent(ClassifiedSentence $this$hasSameContent, ApplicationDefinition app2, ClassifiedSentence sentence) {
        ClassifiedSentence classifiedSentence;
        ClassifiedSentence classifiedSentence2 = ClassifiedSentence.copy$default((ClassifiedSentence)$this$hasSameContent, (String)(app2.getNormalizeText() ? ai.tock.shared.StringsKt.normalize((String)$this$hasSameContent.getText(), (Locale)$this$hasSameContent.getLanguage()) : $this$hasSameContent.getText()), null, null, null, null, null, null, null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65534, null);
        if (sentence != null) {
            String string = app2.getNormalizeText() ? ai.tock.shared.StringsKt.normalize((String)sentence.getText(), (Locale)$this$hasSameContent.getLanguage()) : sentence.getText();
            ClassifiedSentenceStatus classifiedSentenceStatus = $this$hasSameContent.getStatus();
            Instant instant = $this$hasSameContent.getCreationDate();
            Instant instant2 = $this$hasSameContent.getUpdateDate();
            Double d = $this$hasSameContent.getLastIntentProbability();
            Double d2 = $this$hasSameContent.getLastEntityProbability();
            Map map = $this$hasSameContent.getOtherIntentsProbabilities();
            classifiedSentence = ClassifiedSentence.copy$default((ClassifiedSentence)sentence, (String)string, null, null, (Instant)instant, (Instant)instant2, (ClassifiedSentenceStatus)classifiedSentenceStatus, null, (Double)d, (Double)d2, null, (long)0L, (long)0L, (boolean)false, null, null, (Map)map, (int)32326, null);
        } else {
            classifiedSentence = null;
        }
        return Intrinsics.areEqual((Object)classifiedSentence2, classifiedSentence);
    }

    @NotNull
    public EntityEvaluationResult evaluateEntities(@NotNull EntityEvaluationQuery query) {
        EntityRecognition it;
        Collection<EntityRecognition> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        EntityEvaluationQuery $this$evaluateEntities_u24lambda_u2415 = query;
        boolean bl = false;
        ApplicationDefinition application = INSTANCE.loadApplication($this$evaluateEntities_u24lambda_u2415.getNamespace(), $this$evaluateEntities_u24lambda_u2415.getApplicationName());
        Locale language = INSTANCE.findLanguage$tock_nlp_front_service(application, $this$evaluateEntities_u24lambda_u2415.getContext().getLanguage());
        ZonedDateTime referenceDate = $this$evaluateEntities_u24lambda_u2415.getContext().getReferenceDate().withZoneSameInstant($this$evaluateEntities_u24lambda_u2415.getContext().getReferenceTimezone());
        Application application2 = ConfigurationRepository.INSTANCE.toApplication(application);
        NlpEngineType nlpEngineType = application.getNlpEngineType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceDate, (String)"referenceDate");
        CallContext callContext = new CallContext(application2, language, nlpEngineType, new EntityEvaluationContext(referenceDate, false, false, INSTANCE.getReferenceDateByEntityMap(ConfigurationRepository.INSTANCE.getIntentsByApplicationId((Id<ApplicationDefinition>)application.get_id()), referenceDate), 6, null));
        Iterable iterable = query.getEntities();
        Object object = $this$evaluateEntities_u24lambda_u2415.getText();
        CallContext callContext2 = callContext;
        NlpCore nlpCore = INSTANCE.getCore();
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EntityToEvaluate entityToEvaluate = (EntityToEvaluate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toEntityRecognition());
        }
        collection = (List)destination$iv$iv;
        List result = nlpCore.evaluateEntities(callContext2, (String)object, (List)collection);
        $this$map$iv = result;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EntityRecognition)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            object.add(new ParsedEntityValue(it.getValue(), it.getProbability(), INSTANCE.getCore().supportValuesMerge(it.getEntityType())));
        }
        List list = (List)destination$iv$iv;
        return new EntityEvaluationResult(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ValuesMergeResult mergeValues(@NotNull ValuesMergeQuery query) {
        ValueDescriptor result;
        Collection<ValueDescriptor> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        ValuesMergeQuery $this$mergeValues_u24lambda_u2417 = query;
        boolean bl = false;
        ApplicationDefinition application = INSTANCE.loadApplication($this$mergeValues_u24lambda_u2417.getNamespace(), $this$mergeValues_u24lambda_u2417.getApplicationName());
        Locale language = INSTANCE.findLanguage$tock_nlp_front_service(application, $this$mergeValues_u24lambda_u2417.getContext().getLanguage());
        ZonedDateTime referenceDate = $this$mergeValues_u24lambda_u2417.getContext().getReferenceDate().withZoneSameInstant($this$mergeValues_u24lambda_u2417.getContext().getReferenceTimezone());
        Application application2 = ConfigurationRepository.INSTANCE.toApplication(application);
        NlpEngineType nlpEngineType = application.getNlpEngineType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceDate, (String)"referenceDate");
        CallContext callContext = new CallContext(application2, language, nlpEngineType, new EntityEvaluationContext(referenceDate, false, false, INSTANCE.getReferenceDateByEntityMap(ConfigurationRepository.INSTANCE.getIntentsByApplicationId((Id<ApplicationDefinition>)application.get_id()), referenceDate), 6, null));
        Iterable iterable = $this$mergeValues_u24lambda_u2417.getValues();
        Entity entity = $this$mergeValues_u24lambda_u2417.getEntity();
        CallContext callContext2 = callContext;
        NlpCore nlpCore = INSTANCE.getCore();
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueToMerge valueToMerge = (ValueToMerge)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toValueDescriptor());
        }
        collection = (List)destination$iv$iv;
        ValueDescriptor valueDescriptor = result = nlpCore.mergeValues(callContext2, entity, (List)collection);
        ValueDescriptor valueDescriptor2 = result;
        return new ValuesMergeResult(ValueTransformer.INSTANCE.wrapNullableValue(valueDescriptor != null ? valueDescriptor.getValue() : null), valueDescriptor2 != null ? valueDescriptor2.getContent() : null);
    }

    public void incrementUnknown(@NotNull MarkAsUnknownQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        MarkAsUnknownQuery $this$incrementUnknown_u24lambda_u2418 = query;
        boolean bl = false;
        ApplicationDefinition application = INSTANCE.loadApplication($this$incrementUnknown_u24lambda_u2418.getNamespace(), $this$incrementUnknown_u24lambda_u2418.getApplicationName());
        Locale language = INSTANCE.findLanguage$tock_nlp_front_service(application, $this$incrementUnknown_u24lambda_u2418.getLanguage());
        ApplicationConfigurationServiceKt.getSentenceDAO().incrementUnknownStat((Id<ApplicationDefinition>)application.get_id(), language, $this$incrementUnknown_u24lambda_u2418.getText());
    }

    private final ApplicationDefinition loadApplication(String namespace, String applicationName) {
        ApplicationDefinition applicationDefinition = ConfigurationRepository.INSTANCE.getApplicationByNamespaceAndName(namespace, applicationName);
        if (applicationDefinition == null) {
            throw new UnknownApplicationException(namespace, applicationName);
        }
        return applicationDefinition;
    }

    public boolean healthcheck() {
        return this.getCore().healthcheck();
    }

    private static final ClassifiedSentence parse$lambda$11$toClassifiedSentence(ParseResult result, Locale language, ApplicationDefinition application) {
        String intentName = ai.tock.shared.StringsKt.withNamespace((String)result.getIntent(), (String)result.getIntentNamespace());
        Id id = INSTANCE.getConfig().getIntentIdByQualifiedName(intentName);
        if (id == null) {
            throw new IllegalStateException(("unknown intent: " + intentName).toString());
        }
        Id intentId = id;
        return new ClassifiedSentence(result, language, application.get_id(), intentId, result.getIntentProbability(), result.getEntitiesProbability());
    }

    public static final /* synthetic */ ParseRequestLogDAO access$getLogDAO(ParserService $this) {
        return $this.getLogDAO();
    }

    public static final /* synthetic */ ClassifiedSentence access$parse$lambda$11$toClassifiedSentence(ParseResult result, Locale language, ApplicationDefinition application) {
        return ParserService.parse$lambda$11$toClassifiedSentence(result, language, application);
    }

    static {
        if (PropertiesKt.booleanProperty((String)"tock_nlp_model_fill_cache", (boolean)false)) {
            try {
                Iterable $this$forEach$iv = INSTANCE.getConfig().getApplications();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ApplicationDefinition app2 = (ApplicationDefinition)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = app2.getSupportedLocales();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Locale locale = (Locale)element$iv2;
                        boolean bl2 = false;
                        INSTANCE.getModelCore().warmupModels(new BuildContext(ConfigurationRepository.INSTANCE.toApplication(app2), locale, app2.getNlpEngineType(), false, 8, null));
                    }
                }
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)logger, (Throwable)e);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lai/tock/nlp/front/service/ParserService$CallMetadata;", "", "application", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "referenceDate", "Ljava/time/ZonedDateTime;", "intentsQualifiers", "", "Lai/tock/nlp/front/shared/parser/IntentQualifier;", "(Lai/tock/nlp/front/shared/config/ApplicationDefinition;Ljava/util/Locale;Ljava/time/ZonedDateTime;Ljava/util/Set;)V", "getApplication", "()Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "getIntentsQualifiers", "()Ljava/util/Set;", "getLanguage", "()Ljava/util/Locale;", "getReferenceDate", "()Ljava/time/ZonedDateTime;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-front-service"})
    private static final class CallMetadata {
        @NotNull
        private final ApplicationDefinition application;
        @NotNull
        private final Locale language;
        @NotNull
        private final ZonedDateTime referenceDate;
        @NotNull
        private final Set<IntentQualifier> intentsQualifiers;

        public CallMetadata(@NotNull ApplicationDefinition application, @NotNull Locale language, @NotNull ZonedDateTime referenceDate, @NotNull Set<IntentQualifier> intentsQualifiers) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
            Intrinsics.checkNotNullParameter(intentsQualifiers, (String)"intentsQualifiers");
            this.application = application;
            this.language = language;
            this.referenceDate = referenceDate;
            this.intentsQualifiers = intentsQualifiers;
        }

        @NotNull
        public final ApplicationDefinition getApplication() {
            return this.application;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final ZonedDateTime getReferenceDate() {
            return this.referenceDate;
        }

        @NotNull
        public final Set<IntentQualifier> getIntentsQualifiers() {
            return this.intentsQualifiers;
        }

        @NotNull
        public final ApplicationDefinition component1() {
            return this.application;
        }

        @NotNull
        public final Locale component2() {
            return this.language;
        }

        @NotNull
        public final ZonedDateTime component3() {
            return this.referenceDate;
        }

        @NotNull
        public final Set<IntentQualifier> component4() {
            return this.intentsQualifiers;
        }

        @NotNull
        public final CallMetadata copy(@NotNull ApplicationDefinition application, @NotNull Locale language, @NotNull ZonedDateTime referenceDate, @NotNull Set<IntentQualifier> intentsQualifiers) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
            Intrinsics.checkNotNullParameter(intentsQualifiers, (String)"intentsQualifiers");
            return new CallMetadata(application, language, referenceDate, intentsQualifiers);
        }

        public static /* synthetic */ CallMetadata copy$default(CallMetadata callMetadata, ApplicationDefinition applicationDefinition, Locale locale, ZonedDateTime zonedDateTime, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                applicationDefinition = callMetadata.application;
            }
            if ((n & 2) != 0) {
                locale = callMetadata.language;
            }
            if ((n & 4) != 0) {
                zonedDateTime = callMetadata.referenceDate;
            }
            if ((n & 8) != 0) {
                set = callMetadata.intentsQualifiers;
            }
            return callMetadata.copy(applicationDefinition, locale, zonedDateTime, set);
        }

        @NotNull
        public String toString() {
            return "CallMetadata(application=" + this.application + ", language=" + this.language + ", referenceDate=" + this.referenceDate + ", intentsQualifiers=" + this.intentsQualifiers + ")";
        }

        public int hashCode() {
            int result = this.application.hashCode();
            result = result * 31 + this.language.hashCode();
            result = result * 31 + this.referenceDate.hashCode();
            result = result * 31 + ((Object)this.intentsQualifiers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallMetadata)) {
                return false;
            }
            CallMetadata callMetadata = (CallMetadata)other;
            if (!Intrinsics.areEqual((Object)this.application, (Object)callMetadata.application)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)callMetadata.language)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referenceDate, (Object)callMetadata.referenceDate)) {
                return false;
            }
            return Intrinsics.areEqual(this.intentsQualifiers, callMetadata.intentsQualifiers);
        }
    }
}

