/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.sagemaker;

import ai.tock.nlp.sagemaker.SagemakerAwsClientProperties;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.SageMakerClientBuilder;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.EndpointStatus;
import software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeClient;
import software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeClientBuilder;
import software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest;
import software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005\u0018\u0019\u001a\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/tock/nlp/sagemaker/SagemakerAwsClient;", "", "configuration", "Lai/tock/nlp/sagemaker/SagemakerAwsClientProperties;", "(Lai/tock/nlp/sagemaker/SagemakerAwsClientProperties;)V", "name", "", "getName", "()Ljava/lang/String;", "runtimeClient", "Lsoftware/amazon/awssdk/services/sagemakerruntime/SageMakerRuntimeClient;", "sagemakerClient", "Lsoftware/amazon/awssdk/services/sagemaker/SageMakerClient;", "healthcheck", "", "invokeSageMakerEntitiesEndpoint", "Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedEntitiesResponse;", "payload", "invokeSageMakerIntentEndpoint", "Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedIntentResponse;", "parseEntities", "request", "Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedRequest;", "parseIntent", "ParsedEntitiesResponse", "ParsedEntity", "ParsedIntent", "ParsedIntentResponse", "ParsedRequest", "tock-nlp-model-sagemaker"})
@SourceDebugExtension(value={"SMAP\nSagemakerAwsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SagemakerAwsClient.kt\nai/tock/nlp/sagemaker/SagemakerAwsClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n131#2:106\n54#2:107\n132#2:108\n61#2,8:109\n71#2:118\n131#2:119\n54#2:120\n132#2:121\n61#2,8:122\n71#2:131\n1#3:117\n1#3:130\n*S KotlinDebug\n*F\n+ 1 SagemakerAwsClient.kt\nai/tock/nlp/sagemaker/SagemakerAwsClient\n*L\n81#1:106\n81#1:107\n81#1:108\n81#1:109,8\n81#1:118\n93#1:119\n93#1:120\n93#1:121\n93#1:122,8\n93#1:131\n81#1:117\n93#1:130\n*E\n"})
public final class SagemakerAwsClient {
    @NotNull
    private final SagemakerAwsClientProperties configuration;
    @NotNull
    private final String name;
    @NotNull
    private final SageMakerRuntimeClient runtimeClient;
    @NotNull
    private final SageMakerClient sagemakerClient;

    public SagemakerAwsClient(@NotNull SagemakerAwsClientProperties configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.name = this.configuration.getName();
        Object object = ((SageMakerRuntimeClientBuilder)SageMakerRuntimeClient.builder().region(this.configuration.getRegion())).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        this.runtimeClient = (SageMakerRuntimeClient)object;
        Object object2 = ((SageMakerClientBuilder)SageMakerClient.builder().region(this.configuration.getRegion())).build();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"build(...)");
        this.sagemakerClient = (SageMakerClient)object2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ParsedIntentResponse parseIntent(@NotNull ParsedRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.invokeSageMakerIntentEndpoint(request.getText());
    }

    @NotNull
    public final ParsedEntitiesResponse parseEntities(@NotNull ParsedRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.invokeSageMakerEntitiesEndpoint(request.getText());
    }

    /*
     * WARNING - void declaration
     */
    private final ParsedIntentResponse invokeSageMakerIntentEndpoint(String payload) {
        void $this$checkTypeMismatch$iv$iv;
        void $this$readValue$iv;
        InvokeEndpointRequest endpointRequest = (InvokeEndpointRequest)InvokeEndpointRequest.builder().endpointName(this.configuration.getEndpointName()).contentType(this.configuration.getContentType()).body(SdkBytes.fromString((String)("{\"inputs\":\"" + payload + "\"}"), (Charset)Charset.defaultCharset())).build();
        InvokeEndpointResponse response = this.runtimeClient.invokeEndpoint(endpointRequest);
        ObjectMapper objectMapper = JacksonKt.getMapper();
        InputStream inputStream = response.body().asInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"asInputStream(...)");
        InputStream src$iv = inputStream;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<ParsedIntentResponse>(){});
        boolean $i$f$checkTypeMismatch = false;
        if (!($this$checkTypeMismatch$iv$iv instanceof ParsedIntentResponse)) {
            String string;
            String nullability$iv$iv = "(non-null)";
            StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(ParsedIntentResponse.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
            void v2 = $this$checkTypeMismatch$iv$iv;
            if (v2 != null) {
                void it$iv$iv;
                void var10_11 = v2;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                stringBuilder = stringBuilder2;
            } else {
                string = null;
            }
            String string2 = stringBuilder.append(string).toString();
            throw new RuntimeJsonMappingException(string2);
        }
        return (ParsedIntentResponse)$this$checkTypeMismatch$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ParsedEntitiesResponse invokeSageMakerEntitiesEndpoint(String payload) {
        void $this$checkTypeMismatch$iv$iv;
        void $this$readValue$iv;
        InvokeEndpointRequest endpointRequest = (InvokeEndpointRequest)InvokeEndpointRequest.builder().endpointName(this.configuration.getEndpointName()).contentType(this.configuration.getContentType()).body(SdkBytes.fromString((String)("{\"inputs\":\"" + payload + "\"}"), (Charset)Charset.defaultCharset())).build();
        InvokeEndpointResponse response = this.runtimeClient.invokeEndpoint(endpointRequest);
        ObjectMapper objectMapper = JacksonKt.getMapper();
        InputStream inputStream = response.body().asInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"asInputStream(...)");
        InputStream src$iv = inputStream;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<List<? extends ParsedEntity>>(){});
        boolean $i$f$checkTypeMismatch = false;
        if (!($this$checkTypeMismatch$iv$iv instanceof List)) {
            String string;
            String nullability$iv$iv = "(non-null)";
            StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(List.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
            void v2 = $this$checkTypeMismatch$iv$iv;
            if (v2 != null) {
                void it$iv$iv;
                void var11_11 = v2;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                stringBuilder = stringBuilder2;
            } else {
                string = null;
            }
            String string2 = stringBuilder.append(string).toString();
            throw new RuntimeJsonMappingException(string2);
        }
        List entities = (List)$this$checkTypeMismatch$iv$iv;
        return new ParsedEntitiesResponse(entities);
    }

    public final boolean healthcheck() {
        DescribeEndpointRequest endpointRequest = (DescribeEndpointRequest)DescribeEndpointRequest.builder().endpointName(this.configuration.getEndpointName()).build();
        DescribeEndpointResponse response = this.sagemakerClient.describeEndpoint(endpointRequest);
        return response.endpointStatus() == EndpointStatus.IN_SERVICE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedEntitiesResponse;", "", "entities", "", "Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedEntity;", "(Ljava/util/List;)V", "getEntities", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-model-sagemaker"})
    public static final class ParsedEntitiesResponse {
        @NotNull
        private final List<ParsedEntity> entities;

        public ParsedEntitiesResponse(@NotNull List<ParsedEntity> entities) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            this.entities = entities;
        }

        public /* synthetic */ ParsedEntitiesResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<ParsedEntity> getEntities() {
            return this.entities;
        }

        @NotNull
        public final List<ParsedEntity> component1() {
            return this.entities;
        }

        @NotNull
        public final ParsedEntitiesResponse copy(@NotNull List<ParsedEntity> entities) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            return new ParsedEntitiesResponse(entities);
        }

        public static /* synthetic */ ParsedEntitiesResponse copy$default(ParsedEntitiesResponse parsedEntitiesResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = parsedEntitiesResponse.entities;
            }
            return parsedEntitiesResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "ParsedEntitiesResponse(entities=" + this.entities + ")";
        }

        public int hashCode() {
            return ((Object)this.entities).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedEntitiesResponse)) {
                return false;
            }
            ParsedEntitiesResponse parsedEntitiesResponse = (ParsedEntitiesResponse)other;
            return Intrinsics.areEqual(this.entities, parsedEntitiesResponse.entities);
        }

        public ParsedEntitiesResponse() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006!"}, d2={"Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedEntity;", "", "start", "", "end", "value", "", "entity", "confidence", "", "role", "(IILjava/lang/String;Ljava/lang/String;DLjava/lang/String;)V", "getConfidence", "()D", "getEnd", "()I", "getEntity", "()Ljava/lang/String;", "getRole", "getStart", "getValue", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "tock-nlp-model-sagemaker"})
    public static final class ParsedEntity {
        private final int start;
        private final int end;
        @NotNull
        private final String value;
        @NotNull
        private final String entity;
        private final double confidence;
        @Nullable
        private final String role;

        public ParsedEntity(int start, int end, @NotNull String value, @NotNull String entity, double confidence, @Nullable String role) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            this.start = start;
            this.end = end;
            this.value = value;
            this.entity = entity;
            this.confidence = confidence;
            this.role = role;
        }

        public /* synthetic */ ParsedEntity(int n, int n2, String string, String string2, double d, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x20) != 0) {
                string3 = null;
            }
            this(n, n2, string, string2, d, string3);
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getEntity() {
            return this.entity;
        }

        public final double getConfidence() {
            return this.confidence;
        }

        @Nullable
        public final String getRole() {
            return this.role;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final String component3() {
            return this.value;
        }

        @NotNull
        public final String component4() {
            return this.entity;
        }

        public final double component5() {
            return this.confidence;
        }

        @Nullable
        public final String component6() {
            return this.role;
        }

        @NotNull
        public final ParsedEntity copy(int start, int end, @NotNull String value, @NotNull String entity, double confidence, @Nullable String role) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new ParsedEntity(start, end, value, entity, confidence, role);
        }

        public static /* synthetic */ ParsedEntity copy$default(ParsedEntity parsedEntity, int n, int n2, String string, String string2, double d, String string3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = parsedEntity.start;
            }
            if ((n3 & 2) != 0) {
                n2 = parsedEntity.end;
            }
            if ((n3 & 4) != 0) {
                string = parsedEntity.value;
            }
            if ((n3 & 8) != 0) {
                string2 = parsedEntity.entity;
            }
            if ((n3 & 0x10) != 0) {
                d = parsedEntity.confidence;
            }
            if ((n3 & 0x20) != 0) {
                string3 = parsedEntity.role;
            }
            return parsedEntity.copy(n, n2, string, string2, d, string3);
        }

        @NotNull
        public String toString() {
            return "ParsedEntity(start=" + this.start + ", end=" + this.end + ", value=" + this.value + ", entity=" + this.entity + ", confidence=" + this.confidence + ", role=" + this.role + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.value.hashCode();
            result = result * 31 + this.entity.hashCode();
            result = result * 31 + Double.hashCode(this.confidence);
            result = result * 31 + (this.role == null ? 0 : this.role.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedEntity)) {
                return false;
            }
            ParsedEntity parsedEntity = (ParsedEntity)other;
            if (this.start != parsedEntity.start) {
                return false;
            }
            if (this.end != parsedEntity.end) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)parsedEntity.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.entity, (Object)parsedEntity.entity)) {
                return false;
            }
            if (Double.compare(this.confidence, parsedEntity.confidence) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.role, (Object)parsedEntity.role);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ&\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedIntent;", "", "name", "", "score", "", "(Ljava/lang/String;Ljava/lang/Double;)V", "getName", "()Ljava/lang/String;", "getScore", "()Ljava/lang/Double;", "Ljava/lang/Double;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Double;)Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedIntent;", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-model-sagemaker"})
    public static final class ParsedIntent {
        @Nullable
        private final String name;
        @Nullable
        private final Double score;

        public ParsedIntent(@Nullable String name, @Nullable Double score) {
            this.name = name;
            this.score = score;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Double getScore() {
            return this.score;
        }

        @Nullable
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final Double component2() {
            return this.score;
        }

        @NotNull
        public final ParsedIntent copy(@Nullable String name, @Nullable Double score) {
            return new ParsedIntent(name, score);
        }

        public static /* synthetic */ ParsedIntent copy$default(ParsedIntent parsedIntent, String string, Double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = parsedIntent.name;
            }
            if ((n & 2) != 0) {
                d = parsedIntent.score;
            }
            return parsedIntent.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "ParsedIntent(name=" + this.name + ", score=" + this.score + ")";
        }

        public int hashCode() {
            int result = this.name == null ? 0 : this.name.hashCode();
            result = result * 31 + (this.score == null ? 0 : ((Object)this.score).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedIntent)) {
                return false;
            }
            ParsedIntent parsedIntent = (ParsedIntent)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)parsedIntent.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.score, (Object)parsedIntent.score);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedIntentResponse;", "", "intent", "Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedIntent;", "intent_ranking", "", "(Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedIntent;Ljava/util/List;)V", "getIntent", "()Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedIntent;", "getIntent_ranking", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-model-sagemaker"})
    public static final class ParsedIntentResponse {
        @Nullable
        private final ParsedIntent intent;
        @NotNull
        private final List<ParsedIntent> intent_ranking;

        public ParsedIntentResponse(@Nullable ParsedIntent intent, @NotNull List<ParsedIntent> intent_ranking) {
            Intrinsics.checkNotNullParameter(intent_ranking, (String)"intent_ranking");
            this.intent = intent;
            this.intent_ranking = intent_ranking;
        }

        public /* synthetic */ ParsedIntentResponse(ParsedIntent parsedIntent, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                parsedIntent = null;
            }
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(parsedIntent, list);
        }

        @Nullable
        public final ParsedIntent getIntent() {
            return this.intent;
        }

        @NotNull
        public final List<ParsedIntent> getIntent_ranking() {
            return this.intent_ranking;
        }

        @Nullable
        public final ParsedIntent component1() {
            return this.intent;
        }

        @NotNull
        public final List<ParsedIntent> component2() {
            return this.intent_ranking;
        }

        @NotNull
        public final ParsedIntentResponse copy(@Nullable ParsedIntent intent, @NotNull List<ParsedIntent> intent_ranking) {
            Intrinsics.checkNotNullParameter(intent_ranking, (String)"intent_ranking");
            return new ParsedIntentResponse(intent, intent_ranking);
        }

        public static /* synthetic */ ParsedIntentResponse copy$default(ParsedIntentResponse parsedIntentResponse, ParsedIntent parsedIntent, List list, int n, Object object) {
            if ((n & 1) != 0) {
                parsedIntent = parsedIntentResponse.intent;
            }
            if ((n & 2) != 0) {
                list = parsedIntentResponse.intent_ranking;
            }
            return parsedIntentResponse.copy(parsedIntent, list);
        }

        @NotNull
        public String toString() {
            return "ParsedIntentResponse(intent=" + this.intent + ", intent_ranking=" + this.intent_ranking + ")";
        }

        public int hashCode() {
            int result = this.intent == null ? 0 : this.intent.hashCode();
            result = result * 31 + ((Object)this.intent_ranking).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedIntentResponse)) {
                return false;
            }
            ParsedIntentResponse parsedIntentResponse = (ParsedIntentResponse)other;
            if (!Intrinsics.areEqual((Object)this.intent, (Object)parsedIntentResponse.intent)) {
                return false;
            }
            return Intrinsics.areEqual(this.intent_ranking, parsedIntentResponse.intent_ranking);
        }

        public ParsedIntentResponse() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/tock/nlp/sagemaker/SagemakerAwsClient$ParsedRequest;", "", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-model-sagemaker"})
    public static final class ParsedRequest {
        @NotNull
        private final String text;

        public ParsedRequest(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final ParsedRequest copy(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new ParsedRequest(text);
        }

        public static /* synthetic */ ParsedRequest copy$default(ParsedRequest parsedRequest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = parsedRequest.text;
            }
            return parsedRequest.copy(string);
        }

        @NotNull
        public String toString() {
            return "ParsedRequest(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedRequest)) {
                return false;
            }
            ParsedRequest parsedRequest = (ParsedRequest)other;
            return Intrinsics.areEqual((Object)this.text, (Object)parsedRequest.text);
        }
    }
}

