/*
 * Decompiled with CFR 0.152.
 */
package ai.traceable.agent.java.instrument;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.List;

public class TraceableAgent {
    public static void main(String ... args) throws NoSuchFieldException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        String agentJar;
        Class<?> virtualMachineDescriptorClass;
        Class<?> virtualMachineClass;
        if (args.length == 0) {
            try {
                System.out.println(TraceableAgent.class.getPackage().getImplementationVersion());
            }
            catch (Exception var2) {
                System.out.println("Failed to parse agent version");
                var2.printStackTrace();
            }
            return;
        }
        System.out.println("Dynamically attaching javaagent");
        try {
            virtualMachineClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            virtualMachineDescriptorClass = Class.forName("com.sun.tools.attach.VirtualMachineDescriptor");
        }
        catch (ClassNotFoundException e) {
            System.out.println("ERROR: Class not found. Check if jdk's tools.jar is added to classpath");
            e.printStackTrace();
            return;
        }
        String target = args[0];
        Object targetJvm_VMDescriptor = null;
        Method listMethod = virtualMachineClass.getDeclaredMethod("list", new Class[0]);
        listMethod.setAccessible(true);
        List descriptorsList = (List)listMethod.invoke(null, new Object[0]);
        for (Object descriptor : descriptorsList) {
            Field displayName = virtualMachineDescriptorClass.getDeclaredField("displayName");
            displayName.setAccessible(true);
            if (((String)displayName.get(descriptor)).startsWith(target)) {
                targetJvm_VMDescriptor = descriptor;
                break;
            }
            Field id = virtualMachineDescriptorClass.getDeclaredField("id");
            id.setAccessible(true);
            if (!id.get(descriptor).equals(target)) continue;
            targetJvm_VMDescriptor = descriptor;
            break;
        }
        if (targetJvm_VMDescriptor == null) {
            System.out.println("ERROR: Could not find target jvm with name or id: " + target);
            return;
        }
        try {
            agentJar = new File(TraceableAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            System.out.println("ERROR: Unable to get location of agent jar");
            e.printStackTrace();
            return;
        }
        String agentArgs = null;
        if (args.length > 1) {
            agentArgs = args[1];
        }
        try {
            Method attachMethod = virtualMachineClass.getDeclaredMethod("attach", virtualMachineDescriptorClass);
            attachMethod.setAccessible(true);
            Object vm = attachMethod.invoke(null, targetJvm_VMDescriptor);
            Method loadAgentMethod = virtualMachineClass.getDeclaredMethod("loadAgent", String.class, String.class);
            loadAgentMethod.setAccessible(true);
            loadAgentMethod.invoke(vm, agentJar, agentArgs);
            Method detachMethod = virtualMachineClass.getDeclaredMethod("detach", new Class[0]);
            detachMethod.setAccessible(true);
            detachMethod.invoke(vm, new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("ERROR: Failed to attach javaagent dynamically");
            t.printStackTrace();
            return;
        }
        try {
            System.out.println(TraceableAgent.class.getPackage().getImplementationVersion());
            System.out.println("Attached javaagent dynamically to java process: " + target);
        }
        catch (Exception var2) {
            System.out.println("Failed to parse agent version");
            var2.printStackTrace();
        }
    }
}

