/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.buffer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class BoundedByteArrayOutputStream
extends ByteArrayOutputStream {
    private final int maxCapacity;
    private final Charset charset;

    BoundedByteArrayOutputStream(int maxCapacity, Charset charset) {
        this.maxCapacity = maxCapacity;
        this.charset = charset;
    }

    BoundedByteArrayOutputStream(int maxCapacity, int size, Charset charset) {
        super(size);
        this.maxCapacity = maxCapacity;
        this.charset = charset;
    }

    public synchronized String toStringWithSuppliedCharset() throws UnsupportedEncodingException {
        return super.toString(this.charset.name());
    }

    @Override
    public synchronized void write(int b) {
        if (this.size() == this.maxCapacity) {
            return;
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        int size = this.size();
        if (size + len > this.maxCapacity) {
            super.write(b, off, this.maxCapacity - size);
            return;
        }
        super.write(b, off, len);
    }
}

