/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.utils;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ContentTypeCharsetUtils {
    private static final Logger log = LoggerFactory.getLogger(ContentTypeCharsetUtils.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;

    private ContentTypeCharsetUtils() {
    }

    public static Charset toCharset(String charsetName) {
        if (charsetName == null || charsetName.isEmpty()) {
            return DEFAULT_CHARSET;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception e) {
            log.error("Could not parse encoding {} to charset, using default {}", (Object)charsetName, (Object)DEFAULT_CHARSET);
            return DEFAULT_CHARSET;
        }
    }
}

