/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.CassandraExtract;
import ai.tripl.arc.extract.CassandraExtractStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple10;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CassandraExtractStage$
implements Serializable {
    public static final CassandraExtractStage$ MODULE$;

    static {
        new CassandraExtractStage$();
    }

    public Option<Dataset<Row>> execute(CassandraExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Option<Object> option;
        block18: {
            BoxedUnit boxedUnit;
            Dataset dataset;
            block15: {
                Dataset dataset2;
                block17: {
                    List partitionCols;
                    Dataset df;
                    block16: {
                        List<String> list;
                        block11: {
                            Option<Object> option2;
                            block14: {
                                Dataset dataset3;
                                block13: {
                                    block12: {
                                        try {
                                            df = arcContext.isStreaming() ? spark.emptyDataFrame() : spark.read().format("org.apache.spark.sql.cassandra").options(stage.params()).options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)stage.table()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyspace"), (Object)stage.keyspace())}))).load();
                                        }
                                        catch (Exception exception) {
                                            throw new DetailException(stage, exception){
                                                private final scala.collection.mutable.Map<String, Object> detail;

                                                public scala.collection.mutable.Map<String, Object> detail() {
                                                    return this.detail;
                                                }
                                                {
                                                    this.detail = stage$1.stageDetail();
                                                }
                                            };
                                        }
                                        list = stage.partitionBy();
                                        if (!Nil$.MODULE$.equals(list)) break block11;
                                        option2 = stage.numPartitions();
                                        if (!(option2 instanceof Some)) break block12;
                                        Some some = (Some)option2;
                                        int numPartitions = BoxesRunTime.unboxToInt((Object)some.x());
                                        dataset3 = df.repartition(numPartitions);
                                        break block13;
                                    }
                                    if (!None$.MODULE$.equals(option2)) break block14;
                                    dataset3 = df;
                                }
                                dataset = dataset3;
                                break block15;
                            }
                            throw new MatchError(option2);
                        }
                        partitionCols = (List)list.map((Function1)new Serializable(df){
                            public static final long serialVersionUID = 0L;
                            private final Dataset df$1;

                            public final Column apply(String col) {
                                return this.df$1.apply(col);
                            }
                            {
                                this.df$1 = df$1;
                            }
                        }, List$.MODULE$.canBuildFrom());
                        option = stage.numPartitions();
                        if (!(option instanceof Some)) break block16;
                        Some some = (Some)option;
                        int numPartitions = BoxesRunTime.unboxToInt((Object)some.x());
                        dataset2 = df.repartition(numPartitions, (Seq)partitionCols);
                        break block17;
                    }
                    if (!None$.MODULE$.equals(option)) break block18;
                    dataset2 = df.repartition((Seq)partitionCols);
                }
                dataset = dataset2;
            }
            Dataset repartitionedDF = dataset;
            if (arcContext.immutableViews()) {
                repartitionedDF.createTempView(stage.outputView());
            } else {
                repartitionedDF.createOrReplaceTempView(stage.outputView());
            }
            if (repartitionedDF.isStreaming()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
                stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
                stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
                if (stage.persist()) {
                    repartitionedDF.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
                    boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        }
        throw new MatchError(option);
    }

    public CassandraExtractStage apply(CassandraExtract plugin, String name, Option<String> description, String table, String keyspace, String outputView, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy) {
        return new CassandraExtractStage(plugin, name, description, table, keyspace, outputView, params, persist, numPartitions, partitionBy);
    }

    public Option<Tuple10<CassandraExtract, String, Option<String>, String, String, String, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>>> unapply(CassandraExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.table(), (Object)x$0.keyspace(), (Object)x$0.outputView(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraExtractStage$() {
        MODULE$ = this;
    }
}

