/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.whylogs.core.ColumnProfile;
import com.whylogs.core.ModelProfile;
import com.whylogs.core.SchemaInformation;
import com.whylogs.core.iterator.ColumnsChunkSegmentIterator;
import com.whylogs.core.message.ColumnMessage;
import com.whylogs.core.message.ColumnSummary;
import com.whylogs.core.message.ColumnsChunkSegment;
import com.whylogs.core.message.DatasetMetadataSegment;
import com.whylogs.core.message.DatasetProfileMessage;
import com.whylogs.core.message.DatasetProperties;
import com.whylogs.core.message.DatasetSummary;
import com.whylogs.core.message.MessageSegment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;

public class DatasetProfile
implements Serializable {
    private static final long serialVersionUID = -9221998596693275458L;
    public static final String TAG_PREFIX = "whylogs.tag.";
    String sessionId;
    Instant sessionTimestamp;
    Instant dataTimestamp;
    Map<String, ColumnProfile> columns;
    Map<String, String> tags;
    Map<String, String> metadata;
    @Nullable
    ModelProfile modelProfile;

    public DatasetProfile(@NonNull String sessionId, @NonNull Instant sessionTimestamp, @Nullable Instant dataTimestamp, @NonNull Map<String, String> tags, @NonNull Map<String, ColumnProfile> columns) {
        this(sessionId, sessionTimestamp, dataTimestamp, new ConcurrentHashMap<String, ColumnProfile>(columns), new ConcurrentHashMap<String, String>(tags), new ConcurrentHashMap<String, String>(), null);
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (sessionTimestamp == null) {
            throw new NullPointerException("sessionTimestamp is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
    }

    public DatasetProfile(@NonNull String sessionId, @NonNull Instant sessionTimestamp, @NonNull Map<String, String> tags) {
        this(sessionId, sessionTimestamp, null, tags, Collections.emptyMap());
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (sessionTimestamp == null) {
            throw new NullPointerException("sessionTimestamp is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
    }

    public DatasetProfile(String sessionId, Instant sessionTimestamp) {
        this(sessionId, sessionTimestamp, Collections.emptyMap());
    }

    public Map<String, ColumnProfile> getColumns() {
        return Collections.unmodifiableMap(this.columns);
    }

    public ModelProfile getModelProfile() {
        return this.modelProfile;
    }

    public DatasetProfile withTag(String key, String value) {
        this.tags.put(TAG_PREFIX + key, value);
        return this;
    }

    public DatasetProfile withMetadata(String key, String value) {
        this.metadata.put(key, value);
        return this;
    }

    public DatasetProfile withAllMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
        return this;
    }

    private void validate() {
        Preconditions.checkNotNull((Object)this.sessionId);
        Preconditions.checkNotNull((Object)this.sessionTimestamp);
        Preconditions.checkNotNull(this.columns);
        Preconditions.checkNotNull(this.metadata);
        Preconditions.checkNotNull(this.tags);
    }

    public void track(String columnName, Object data) {
        this.trackSingleColumn(columnName, data);
    }

    private void trackSingleColumn(String columnName, Object data) {
        ColumnProfile columnProfile = this.columns.computeIfAbsent(columnName, ColumnProfile::new);
        columnProfile.track(data);
    }

    public void track(Map<String, ?> columns) {
        columns.forEach(this::track);
        if (this.modelProfile != null) {
            this.modelProfile.track(columns);
        }
    }

    public DatasetProfile withClassificationModel(String prediction, String target, String score, Iterable<String> additionalOutputFields) {
        ModelProfile model = new ModelProfile(prediction, target, score, additionalOutputFields);
        return new DatasetProfile(this.sessionId, this.sessionTimestamp, this.dataTimestamp, this.columns, this.tags, this.metadata, model);
    }

    public DatasetProfile withClassificationModel(String prediction, String target, String score) {
        return this.withClassificationModel(prediction, target, score, Collections.emptyList());
    }

    public DatasetProfile withRegressionModel(String prediction, String target) {
        return this.withRegressionModel(prediction, target, Collections.emptyList());
    }

    public DatasetProfile withRegressionModel(String prediction, String target, Iterable<String> additionalOutputFields) {
        ModelProfile model = new ModelProfile(prediction, target, additionalOutputFields);
        return new DatasetProfile(this.sessionId, this.sessionTimestamp, this.dataTimestamp, this.columns, this.tags, this.metadata, model);
    }

    public DatasetSummary toSummary() {
        this.validate();
        Map<String, ColumnSummary> summaryColumns = this.columns.values().stream().map(Pair::fromColumn).collect(Collectors.toMap(Pair::getName, Pair::getStatistics));
        DatasetSummary.Builder summary = DatasetSummary.newBuilder().setProperties(this.toDatasetProperties()).putAllColumns(summaryColumns);
        return summary.build();
    }

    public Iterator<MessageSegment> toChunkIterator() {
        this.validate();
        String marker = this.sessionId + UUID.randomUUID().toString();
        DatasetProperties.Builder properties = this.toDatasetProperties();
        DatasetMetadataSegment.Builder metadataBuilder = DatasetMetadataSegment.newBuilder().setProperties(properties).setMarker(marker);
        MessageSegment metadataSegment = MessageSegment.newBuilder().setMarker(marker).setMetadata(metadataBuilder).build();
        Iterator<ColumnMessage> chunkedColumns = this.columns.values().stream().map(ColumnProfile::toProtobuf).map(ColumnMessage.Builder::build).iterator();
        Iterator columnSegmentMessages = Iterators.transform((Iterator)new ColumnsChunkSegmentIterator(chunkedColumns, marker), msg -> MessageSegment.newBuilder().setColumns((ColumnsChunkSegment)msg).build());
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)metadataSegment), (Iterator)columnSegmentMessages);
    }

    public DatasetProfile mergeStrict(@NonNull DatasetProfile other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)Objects.equals(this.sessionId, other.sessionId), (Object)String.format("Mismatched name. Current name [%s] is merged with [%s]", this.sessionId, other.sessionId));
        Preconditions.checkArgument((boolean)Objects.equals(this.sessionTimestamp, other.sessionTimestamp), (Object)String.format("Mismatched session timestamp. Current ts [%s] is merged with [%s]", this.sessionTimestamp, other.sessionTimestamp));
        Preconditions.checkArgument((boolean)Objects.equals(this.dataTimestamp, other.dataTimestamp), (Object)String.format("Mismatched data timestamp. Current ts [%s] is merged with [%s]", this.dataTimestamp, other.dataTimestamp));
        Preconditions.checkArgument((boolean)Objects.equals(this.tags, other.tags), (Object)String.format("Mismatched tags. Current %s being merged with %s", this.tags, other.tags));
        return this.doMerge(other, this.tags);
    }

    public DatasetProfile merge(@NonNull DatasetProfile other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (this.tags.isEmpty()) {
            return this.doMerge(other, (Map<String, String>)ImmutableMap.copyOf(other.tags));
        }
        ImmutableMap.Builder sharedTags = ImmutableMap.builder();
        for (String tagKey : this.tags.keySet()) {
            String tagValue = this.tags.get(tagKey);
            if (!tagValue.equals(other.tags.get(tagKey))) continue;
            sharedTags.put((Object)tagKey, (Object)tagValue);
        }
        return this.doMerge(other, (Map<String, String>)sharedTags.build());
    }

    private DatasetProfile doMerge(@NonNull DatasetProfile other, Map<String, String> tags) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.validate();
        other.validate();
        Instant datasetTimestamp = this.dataTimestamp == null ? other.getDataTimestamp() : this.dataTimestamp;
        DatasetProfile result = new DatasetProfile(this.sessionId, this.sessionTimestamp, datasetTimestamp, tags, Collections.emptyMap());
        ImmutableMap.Builder sharedMetadata = ImmutableMap.builder();
        for (String mKey : this.metadata.keySet()) {
            String mValue = this.metadata.get(mKey);
            if (!mValue.equals(other.metadata.get(mKey))) continue;
            sharedMetadata.put((Object)mKey, (Object)mValue);
        }
        result.withAllMetadata((Map<String, String>)sharedMetadata.build());
        Sets.SetView unionColumns = Sets.union(this.columns.keySet(), other.columns.keySet());
        for (String column : unionColumns) {
            ColumnProfile emptyColumn = new ColumnProfile(column);
            ColumnProfile thisColumn = this.columns.getOrDefault(column, emptyColumn);
            ColumnProfile otherColumn = other.columns.getOrDefault(column, emptyColumn);
            result.columns.put(column, thisColumn.merge(otherColumn));
        }
        if (this.modelProfile != null) {
            result.modelProfile = this.modelProfile.merge(other.modelProfile);
        } else if (other.modelProfile != null) {
            result.modelProfile = other.modelProfile.copy();
        }
        return result;
    }

    public DatasetProfileMessage.Builder toProtobuf() {
        this.validate();
        DatasetProperties.Builder properties = this.toDatasetProperties();
        DatasetProfileMessage.Builder builder = DatasetProfileMessage.newBuilder().setProperties(properties);
        this.columns.forEach((k, v) -> builder.putColumns((String)k, v.toProtobuf().build()));
        if (this.modelProfile != null) {
            builder.setModeProfile(this.modelProfile.toProtobuf());
        }
        return builder;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.toProtobuf().build().writeDelimitedTo(out);
    }

    public byte[] toBytes() throws IOException {
        DatasetProfileMessage msg = this.toProtobuf().build();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(msg.getSerializedSize());
        msg.writeDelimitedTo(bos);
        return bos.toByteArray();
    }

    private DatasetProperties.Builder toDatasetProperties() {
        long dataTimeInMillis = this.dataTimestamp == null ? -1L : this.dataTimestamp.toEpochMilli();
        return DatasetProperties.newBuilder().setSessionId(this.sessionId).setSessionTimestamp(this.sessionTimestamp.toEpochMilli()).setDataTimestamp(dataTimeInMillis).putAllTags(this.tags).putAllMetadata(this.metadata).setSchemaMajorVersion(1).setSchemaMinorVersion(3);
    }

    @Nullable
    public static DatasetProfile fromProtobuf(@Nullable DatasetProfileMessage message) {
        if (message == null || message.getSerializedSize() == 0) {
            return null;
        }
        DatasetProperties props = message.getProperties();
        SchemaInformation.validateSchema(props.getSchemaMajorVersion(), props.getSchemaMinorVersion());
        Map<String, String> tags = props.getTagsMap();
        Instant sessionTimestamp = Instant.ofEpochMilli(props.getSessionTimestamp());
        Instant dataTimestamp = props.getDataTimestamp() < 0L ? null : Instant.ofEpochMilli(props.getDataTimestamp());
        DatasetProfile ds = new DatasetProfile(props.getSessionId(), sessionTimestamp, dataTimestamp, tags, Collections.emptyMap());
        ds.withAllMetadata(props.getMetadataMap());
        message.getColumnsMap().forEach((k, v) -> ds.columns.put((String)k, ColumnProfile.fromProtobuf(v)));
        ds.modelProfile = ModelProfile.fromProtobuf(message.getModeProfile());
        ds.validate();
        return ds;
    }

    public static DatasetProfile parse(InputStream in) throws IOException {
        DatasetProfileMessage msg = DatasetProfileMessage.parseDelimitedFrom(in);
        return DatasetProfile.fromProtobuf(msg);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.validate();
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        DatasetProfile copy = DatasetProfile.parse(in);
        this.sessionId = copy.sessionId;
        this.sessionTimestamp = copy.sessionTimestamp;
        this.dataTimestamp = copy.dataTimestamp;
        this.metadata = copy.metadata;
        this.tags = copy.tags;
        this.columns = copy.columns;
        this.modelProfile = copy.modelProfile;
        this.validate();
    }

    public DatasetProfile(String sessionId, Instant sessionTimestamp, Instant dataTimestamp, Map<String, ColumnProfile> columns, Map<String, String> tags, Map<String, String> metadata, @Nullable ModelProfile modelProfile) {
        this.sessionId = sessionId;
        this.sessionTimestamp = sessionTimestamp;
        this.dataTimestamp = dataTimestamp;
        this.columns = columns;
        this.tags = tags;
        this.metadata = metadata;
        this.modelProfile = modelProfile;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Instant getSessionTimestamp() {
        return this.sessionTimestamp;
    }

    public Instant getDataTimestamp() {
        return this.dataTimestamp;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    static final class Pair {
        private final String name;
        private final ColumnSummary statistics;

        static Pair fromColumn(ColumnProfile column) {
            return new Pair(column.getColumnName(), column.toColumnSummary());
        }

        public Pair(String name, ColumnSummary statistics) {
            this.name = name;
            this.statistics = statistics;
        }

        public String getName() {
            return this.name;
        }

        public ColumnSummary getStatistics() {
            return this.statistics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ColumnSummary this$statistics = this.getStatistics();
            ColumnSummary other$statistics = other.getStatistics();
            return !(this$statistics == null ? other$statistics != null : !((Object)this$statistics).equals(other$statistics));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ColumnSummary $statistics = this.getStatistics();
            result = result * 59 + ($statistics == null ? 43 : ((Object)$statistics).hashCode());
            return result;
        }

        public String toString() {
            return "DatasetProfile.Pair(name=" + this.getName() + ", statistics=" + this.getStatistics() + ")";
        }
    }
}

