/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaInformation {
    private static final Logger log = LoggerFactory.getLogger(SchemaInformation.class);
    static final int SCHEMA_MAJOR_VERSION = 1;
    static final int SCHEMA_MINOR_VERSION = 3;

    static void validateSchema(int majorVersion, int minorVersion) {
        Preconditions.checkArgument((1 == majorVersion ? 1 : 0) != 0, (Object)String.format("Expect major version %s, got %s", 1, majorVersion));
        Preconditions.checkArgument((3 >= minorVersion ? 1 : 0) != 0, (Object)String.format("Does not support forward compatibility. Minor version: %s, got: %s", 3, minorVersion));
        if (3 > minorVersion) {
            log.warn("Expect minor version {}. Got: {}", (Object)3, (Object)minorVersion);
        }
    }

    private SchemaInformation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

